/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.message;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.openas2.lib.message.DispositionException;

public class Disposition {
    public static final String DISP_AUTOMATIC_ACTION = "automatic-action/MDN-sent-automatically; ";
    public static final String DISP_PROCESSED = "automatic-action/MDN-sent-automatically; processed";
    public static final String DISP_PROCESSED_ERROR = "automatic-action/MDN-sent-automatically; processed/Error: ";
    public static final String DISP_UNEXPECTED_ERROR = "automatic-action/MDN-sent-automatically; processed/Error: unexpected-processing-error";
    public static final String DISP_AUTHENTICATION_FAILED = "automatic-action/MDN-sent-automatically; processed/Error: authentication-failed";
    public static final String DISP_DECRYPTION_FAILED = "automatic-action/MDN-sent-automatically; processed/Error: decryption-failed";
    public static final String DISP_SIGNATURE_FAILED = "automatic-action/MDN-sent-automatically; processed/Error: integrity-check-failed";
    private String action;
    private String mdnAction;
    private String status;
    private String statusDescription;
    private String statusModifier;

    public Disposition(String disposition) throws DispositionException {
        if (disposition != null) {
            this.parseDisposition(disposition);
        }
    }

    public Disposition(String action, String mdnAction, String status, String statusModifier, String statusDescription) {
        this.action = action;
        this.mdnAction = mdnAction;
        this.status = status;
        this.statusModifier = statusModifier;
        this.statusDescription = statusDescription;
    }

    public Disposition(String action, String mdnAction, String status) {
        this.action = action;
        this.mdnAction = mdnAction;
        this.status = status;
        this.statusModifier = null;
        this.statusDescription = null;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setMdnAction(String mdnAction) {
        this.mdnAction = mdnAction;
    }

    public String getMdnAction() {
        return this.mdnAction;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusModifier(String statusModifier) {
        this.statusModifier = statusModifier;
    }

    public String getStatusModifier() {
        return this.statusModifier;
    }

    protected String makeDisposition() {
        if (this.getAction() == null && this.getMdnAction() == null && this.getStatus() == null && this.getStatusModifier() == null && this.getStatusDescription() == null) {
            return new String("");
        }
        StringBuffer dispBuf = new StringBuffer();
        dispBuf.append(this.getAction()).append("/").append(this.getMdnAction());
        dispBuf.append("; ").append(this.getStatus());
        if (this.getStatusModifier() != null) {
            dispBuf.append("/").append(this.getStatusModifier()).append(": ");
            if (this.getStatusDescription() != null) {
                dispBuf.append(this.getStatusDescription());
            }
        }
        return dispBuf.toString();
    }

    protected void parseDisposition(String disposition) throws DispositionException {
        StringTokenizer dispTokens = new StringTokenizer(disposition, "/;:", false);
        try {
            this.setAction(dispTokens.nextToken().toLowerCase());
            this.setMdnAction(dispTokens.nextToken().toLowerCase());
            this.setStatus(dispTokens.nextToken().trim().toLowerCase());
            this.setStatusModifier(null);
            this.setStatusDescription(null);
            if (dispTokens.hasMoreTokens()) {
                this.setStatusModifier(dispTokens.nextToken().toLowerCase());
                if (dispTokens.hasMoreTokens()) {
                    this.setStatusDescription(dispTokens.nextToken().trim().toLowerCase());
                }
            }
        }
        catch (NoSuchElementException nsee) {
            throw new DispositionException("Invalid disposition format: " + disposition);
        }
    }

    public String toString() {
        return this.makeDisposition();
    }

    public boolean isWarning() {
        String statusMod = this.getStatusModifier();
        return statusMod != null && statusMod.equalsIgnoreCase("warning");
    }

    public boolean isError() {
        String status = this.getStatus();
        if (status != null && !status.equalsIgnoreCase("processed")) {
            return true;
        }
        String statusMod = this.getStatusModifier();
        return statusMod != null && statusMod.equalsIgnoreCase("error");
    }
}

