/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.lib.cert;

import java.security.Key;
import java.security.cert.Certificate;
import org.openas2.lib.cert.CertificateException;
import org.openas2.lib.cert.ICertificateChooser;
import org.openas2.lib.cert.ICertificateStore;
import org.openas2.lib.message.AS2Message;
import org.openas2.lib.message.AS2MessageMDN;
import org.openas2.lib.message.EDIINTMessage;

public class BasicCertificateChooser
implements ICertificateChooser {
    private ICertificateStore certificateStore;

    public BasicCertificateChooser(ICertificateStore certificateStore) {
        this.certificateStore = certificateStore;
    }

    @Override
    public Certificate getReceiverCertificate(EDIINTMessage msg) throws CertificateException {
        String alias = this.getReceiverAlias(msg);
        return this.getCertificateStore().getCertificate(alias);
    }

    @Override
    public Key getReceiverKey(EDIINTMessage msg) throws CertificateException {
        String alias = this.getReceiverAlias(msg);
        return this.getCertificateStore().getKey(alias, this.getReceiverKeyPassword(msg, alias));
    }

    @Override
    public Certificate getSenderCertificate(EDIINTMessage msg) throws CertificateException {
        String alias = this.getSenderAlias(msg);
        return this.getCertificateStore().getCertificate(alias);
    }

    @Override
    public Key getSenderKey(EDIINTMessage msg) throws CertificateException {
        String alias = this.getSenderAlias(msg);
        return this.getCertificateStore().getKey(alias, this.getReceiverKeyPassword(msg, alias));
    }

    public String getReceiverAlias(EDIINTMessage msg) {
        if (msg instanceof AS2Message) {
            return ((AS2Message)msg).getAS2To();
        }
        if (msg instanceof AS2MessageMDN) {
            return ((AS2MessageMDN)msg).getAS2To();
        }
        return null;
    }

    public String getSenderAlias(EDIINTMessage msg) {
        if (msg instanceof AS2Message) {
            return ((AS2Message)msg).getAS2From();
        }
        if (msg instanceof AS2MessageMDN) {
            return ((AS2MessageMDN)msg).getAS2From();
        }
        return null;
    }

    public char[] getReceiverKeyPassword(EDIINTMessage msg, String alias) {
        return alias.toCharArray();
    }

    public char[] getSenderKeyPassword(EDIINTMessage msg, String alias) {
        return alias.toCharArray();
    }

    @Override
    public ICertificateStore getCertificateStore() {
        return this.certificateStore;
    }
}

