/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import org.apache.commons.io.IOUtils;
import org.openas2.OpenAS2Exception;
import org.openas2.Session;
import org.openas2.WrappedException;
import org.openas2.cmd.Command;
import org.openas2.cmd.CommandResult;
import org.openas2.cmd.processor.BaseCommandProcessor;
import org.openas2.cmd.processor.SocketCommandParser;
import org.openas2.util.CommandTokenizer;

public class SocketCommandProcessor
extends BaseCommandProcessor {
    SocketCommandParser parser;
    private BufferedReader rdr = null;
    private BufferedWriter wrtr = null;
    private SSLServerSocket sslserversocket = null;
    private String userid;
    private String password;

    @Override
    public void init(Session session, Map<String, String> parameters) throws OpenAS2Exception {
        String p = parameters.get("portid");
        try {
            int port = Integer.parseInt(p);
            SSLServerSocketFactory sslserversocketfactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
            this.sslserversocket = (SSLServerSocket)sslserversocketfactory.createServerSocket(port);
            String cipherSuites = System.getProperty("CmdProcessorSocketCipher", "TLS_DH_anon_WITH_AES_256_CBC_SHA");
            String[] enabledCipherSuites = new String[]{cipherSuites};
            try {
                this.sslserversocket.setEnabledCipherSuites(enabledCipherSuites);
            }
            catch (IllegalArgumentException e) {
                throw new OpenAS2Exception("Cipher is not supported. Use command line switch -DCmdProcessorSocketCipher=<some cipher suite> to use one supported by your version of java security.", e);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new OpenAS2Exception(e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new OpenAS2Exception("error converting portid parameter " + e);
        }
        this.userid = parameters.get("userid");
        if (this.userid == null || this.userid.length() < 1) {
            throw new OpenAS2Exception("missing userid parameter");
        }
        this.password = parameters.get("password");
        if (this.password == null || this.password.length() < 1) {
            throw new OpenAS2Exception("missing password parameter");
        }
        try {
            this.parser = new SocketCommandParser();
        }
        catch (Exception e) {
            new OpenAS2Exception(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void processCommand() throws OpenAS2Exception {
        block18: {
            SSLSocket socket = null;
            try {
                CommandTokenizer cmdTkn;
                socket = (SSLSocket)this.sslserversocket.accept();
                socket.setSoTimeout(2000);
                this.rdr = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                this.wrtr = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                String line = this.rdr.readLine();
                this.parser.parse(line);
                if (!this.parser.getUserid().equals(this.userid)) {
                    this.wrtr.write("Bad userid/password");
                    throw new OpenAS2Exception("Bad userid");
                }
                if (!this.parser.getPassword().equals(this.password)) {
                    this.wrtr.write("Bad userid/password");
                    throw new OpenAS2Exception("Bad password");
                }
                String str = this.parser.getCommandText();
                if (str != null && str.length() > 0 && (cmdTkn = new CommandTokenizer(str)).hasMoreTokens()) {
                    String commandName = cmdTkn.nextToken().toLowerCase();
                    if (commandName.equals("exit")) {
                        this.terminate();
                    } else {
                        ArrayList<String> params = new ArrayList<String>();
                        while (cmdTkn.hasMoreTokens()) {
                            params.add(cmdTkn.nextToken());
                        }
                        Command cmd = this.getCommand(commandName);
                        if (cmd != null) {
                            CommandResult result = cmd.execute(params.toArray());
                            if (result.getType() == "OK") {
                                this.wrtr.write(result.toXML());
                            } else {
                                this.wrtr.write("\r\nError executing command\r\n");
                                this.wrtr.write(result.getResult());
                            }
                        } else {
                            this.wrtr.write("Error: command not found> " + commandName + "\r\n");
                            List<Command> l = this.getCommands();
                            this.wrtr.write("List of commands:\r\n");
                            for (int i = 0; i < l.size(); ++i) {
                                cmd = l.get(i);
                                this.wrtr.write(cmd.getName() + "\r\n");
                            }
                        }
                    }
                }
                this.wrtr.flush();
            }
            catch (SocketException socketError) {
                block17: {
                    if (this.sslserversocket.isClosed()) break block17;
                    throw new WrappedException(socketError);
                }
                IOUtils.closeQuietly((Socket)socket);
            }
            catch (IOException e) {
                IOUtils.closeQuietly(socket);
            }
            catch (Exception exception) {
                IOUtils.closeQuietly(socket);
            }
            IOUtils.closeQuietly((Socket)socket);
            break block18;
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(socket);
                    throw throwable;
                }
            }
        }
    }

    @Override
    public void destroy() throws Exception {
        IOUtils.closeQuietly((ServerSocket)this.sslserversocket);
        super.destroy();
    }
}

