/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.cmd.processor;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SocketCommandParser
extends DefaultHandler
implements EntityResolver,
ContentHandler {
    SAXParser parser;
    private String userid;
    private String password;
    private String commandText;
    protected CharArrayWriter contents = new CharArrayWriter();

    public SocketCommandParser() throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        this.parser = spf.newSAXParser();
    }

    public void parse(String inLine) throws SAXException, IOException {
        this.userid = "";
        this.password = "";
        this.commandText = "";
        this.contents.reset();
        StringReader sr = new StringReader(inLine);
        this.parser.parse(new InputSource(sr), (DefaultHandler)this);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.contents.write(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("command")) {
            this.userid = attributes.getValue("id");
            this.password = attributes.getValue("password");
        }
    }

    public String getCommandText() {
        return this.commandText;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUserid() {
        return this.userid;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("command")) {
            this.commandText = this.contents.toString();
        } else {
            this.contents.flush();
        }
    }
}

