/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app.partner;

import java.util.Iterator;
import java.util.List;
import org.openas2.OpenAS2Exception;
import org.openas2.app.partner.AliasedPartnershipsCommand;
import org.openas2.cmd.CommandResult;
import org.openas2.partner.Partnership;
import org.openas2.partner.PartnershipFactory;

public class ListPartnershipsCommand
extends AliasedPartnershipsCommand {
    @Override
    public String getDefaultDescription() {
        return "List all partnerships in the current partnership store";
    }

    @Override
    public String getDefaultName() {
        return "list";
    }

    @Override
    public String getDefaultUsage() {
        return "list";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommandResult execute(PartnershipFactory partFx, Object[] params) throws OpenAS2Exception {
        PartnershipFactory partnershipFactory = partFx;
        synchronized (partnershipFactory) {
            List<Partnership> parts = partFx.getPartnerships();
            Iterator<Partnership> partIt = parts.iterator();
            CommandResult cmdRes = new CommandResult("OK");
            while (partIt.hasNext()) {
                Partnership part = partIt.next();
                cmdRes.getResults().add(part.getName());
            }
            if (cmdRes.getResults().size() == 0) {
                cmdRes.getResults().add("No partnerships available");
            }
            return cmdRes;
        }
    }
}

