/*
 * Decompiled with CFR 0.152.
 */
package org.openas2.app.cert;

import java.security.cert.X509Certificate;
import org.openas2.OpenAS2Exception;
import org.openas2.app.cert.AliasedCertCommand;
import org.openas2.cert.AliasedCertificateFactory;
import org.openas2.cmd.CommandResult;

public class ViewCertCommand
extends AliasedCertCommand {
    @Override
    public String getDefaultDescription() {
        return "View the certificate associated with an alias.";
    }

    @Override
    public String getDefaultName() {
        return "view";
    }

    @Override
    public String getDefaultUsage() {
        return "view <alias>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandResult execute(AliasedCertificateFactory certFx, Object[] params) throws OpenAS2Exception {
        if (params.length < 1) {
            return new CommandResult("INVALID PARAMETER COUNT", this.getUsage());
        }
        AliasedCertificateFactory aliasedCertificateFactory = certFx;
        synchronized (aliasedCertificateFactory) {
            String alias = params[0].toString();
            X509Certificate cert = certFx.getCertificate(alias);
            return new CommandResult("OK", cert.toString());
        }
    }
}

