/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.moses;

import java.io.File;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.filters.mosestext.MosesTextFilter;
import net.sf.okapi.steps.moses.MergingParameters;

@UsingParameters(value=MergingParameters.class)
public class MergingStep
extends BasePipelineStep {
    static final String NAME = "Moses InlineText Leveraging";
    private LocaleId sourceLocale;
    private LocaleId targetLocale;
    private URI inputURI;
    private RawDocument mosesDoc;
    private MosesTextFilter filter;
    private MergingParameters params = new MergingParameters();

    @Override
    public String getDescription() {
        return "Leverages an original source document with its corresponding Moses InlineText file. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.SOURCE_LOCALE)
    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.INPUT_URI)
    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    @StepParameterMapping(parameterType=StepParameterType.SECOND_INPUT_RAWDOC)
    public void setSecondInput(RawDocument secondInput) {
        this.mosesDoc = secondInput;
    }

    @Override
    public MergingParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (MergingParameters)params;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument(event.getStartDocument());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event.getTextUnit());
            }
        }
        return event;
    }

    private void processStartDocument(StartDocument sd) {
        RawDocument rd;
        IParameters prm;
        if (this.params.getForceAltTransOutput() && (prm = sd.getFilterParameters()) != null) {
            prm.setBoolean("addAltTrans", true);
            prm.setBoolean("addAltTransGMode", this.params.getUseGModeInAltTrans());
        }
        if ((rd = this.mosesDoc) == null) {
            String path = this.inputURI.getPath() + "." + this.targetLocale.toString();
            rd = new RawDocument(new File(path).toURI(), "UTF-8", this.sourceLocale);
        }
        if (Util.isEmpty(rd.getFilterConfigId())) {
            rd.setFilterConfigId("okf_mosestext");
        }
        this.filter = new MosesTextFilter();
        this.filter.open(rd);
        this.filter.hasNext();
        this.filter.next();
    }

    private void processEndDocument() {
        if (this.filter != null) {
            this.filter.close();
            this.filter = null;
        }
    }

    private void processTextUnit(ITextUnit tu) {
        if (!tu.isTranslatable()) {
            return;
        }
        TextContainer tc = tu.hasTarget(this.targetLocale) ? tu.getTarget(this.targetLocale) : tu.createTarget(this.targetLocale, true, 4);
        if (tc.contentIsOneSegment()) {
            AltTranslationsAnnotation ann = tc.getAnnotation(AltTranslationsAnnotation.class);
            ann = this.leverage(ann, tu.getSource().getFirstContent(), tu.getId());
            tc.setAnnotation(ann);
            this.copyToTarget(tc, null, ann);
        } else {
            for (Segment seg : tc.getSegments()) {
                Segment srcSeg = tu.getSource().getSegments().get(seg.id);
                AltTranslationsAnnotation ann = seg.getAnnotation(AltTranslationsAnnotation.class);
                ann = this.leverage(ann, srcSeg.text, tu.getId());
                seg.setAnnotation(ann);
                this.copyToTarget(null, seg, ann);
            }
        }
    }

    private void copyToTarget(TextContainer tc, Segment seg, AltTranslationsAnnotation ann) {
        if (!this.params.getCopyToTarget()) {
            return;
        }
        if (tc != null) {
            if (this.params.getOverwriteExistingTarget() || tc.isEmpty()) {
                tc.setContent(ann.getLast().getTarget().getFirstContent());
            }
        } else if (this.params.getOverwriteExistingTarget() || seg.text.isEmpty()) {
            seg.text = ann.getLast().getTarget().getFirstContent();
        }
    }

    private AltTranslationsAnnotation leverage(AltTranslationsAnnotation ann, TextFragment srcFrag, String tuId) {
        if (!this.filter.hasNext()) {
            throw new OkapiIOException(String.format("The InlineText file is missing entries for text unit id='%s'", tuId));
        }
        Event event = this.filter.next();
        if (event.getEventType() != EventType.TEXT_UNIT) {
            throw new OkapiIOException(String.format("The InlineText file is de-synchronized for text unit id='%s'", tuId));
        }
        ITextUnit mtu = event.getTextUnit();
        TextFragment trgFrag = mtu.getSource().getFirstContent();
        TextFragmentUtil.alignAndCopyCodeMetadata(srcFrag, trgFrag, true, true, CodeMatchStrategy.STRICT);
        if (ann == null) {
            ann = new AltTranslationsAnnotation();
        }
        ann.add(this.sourceLocale, this.targetLocale, srcFrag, null, trgFrag, MatchType.MT, 10, "Moses-MT");
        return ann;
    }
}

