/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.idbasedcopy;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

@EditorFor(value=Parameters.class)
public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String MARKASTRANSLATENO = "markAsTranslateNo";
    private static final String MARKASAPPROVED = "markAsApproved";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setMarkAsTranslateNo(false);
        this.setMarkAsApproved(true);
    }

    public boolean getMarkAsTranslateNo() {
        return this.getBoolean(MARKASTRANSLATENO);
    }

    public void setMarkAsTranslateNo(boolean markAsTranslateNo) {
        this.setBoolean(MARKASTRANSLATENO, markAsTranslateNo);
    }

    public boolean getMarkAsApproved() {
        return this.getBoolean(MARKASAPPROVED);
    }

    public void setMarkAsApproved(boolean markAsApproved) {
        this.setBoolean(MARKASAPPROVED, markAsApproved);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(MARKASTRANSLATENO, "Set the text unit as non-translatable", null);
        desc.add(MARKASAPPROVED, "Set the target property 'approved' to 'yes'", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Id-Based Copy Settings");
        desc.addTextLabelPart("If the text unit has a match:");
        desc.addCheckboxPart(paramsDesc.get(MARKASTRANSLATENO));
        desc.addCheckboxPart(paramsDesc.get(MARKASAPPROVED));
        return desc;
    }
}

