/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.reader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import net.sf.okapi.lib.xliff2.URIParser;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.changeTracking.ChangeTrack;
import net.sf.okapi.lib.xliff2.changeTracking.Item;
import net.sf.okapi.lib.xliff2.changeTracking.Revision;
import net.sf.okapi.lib.xliff2.changeTracking.Revisions;
import net.sf.okapi.lib.xliff2.core.CTag;
import net.sf.okapi.lib.xliff2.core.CanReorder;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.ExtContent;
import net.sf.okapi.lib.xliff2.core.ExtElement;
import net.sf.okapi.lib.xliff2.core.ExtElements;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.IExtChild;
import net.sf.okapi.lib.xliff2.core.IWithChangeTrack;
import net.sf.okapi.lib.xliff2.core.IWithExtAttributes;
import net.sf.okapi.lib.xliff2.core.IWithInheritedData;
import net.sf.okapi.lib.xliff2.core.IWithMetadata;
import net.sf.okapi.lib.xliff2.core.IWithNotes;
import net.sf.okapi.lib.xliff2.core.IWithValidation;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.InsingnificantPartData;
import net.sf.okapi.lib.xliff2.core.MTag;
import net.sf.okapi.lib.xliff2.core.MidFileData;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Notes;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.ProcessingInstruction;
import net.sf.okapi.lib.xliff2.core.Segment;
import net.sf.okapi.lib.xliff2.core.Skeleton;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartGroupData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.Tag;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Tags;
import net.sf.okapi.lib.xliff2.core.TargetState;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.glossary.Definition;
import net.sf.okapi.lib.xliff2.glossary.GlossEntry;
import net.sf.okapi.lib.xliff2.glossary.Glossary;
import net.sf.okapi.lib.xliff2.glossary.Translation;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSReader;
import net.sf.okapi.lib.xliff2.its.TermTag;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.matches.Matches;
import net.sf.okapi.lib.xliff2.metadata.IWithMetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Meta;
import net.sf.okapi.lib.xliff2.metadata.MetaGroup;
import net.sf.okapi.lib.xliff2.metadata.Metadata;
import net.sf.okapi.lib.xliff2.reader.Event;
import net.sf.okapi.lib.xliff2.reader.EventType;
import net.sf.okapi.lib.xliff2.reader.LocationValidator;
import net.sf.okapi.lib.xliff2.reader.SchemaValidator;
import net.sf.okapi.lib.xliff2.reader.URIContext;
import net.sf.okapi.lib.xliff2.reader.XLIFFReaderException;
import net.sf.okapi.lib.xliff2.validation.Rule;
import net.sf.okapi.lib.xliff2.validation.Validation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFFReader
implements Closeable {
    public static final int VALIDATION_MINIMAL = 0;
    public static final int VALIDATION_MAXIMAL = 255;
    public static final int VALIDATION_INCLUDE_SCHEMAS = 1;
    public static final int VALIDATION_INCLUDE_FRAGIDPREFIX = 2;
    private static final String NOTE_NS = "urn:oasis:names:tc:xliff:document:2.0_n";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SchemaValidator schValidator;
    private final LocationValidator locValidator;
    private XMLStreamReader reader;
    private LinkedList<Event> queue;
    private StartXliffData docData;
    private StartFileData startFileData;
    private boolean isMidFile;
    private boolean isInFile;
    private Stack<InheritedData> inheritedData;
    private Stack<String> groups;
    private Stack<URIContext> uriContext;
    private Stack<Validation> valContext;
    private URIParser uriParser;
    private boolean checkTargetOrder;
    private Unit unit;
    private List<CTag> srcIsolated;
    private List<CTag> trgIsolated;
    private Segment segment;
    private Part ignorable;
    private Stack<String> xmlAttributes;
    private boolean reportUnsingnificantParts = false;
    private HashMap<String, Boolean> fileIds;
    private HashMap<String, Boolean> unitIds;
    private HashMap<String, Boolean> groupIds;
    private ArrayList<String> subFlowIds;
    private Stack<HashMap<String, ArrayList<String>>> specialIds;
    private int fileCount;
    private int warningCount;
    private int fileLevelUnitOrGroupCount;
    private ITSReader itsReader;

    public XLIFFReader() {
        this(255, null);
    }

    public XLIFFReader(int validation) {
        this(validation, null);
    }

    public XLIFFReader(int validation, URIParser uriParserToUse) {
        if ((validation & 1) == 1) {
            this.schValidator = new SchemaValidator();
            this.locValidator = new LocationValidator();
            this.locValidator.load(this.getClass().getResourceAsStream("/net/sf/okapi/lib/xliff2/modules.xml"));
        } else {
            this.schValidator = null;
            this.locValidator = null;
        }
        this.uriParser = uriParserToUse == null ? new URIParser() : uriParserToUse;
        this.uriParser.setErrorOnUnknownPrefix((validation & 2) == 2);
    }

    public static void validate(File file) {
        XLIFFReader.validate(null, file, null, null, null);
    }

    public static void validate(File file, URIParser uriParser) {
        XLIFFReader.validate(uriParser, file, null, null, null);
    }

    public static void validate(URI inputURI, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, inputURI, null, null);
    }

    public static void validate(String input, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, null, input, null);
    }

    public static void validate(InputStream inputStream, URIParser uriParser) {
        XLIFFReader.validate(uriParser, null, null, null, inputStream);
    }

    private static void validate(URIParser uriParser, File file, URI uri, String string, InputStream stream) {
        try (XLIFFReader reader = new XLIFFReader(255, uriParser);){
            reader.open(file, uri, string, stream);
            while (reader.hasNext()) {
                reader.next();
            }
        }
    }

    public void open(File file) {
        this.open(file, null, null, null);
    }

    public void open(URI inputURI) {
        this.open(null, inputURI, null, null);
    }

    public void open(String input) {
        this.open(null, null, input, null);
    }

    public void open(InputStream inputStream) {
        this.open(null, null, null, inputStream);
    }

    private StreamSource validateAndGetInput(File file, URI uri, String string, InputStream stream) {
        StreamSource inputSource = null;
        try {
            inputSource = file != null ? new StreamSource(file) : (uri != null ? new StreamSource(new BufferedInputStream(uri.toURL().openStream())) : (string != null ? new StreamSource(new StringReader(string)) : (this.schValidator != null ? new StreamSource(this.createByteArrayInputStream(stream)) : new StreamSource(stream))));
        }
        catch (IOException e) {
            this.error("Cannot create input stream from input. " + e.getLocalizedMessage());
        }
        if (this.schValidator == null) {
            return inputSource;
        }
        this.schValidator.validate(inputSource);
        try {
            if (file != null) {
                inputSource = new StreamSource(file);
            } else if (uri != null) {
                inputSource = new StreamSource(new BufferedInputStream(uri.toURL().openStream()));
            } else if (string != null) {
                inputSource = new StreamSource(new StringReader(string));
            } else {
                inputSource.getInputStream().reset();
            }
        }
        catch (IOException e) {
            this.error("Cannot reset the input after schema validation. " + e.getLocalizedMessage());
        }
        return inputSource;
    }

    private ByteArrayInputStream createByteArrayInputStream(InputStream inputStream) {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int nRead;
            byte[] data = new byte[10240];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                baos.write(data, 0, nRead);
            }
            baos.flush();
            ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
            bais.mark(Integer.MAX_VALUE);
            byteArrayInputStream = bais;
        }
        catch (Throwable throwable) {
            try {
                try {
                    baos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new XLIFFReaderException("Cannot create temporary input stream for schema validation.", e);
            }
        }
        baos.close();
        return byteArrayInputStream;
    }

    private void open(File file, URI uri, String string, InputStream stream) {
        try {
            this.close();
            StreamSource inputSource = this.validateAndGetInput(file, uri, string, stream);
            XMLInputFactory fact = XMLInputFactory.newInstance();
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            this.reader = fact.createXMLStreamReader(inputSource);
            this.groups = new Stack();
            this.inheritedData = new Stack();
            this.inheritedData.push(new InheritedData());
            this.uriContext = new Stack();
            this.uriContext.push(new URIContext());
            this.valContext = new Stack();
            this.valContext.push(new Validation());
            this.xmlAttributes = new Stack();
            this.xmlAttributes.push("d");
            this.queue = new LinkedList();
            this.queue.add(new Event(EventType.START_DOCUMENT, null));
        }
        catch (XMLStreamException e) {
            this.error("Cannot open the XLIFF stream. " + e.getMessage());
        }
    }

    @Override
    public void close() {
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
        }
        catch (XMLStreamException e) {
            this.error("Closing error. " + e.getMessage());
        }
    }

    public boolean hasNext() {
        try {
            return this.reader.hasNext();
        }
        catch (XMLStreamException e) {
            this.error("Reading error. " + e.getMessage());
            return false;
        }
    }

    public Event next() {
        if (this.queue.isEmpty()) {
            this.readNext();
        }
        if (this.queue.peek().getType() == EventType.END_DOCUMENT && this.xmlAttributes.size() != 1) {
            this.warning(String.format("Stack for xml:space is at %d instead of 1.", this.xmlAttributes.size()));
        }
        return this.queue.poll();
    }

    public void setReportUnsingnificantParts(boolean reportUnsingnificantParts) {
        this.reportUnsingnificantParts = reportUnsingnificantParts;
    }

    private void readNext() {
        MidFileData midFileData = null;
        StartGroupData startGroupData = null;
        try {
            while (this.reader.hasNext()) {
                int type = this.reader.next();
                block1 : switch (type) {
                    case 7: {
                        break;
                    }
                    case 8: {
                        this.queue.add(new Event(EventType.END_DOCUMENT, null));
                        return;
                    }
                    case 1: {
                        String tmp = this.reader.getLocalName();
                        String nsUri = this.reader.getNamespaceURI();
                        this.pushXMLAttributes();
                        switch (nsUri) {
                            case "urn:oasis:names:tc:xliff:document:2.0": {
                                switch (tmp) {
                                    case "unit": {
                                        if (this.isMidFile) {
                                            midFileData = this.ensureMidFileData(midFileData);
                                            this.isMidFile = false;
                                        }
                                        this.processUnit();
                                        return;
                                    }
                                    case "group": {
                                        if (this.isMidFile) {
                                            midFileData = this.ensureMidFileData(midFileData);
                                            this.isMidFile = false;
                                        }
                                        startGroupData = this.processStartGroup();
                                        if (this.valContext.peek().isEmpty()) break block1;
                                        startGroupData.setValidation(this.valContext.peek());
                                        break;
                                    }
                                    case "file": {
                                        this.processStartFile();
                                        return;
                                    }
                                    case "xliff": {
                                        this.processXliff();
                                        return;
                                    }
                                    case "skeleton": {
                                        this.processSkeleton();
                                        return;
                                    }
                                    case "notes": {
                                        if (this.groups.isEmpty()) {
                                            if (this.isMidFile) {
                                                midFileData = this.ensureMidFileData(midFileData);
                                                this.processNotes(midFileData);
                                                break;
                                            }
                                            this.error("Notes for a <file> must be before its first <unit> or <group>.");
                                            break;
                                        }
                                        if (startGroupData == null) {
                                            this.error("Notes for a <group> must be before its first <unit> or <group>.");
                                            break;
                                        }
                                        this.processNotes(startGroupData);
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid element found: '%s'", tmp));
                                        break;
                                    }
                                }
                                break block1;
                            }
                            case "urn:oasis:names:tc:xliff:metadata:2.0": {
                                if (this.groups.isEmpty()) {
                                    if (this.isMidFile) {
                                        midFileData = this.ensureMidFileData(midFileData);
                                        this.processMetadata(midFileData);
                                        break;
                                    }
                                } else {
                                    this.processMetadata(startGroupData);
                                    break;
                                }
                                this.error("Invalid extension and module element " + this.reader.getName().toString());
                                break;
                            }
                            case "urn:oasis:names:tc:xliff:changetracking:2.0": {
                                if (this.groups.isEmpty()) {
                                    if (this.isMidFile) {
                                        midFileData = this.ensureMidFileData(midFileData);
                                        this.processChangeTracking(midFileData);
                                        break;
                                    }
                                } else {
                                    this.processChangeTracking(startGroupData);
                                    break;
                                }
                                this.error("Invalid extension and module element " + this.reader.getName().toString());
                                break;
                            }
                            case "urn:oasis:names:tc:xliff:validation:2.0": {
                                if (this.groups.isEmpty()) {
                                    if (this.isMidFile) {
                                        midFileData = this.ensureMidFileData(midFileData);
                                        this.processValidation(midFileData);
                                        break;
                                    }
                                } else {
                                    this.processValidation(startGroupData);
                                    break;
                                }
                                this.error("Invalid extension and module element " + this.reader.getName().toString());
                                break;
                            }
                            default: {
                                if (this.groups.isEmpty()) {
                                    if (this.isMidFile) {
                                        midFileData = this.ensureMidFileData(midFileData);
                                        this.processExtElement("file", midFileData.getExtElements());
                                        break;
                                    }
                                    if (this.isInFile) {
                                        this.error("Extension and module elements of a <file> must be before its first <unit> or <group>.");
                                        break;
                                    }
                                    this.error("No element allowed outside a <file> element.");
                                    break;
                                }
                                this.processExtElement("group", startGroupData.getExtElements());
                                break;
                            }
                        }
                        break;
                    }
                    case 2: {
                        String tmp = this.reader.getLocalName();
                        String nsUri = this.reader.getNamespaceURI();
                        this.popXMLAttributes();
                        if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                        if (tmp.equals("group")) {
                            this.queue.add(new Event(EventType.END_GROUP, null));
                            this.groups.pop();
                            this.popInheritedData();
                            this.uriContext.pop();
                            this.valContext.pop();
                            this.popSpecialIds();
                            return;
                        }
                        if (tmp.equals("file")) {
                            if (this.fileLevelUnitOrGroupCount < 1) {
                                this.error("There must be at least one <unit> or <group> in a <file>.");
                            }
                            this.checkSubFlows();
                            this.queue.add(new Event(EventType.END_FILE, null));
                            this.isInFile = false;
                            this.popInheritedData();
                            this.uriContext.pop();
                            this.valContext.pop();
                            this.popSpecialIds();
                            return;
                        }
                        if (!tmp.equals("xliff")) break;
                        if (this.fileCount < 1) {
                            this.error("There must be at least one <file> per XLIFF document.");
                        }
                        this.queue.add(new Event(EventType.END_XLIFF, this.uriContext.peek()));
                        return;
                    }
                    case 4: 
                    case 6: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.TEXT, this.reader.getText())));
                        if (startGroupData != null) break;
                        return;
                    }
                    case 5: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.COMMENT, "<!--" + this.reader.getText() + "-->")));
                        if (startGroupData != null) break;
                        return;
                    }
                    case 3: {
                        if (!this.reportUnsingnificantParts) break;
                        this.queue.add(new Event(EventType.INSIGNIFICANT_PART, this.uriContext.peek(), new InsingnificantPartData(InsingnificantPartData.InsignificantPartType.PI, "<?" + this.reader.getText() + "?>")));
                        if (startGroupData != null) break;
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            this.error("Reading error. " + e.getMessage());
        }
    }

    private MidFileData ensureMidFileData(MidFileData current) {
        if (current == null) {
            current = new MidFileData();
            this.queue.add(new Event(EventType.MID_FILE, this.uriContext.peek(), current));
        }
        return current;
    }

    private void checkSubFlows() {
        for (String id : this.subFlowIds) {
            if (this.unitIds.containsKey(id)) continue;
            this.error(String.format("There is a reference to a subFlow id='%s' with no corresponding <unit>.", id));
        }
    }

    private void pushXMLAttributes() {
        Object newStates = this.xmlAttributes.peek();
        String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "space");
        if (!Util.isNoE(tmp)) {
            newStates = (tmp.equals("preserve") ? "p" : "d") + ((String)newStates).substring(1);
        }
        if (!Util.isNoE(tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang"))) {
            String msg = Util.validateLang(tmp);
            if (msg != null) {
                this.error(String.format("The xml:lang value '%s' is invalid.\n" + msg, tmp));
            }
            newStates = ((String)newStates).charAt(0) + tmp;
        }
        this.xmlAttributes.push((String)newStates);
    }

    private void popXMLAttributes() {
        this.xmlAttributes.pop();
    }

    private void processXliff() {
        String version = this.reader.getAttributeValue("", "version");
        this.cannotBeNullOrEmpty("version", version);
        if (!version.startsWith("2.")) {
            this.error(String.format("Not a XLIFF 2.x document (version='%s').", version));
        }
        this.docData = new StartXliffData(version);
        String value = this.reader.getAttributeValue("", "srcLang");
        this.cannotBeNullOrEmpty("srcLang", value);
        this.docData.setSourceLanguage(value);
        this.docData.setExtAttributes(this.gatherNamespaces(null));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "version": {
                        break;
                    }
                    case "srcLang": {
                        break;
                    }
                    case "trgLang": {
                        this.cannotBeEmpty("trgLang", value);
                        this.docData.setTargetLanguage(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(this.docData, i, false);
        }
        this.fileIds = new HashMap();
        this.fileCount = 0;
        this.warningCount = 0;
        this.isInFile = false;
        this.queue.add(new Event(EventType.START_XLIFF, this.uriContext.peek(), this.docData));
    }

    public int getWarningCount() {
        return this.warningCount;
    }

    private void error(String message) {
        this.reportIssue(message, false);
    }

    private void warning(String message) {
        ++this.warningCount;
        this.reportIssue(message, true);
    }

    private void reportIssue(String message, boolean warningOnly) {
        Object fpart = "";
        if (this.fileCount > 0) {
            QName qn;
            fpart = "Error in <file> ";
            fpart = this.startFileData != null ? (String)fpart + String.format("id='%s'", this.startFileData.getId()) : String.format("number %d", this.fileCount);
            if (this.unit != null) {
                fpart = (String)fpart + String.format(", <unit> id='%s'", this.unit.getId());
            } else if (!this.groups.isEmpty()) {
                fpart = this.groups.peek() == null ? (String)fpart + String.format(", <group> level %d", this.groups.size()) : (String)fpart + String.format(", <group> id='%s'", this.groups.peek());
            }
            if (this.reader != null && this.reader.hasName() && (qn = this.reader.getName()) != null) {
                fpart = (String)fpart + "\nLast element read: '" + qn.toString() + "'";
            }
            fpart = (String)fpart + ":\n";
        }
        if (!warningOnly) {
            throw new XLIFFReaderException((String)fpart + message);
        }
        this.logger.warn((String)fpart + message);
    }

    private void processStartFile() {
        ++this.fileCount;
        this.fileLevelUnitOrGroupCount = 0;
        this.startFileData = new StartFileData(null);
        this.isMidFile = true;
        this.isInFile = true;
        this.unitIds = new HashMap();
        this.groupIds = new HashMap();
        this.subFlowIds = new ArrayList();
        this.specialIds = new Stack();
        this.itsReader = new ITSReader(this.reader);
        this.readAndPushInheritedAttributes(this.startFileData);
        this.uriContext.push(this.uriContext.peek().clone());
        this.valContext.push(new Validation(this.valContext.peek(), true));
        this.pushSpecialIds();
        if (this.locValidator != null) {
            this.locValidator.reset();
        }
        this.startFileData.setExtAttributes(this.gatherNamespaces(this.startFileData.getExtAttributes()));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "canResegment": {
                        break;
                    }
                    case "translate": {
                        break;
                    }
                    case "srcDir": {
                        break;
                    }
                    case "trgDir": {
                        break;
                    }
                    case "id": {
                        this.cannotBeNullOrEmpty("id", value);
                        if (this.fileIds.containsKey(value)) {
                            this.error(String.format("The value '%s' is used as the id of two or more <file> elements.", value));
                        } else {
                            this.fileIds.put(value, false);
                        }
                        this.uriContext.peek().setFileId(value);
                        this.startFileData.setId(value);
                        break;
                    }
                    case "original": {
                        this.cannotBeEmpty("original", value);
                        this.startFileData.setOriginal(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(this.startFileData, i, false);
        }
        if (this.startFileData.getId() == null) {
            this.error("The <file> element must have an id.");
        }
        this.queue.add(new Event(EventType.START_FILE, this.uriContext.peek(), this.startFileData));
    }

    private void pushSpecialIds() {
        HashMap ids = new HashMap();
        this.specialIds.push(ids);
    }

    private void popSpecialIds() {
        this.specialIds.pop();
    }

    private void checkAndAddSpecialId(String idNs, String id) {
        if (idNs.equals("urn:oasis:names:tc:xliff:document:2.0")) {
            return;
        }
        HashMap<String, ArrayList<String>> ids = this.specialIds.peek();
        ArrayList<String> list = ids.get(idNs);
        if (list != null) {
            if (list.contains(id)) {
                if (idNs.equals(NOTE_NS)) {
                    this.error(String.format("Duplicate id '%s' for a <note> element.", id));
                } else {
                    this.error(String.format("Duplicate id '%s' for the module or extension '%s'.", id, idNs));
                }
            }
        } else {
            list = new ArrayList();
            ids.put(idNs, list);
        }
        list.add(id);
    }

    private void processSkeleton() throws XMLStreamException {
        boolean hasHref = false;
        Skeleton skelData = new Skeleton();
        QName qn = new QName("urn:oasis:names:tc:xliff:document:2.0", "skeleton");
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                if (locName.equals("href")) {
                    if (!this.cannotBeEmpty("href", value)) continue;
                    skelData.setHref(value);
                    hasHref = true;
                    continue;
                }
                this.error(String.format("Invalid attribute '%s' in <skeleton>.", locName));
                continue;
            }
            this.error(String.format("Invalid attribute '%s' in <skeleton>.", locName));
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (hasHref) {
                        this.error("You cannot have both an href attribute and a content in <skeleton>.");
                    }
                    this.pushXMLAttributes();
                    skelData.addChild(this.readExtElement());
                    break;
                }
                case 2: {
                    if (!this.reader.getName().equals(qn)) break;
                    this.popXMLAttributes();
                    if (hasHref) {
                        if (skelData.getChildren() != null && !skelData.getChildren().isEmpty()) {
                            this.error("You must not have a content in <skeleton> if there is an href attribute.");
                        }
                    } else if (skelData.getChildren() == null || skelData.getChildren().isEmpty()) {
                        this.error("You must have a content in <skeleton> if there is no href attribute.");
                    }
                    this.queue.add(new Event(EventType.SKELETON, this.uriContext.peek(), skelData));
                    return;
                }
                case 4: 
                case 6: {
                    skelData.addChild(new ExtContent(this.reader.getText()));
                    break;
                }
                case 12: {
                    skelData.addChild(new ExtContent(this.reader.getText(), true));
                    break;
                }
                case 3: {
                    skelData.addChild(new ProcessingInstruction("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>"));
                    break;
                }
            }
        }
    }

    private void readAndPushInheritedAttributes(IWithInheritedData object) {
        AnnotatorsRef ar;
        InheritedData indat = new InheritedData(this.inheritedData.peek());
        String tmp = this.reader.getAttributeValue("", "translate");
        if (this.canBeYesOrNo("translate", tmp)) {
            indat.setTranslate(tmp.equals("yes"));
        }
        if (this.canBeYesOrNo("canResegment", tmp = this.reader.getAttributeValue("", "canResegment"))) {
            indat.setCanResegment(tmp.equals("yes"));
        }
        if (this.canBeAutoOrLtrOrRtl("srcDir", tmp = this.reader.getAttributeValue("", "srcDir"))) {
            switch (tmp) {
                case "auto": {
                    indat.setSourceDir(Directionality.AUTO);
                    break;
                }
                case "ltr": {
                    indat.setSourceDir(Directionality.LTR);
                    break;
                }
                case "rtl": {
                    indat.setSourceDir(Directionality.RTL);
                }
            }
        }
        if (this.canBeAutoOrLtrOrRtl("trgDir", tmp = this.reader.getAttributeValue("", "trgDir"))) {
            switch (tmp) {
                case "auto": {
                    indat.setTargetDir(Directionality.AUTO);
                    break;
                }
                case "ltr": {
                    indat.setTargetDir(Directionality.LTR);
                    break;
                }
                case "rtl": {
                    indat.setTargetDir(Directionality.RTL);
                }
            }
        }
        if ((ar = this.itsReader.readAnnotatorsRef(false, indat.getAnnotatorsRef())) != null) {
            indat.setAnnotatorsRef(ar);
        }
        object.setInheritableData(indat);
        this.inheritedData.push(indat);
    }

    private void popInheritedData() {
        this.inheritedData.pop();
    }

    private StartGroupData processStartGroup() {
        String tmp = this.reader.getAttributeValue("", "id");
        if (this.groups.isEmpty()) {
            ++this.fileLevelUnitOrGroupCount;
        }
        this.groups.push(tmp);
        this.mustBeValidNmtoken("id", tmp, false);
        if (this.groupIds.containsKey(tmp)) {
            this.error(String.format("Duplicated group id value '%s' detected.", tmp));
        } else {
            this.groupIds.put(tmp, null);
        }
        this.uriContext.push(this.uriContext.peek().clone());
        this.uriContext.peek().setGroupId(tmp);
        this.pushSpecialIds();
        this.valContext.push(new Validation(this.valContext.peek(), true));
        if (this.locValidator != null) {
            this.locValidator.reset();
        }
        StartGroupData sgd = new StartGroupData(tmp);
        this.readAndPushInheritedAttributes(sgd);
        sgd.setExtAttributes(this.gatherNamespaces(sgd.getExtAttributes()));
        block14: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "id": {
                        break;
                    }
                    case "translate": {
                        break;
                    }
                    case "canResegment": {
                        break;
                    }
                    case "srcDir": {
                        break;
                    }
                    case "trgDir": {
                        break;
                    }
                    default: {
                        if (locName.equals("name")) {
                            if (!this.cannotBeEmpty("name", value)) continue block14;
                            sgd.setName(value);
                            break;
                        }
                        if (locName.equals("type")) {
                            if (!this.cannotBeEmpty("type", value)) continue block14;
                            sgd.setType(value);
                            break;
                        }
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(sgd, i, false);
        }
        this.queue.add(new Event(EventType.START_GROUP, this.uriContext.peek(), sgd));
        return sgd;
    }

    private int checkIntegerValue(String name, String value, int min, int max) {
        if (value == null) {
            return -1;
        }
        if (value.isEmpty()) {
            this.error(String.format("Empty attribute '%s'", name));
        }
        try {
            int tmp = Integer.parseInt(value);
            if (tmp < min || tmp > max) {
                this.error(String.format("Invalid value for attribute '%s'", name));
            }
            return tmp;
        }
        catch (NumberFormatException e) {
            this.error(String.format("Invalid syntax for attribute '%s'", name));
            return -1;
        }
    }

    private void checkInlineIds(Unit unit) {
        String id;
        HashMap<String, Integer> ids = new HashMap<String, Integer>();
        for (Part part : unit) {
            String id2 = part.getId();
            if (id2 == null) continue;
            if (ids.containsKey(id2)) {
                this.error(String.format("The id '%s' is used incorrectly more than once in the unit id='%s'", id2, unit.getId()));
                continue;
            }
            ids.put(id2, -1);
        }
        Tags markers = unit.getStore().getSourceTags();
        for (Tag bm : markers) {
            if (bm.getTagType() == TagType.CLOSING) continue;
            id = bm.getId();
            if (ids.containsKey(id)) {
                if ((Integer)ids.get(id) == -1) {
                    this.error(String.format("The id '%s' is already used for a segment or an ignorable element in the unit id='%s'", id, unit.getId()));
                    continue;
                }
                this.error(String.format("The id '%s' is already used in the source content of the unit id='%s'", id, unit.getId()));
                continue;
            }
            ids.put(id, 0);
        }
        markers = unit.getStore().getTargetTags();
        block6: for (Tag bm : markers) {
            if (bm.getTagType() == TagType.CLOSING) continue;
            id = bm.getId();
            if (ids.containsKey(id)) {
                switch ((Integer)ids.get(id)) {
                    case 0: {
                        ids.put(id, 1);
                        continue block6;
                    }
                    case -1: {
                        this.error(String.format("The id '%s' is already used for a segment or ignorable element in the unit id='%s'", id, unit.getId()));
                        continue block6;
                    }
                }
                this.error(String.format("The id '%s' exists twice or more in the target content in the unit id='%s'", id, unit.getId()));
                continue;
            }
            ids.put(id, 1);
        }
    }

    private void checkTargetAndState(Unit unit) {
        for (Part part : unit) {
            Segment seg;
            if (!part.isSegment() || (seg = (Segment)part).getState() == TargetState.INITIAL) continue;
            if (!seg.hasTarget()) {
                this.warning("The state is not 'initial', but there is no <target> element.");
                continue;
            }
            if (seg.getSource().isEmpty() || !seg.getTarget().isEmpty()) continue;
            this.warning("The state is not 'initial' but the <target> is empty while the <source> is not.");
        }
    }

    private void cannotBeNullOrEmpty(String name, String value) {
        if (Util.isNoE(value)) {
            this.error(String.format("Missing or empty attribute '%s'", name));
        }
    }

    private boolean mustBeValidNmtoken(String name, String value, boolean allowNull) {
        if (value == null) {
            if (allowNull) {
                return false;
            }
            this.error(String.format("Missing attribute '%s'", name));
        }
        if (!Util.isValidNmtoken(value)) {
            this.error(String.format("Value '%s' is not a valid NMTOKEN for '%s'.", value, name));
        }
        return true;
    }

    private Directionality getDirectionality(String name, String value, Directionality defValue) {
        if (value == null) {
            return defValue;
        }
        switch (value) {
            case "auto": {
                return Directionality.AUTO;
            }
            case "ltr": {
                return Directionality.LTR;
            }
            case "rtl": {
                return Directionality.RTL;
            }
        }
        this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "auto", "ltr", "rtl"));
        return Directionality.AUTO;
    }

    private boolean getYesOrNo(String name, String value, boolean defValue) {
        if (value == null) {
            return defValue;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return value.equals("yes");
    }

    private boolean cannotBeEmpty(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty()) {
            this.error(String.format("Empty attribute '%s'", name));
        }
        return true;
    }

    private boolean canBeYesOrNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s' or '%s')", name, "yes", "no"));
        }
        return true;
    }

    private boolean canBeYesOrNoOrFirstNo(String name, String value) {
        if (value == null) {
            return false;
        }
        if (value.isEmpty() || !value.equals("yes") && !value.equals("no") && !value.equals("firstNo")) {
            this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "yes", "no", "firstNo"));
        }
        return true;
    }

    private boolean canBeAutoOrLtrOrRtl(String name, String value) {
        if (value == null) {
            return false;
        }
        switch (value) {
            case "auto": 
            case "ltr": 
            case "rtl": {
                return true;
            }
        }
        this.error(String.format("Invalid attribute value for '%s' (must be '%s', '%s' or '%s')", name, "auto", "ltr", "rtl"));
        return false;
    }

    private void processUnit() throws XMLStreamException {
        if (this.groups.isEmpty()) {
            ++this.fileLevelUnitOrGroupCount;
        }
        String tmp = this.reader.getAttributeValue("", "id");
        this.mustBeValidNmtoken("id", tmp, false);
        if (this.unitIds.containsKey(tmp)) {
            this.error(String.format("Duplicated unit id value '%s' detected.", tmp));
        } else {
            this.unitIds.put(tmp, null);
        }
        this.unit = new Unit(tmp);
        this.unit.setPreserveWS(this.xmlAttributes.peek().startsWith("p"));
        Map<String, DataElementContent> unitODM = null;
        this.srcIsolated = new ArrayList<CTag>();
        this.trgIsolated = new ArrayList<CTag>();
        this.uriContext.push(this.uriContext.peek().clone());
        this.uriContext.peek().setUnitId(tmp);
        this.valContext.push(new Validation(this.valContext.peek(), true));
        if (!this.valContext.peek().isEmpty()) {
            this.unit.setValidation(this.valContext.peek());
        }
        this.pushSpecialIds();
        this.readAndPushInheritedAttributes(this.unit);
        this.unit.setExtAttributes(this.gatherNamespaces(this.unit.getExtAttributes()));
        boolean needsITSFetch = this.itsReader.readAttributes(this.unit, this.unit, this.inheritedData.peek().getAnnotatorsRef());
        block48: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "id": {
                        break;
                    }
                    case "translate": {
                        break;
                    }
                    case "canResegment": {
                        break;
                    }
                    case "srcDir": {
                        break;
                    }
                    case "trgDir": {
                        break;
                    }
                    default: {
                        if (locName.equals("name")) {
                            if (!this.cannotBeEmpty("name", value)) continue block48;
                            this.unit.setName(value);
                            break;
                        }
                        if (locName.equals("type")) {
                            if (!this.cannotBeEmpty("type", value)) continue block48;
                            this.unit.setType(value);
                            break;
                        }
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            if (ns.equals("http://www.w3.org/ns/its-xliff/") || ns.equals("http://www.w3.org/2005/11/its")) continue;
            this.addExtAttribute(this.unit, i, false);
        }
        ExtElements unitExtElems = null;
        this.checkTargetOrder = false;
        boolean hasOneSegment = false;
        HashMap<String, Boolean> partIds = new HashMap<String, Boolean>();
        boolean inExtensionPoint = true;
        boolean notesAllowed = true;
        while (this.reader.hasNext()) {
            block15 : switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        inExtensionPoint = false;
                        switch (tmp) {
                            case "segment": {
                                hasOneSegment = true;
                                notesAllowed = false;
                                this.processPart(true, partIds);
                                break block15;
                            }
                            case "ignorable": {
                                notesAllowed = false;
                                this.processPart(false, partIds);
                                break block15;
                            }
                            case "originalData": {
                                unitODM = this.processOriginalData();
                                break block15;
                            }
                            case "notes": {
                                if (notesAllowed) {
                                    this.processNotes(this.unit);
                                    break block15;
                                }
                                this.error("Notes for a <unit> must be before its first <segment> or <ignorable>.");
                                break block15;
                            }
                        }
                        this.error(String.format("Unexpected element '%s' in <unit>", tmp));
                        break;
                    }
                    if (inExtensionPoint) {
                        switch (nsUri) {
                            case "http://www.w3.org/2005/11/its": {
                                this.itsReader.readStandOffElements(tmp, this.unit, this.inheritedData.peek().getAnnotatorsRef());
                                this.popXMLAttributes();
                                break block15;
                            }
                            case "urn:oasis:names:tc:xliff:matches:2.0": {
                                this.processMatches();
                                break block15;
                            }
                            case "urn:oasis:names:tc:xliff:glossary:2.0": {
                                this.processGlossary();
                                break block15;
                            }
                            case "urn:oasis:names:tc:xliff:metadata:2.0": {
                                this.processMetadata(this.unit);
                                break block15;
                            }
                            case "urn:oasis:names:tc:xliff:validation:2.0": {
                                this.processValidation(this.unit);
                                break block15;
                            }
                            case "urn:oasis:names:tc:xliff:changetracking:2.0": {
                                this.processChangeTracking(this.unit);
                                break block15;
                            }
                        }
                        if (this.locValidator != null) {
                            this.locValidator.reset();
                        }
                        unitExtElems = this.processExtElement("unit", unitExtElems);
                        break;
                    }
                    this.error(String.format("Invalid element '%s'. Extensions and modules must come before core elements.", tmp));
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("unit")) break;
                    if (unitExtElems != null) {
                        this.unit.setExtElements(unitExtElems);
                    }
                    if (!hasOneSegment) {
                        this.error("No <segment> in <unit>.");
                    }
                    if (needsITSFetch) {
                        this.itsReader.fetchUnresolvedITSGroups(this.unit);
                    }
                    this.checkInlineIds(this.unit);
                    this.copyOriginalDataToCodes(this.unit.getStore(), unitODM);
                    this.checkPairsConsistency(this.unit.getStore().getSourceTags());
                    this.checkPairsConsistency(this.unit.getStore().getTargetTags());
                    this.checkSourceTargetCorrespondence(this.unit.getStore().getSourceTags(), this.unit.getStore().getTargetTags());
                    this.checkTargetOrder(this.unit);
                    this.checkIsolatedAttributes(this.unit.getStore().getSourceTags(), this.srcIsolated);
                    this.checkIsolatedAttributes(this.unit.getStore().getTargetTags(), this.trgIsolated);
                    this.checkMatchReferences();
                    this.checkGlossaryReferences();
                    this.checkRevisions(this.unit);
                    this.checkTargetAndState(this.unit);
                    try {
                        Util.validateCopyOf(this.unit);
                        this.unit.verifyOpeningsBeforeClosings(false);
                        this.unit.verifyOpeningsBeforeClosings(true);
                        if (this.unit.doNonEmptySourcesHaveNonEmptyTargets()) {
                            Util.verifyReordering(this.unit.getOrderedCTags(false), this.unit.getOrderedCTags(true), true);
                        } else {
                            Util.createFixedSequences(this.unit.getOrderedCTags(false), true);
                            Util.createFixedSequences(this.unit.getOrderedCTags(true), true);
                        }
                        this.unit.verifyReadOnlyTags();
                    }
                    catch (Exception e) {
                        this.error(e.getMessage());
                    }
                    this.queue.add(new Event(EventType.TEXT_UNIT, this.uriContext.peek(), this.unit));
                    this.popInheritedData();
                    this.uriContext.pop();
                    this.valContext.pop();
                    this.popSpecialIds();
                    this.unit = null;
                    return;
                }
            }
        }
    }

    private void checkRevisions(IWithChangeTrack parent) {
        if (!parent.hasChangeTrack()) {
            return;
        }
        for (Revisions revs : this.unit.getChangeTrack()) {
            String ref;
            String appliesTo = revs.getAppliesTo();
            if (appliesTo == null) {
                this.error(String.format("The element '%s' must have a '%s' attribute.", "revisions", "appliesTo"));
            }
            if ((ref = revs.getRef()) == null) continue;
        }
    }

    private void checkMatchReferences() {
        if (!this.unit.hasMatch()) {
            return;
        }
        for (Match match : this.unit.getMatches()) {
            String ref = match.getRef();
            if (this.unit.getSourceOrTargetReference(ref) != null) continue;
            this.error(String.format("The ref value '%s' for <match> does not point to an existing span in it parent <unit>.", ref));
        }
    }

    private void checkGlossaryReferences() {
        if (!this.unit.hasGlossEntry()) {
            return;
        }
        for (GlossEntry entry : this.unit.getGlossary()) {
            String ref = entry.getRef();
            if (ref != null && this.unit.getSourceOrTargetReference(ref) == null) {
                this.error(String.format("The ref value '%s' for <glossEntry> does not point to an existing span in it parent <unit>.", ref));
            }
            for (Translation trans : entry) {
                ref = trans.getRef();
                if (ref == null || this.unit.getSourceOrTargetReference(ref) != null) continue;
                this.error(String.format("The ref value '%s' for <translation> does not point to an existing span in it parent <unit>.", ref));
            }
        }
    }

    private void checkSourceTargetCorrespondence(Tags srcTags, Tags trgTags) {
        if (srcTags == null) {
            return;
        }
        if (trgTags == null) {
            return;
        }
        for (Tag stag : srcTags) {
            String id = stag.getId();
            Tag ttag = trgTags.get(id, stag.getTagType());
            if (ttag == null) {
                for (Tag tag : trgTags) {
                    if (!tag.getId().equals(id)) continue;
                    this.error(String.format("The codes id='%s' are of different tag-types in source and target.", id));
                }
            }
            if (ttag == null || !stag.isMarker()) continue;
            MTag smtag = (MTag)stag;
            MTag tmtag = (MTag)ttag;
            if (!Util.equals(smtag.getTranslate(), tmtag.getTranslate())) {
                this.error(String.format("The translate value is different between source and target marker id='%s'.", id));
            }
            if (Util.equals(smtag.getType(), tmtag.getType())) continue;
            this.error(String.format("The translate value is different between source and target marker id='%s'.", id));
        }
    }

    private void checkPairsConsistency(Tags tags) {
        if (tags == null) {
            return;
        }
        for (Tag tag : tags) {
            if (tag.getTagType() != TagType.OPENING) continue;
            if (tag.isMarker()) {
                Tag em = tags.getClosingTag(tag);
                if (em != null) continue;
                this.error(String.format("The <sm> for id='%s' has no corresponding <em/>.", tag.getId()));
                continue;
            }
            CTag ctag = (CTag)tag;
            CTag closing = (CTag)tags.getClosingTag(ctag);
            if (closing == null) continue;
            if (closing.getCanOverlap() != ctag.getCanOverlap()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canOverlap value.", ctag.getId()));
            }
            if (closing.getCanCopy() != ctag.getCanCopy()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canCopy value.", ctag.getId()));
            }
            if (closing.getCanDelete() != ctag.getCanDelete()) {
                this.error(String.format("The <ec> and <sc> for id='%s' must have the same canDelete value.", ctag.getId()));
            }
            if (ctag.getCanReorder() == CanReorder.FIRSTNO) {
                if (closing.getCanReorder() == CanReorder.NO) continue;
                this.error(String.format("The <ec> for id='%s' must be set to canReorder='no'.", ctag.getId()));
                continue;
            }
            if (closing.getCanReorder() == ctag.getCanReorder()) continue;
            this.error(String.format("The <ec> for id='%s' must have the same canReorder value as its corresponding <sc>.", ctag.getId()));
        }
    }

    private void checkIsolatedAttributes(Tags markers, List<CTag> list) {
        for (Tag bm : markers) {
            if (bm.isMarker()) continue;
            switch (bm.getTagType()) {
                case OPENING: {
                    if (markers.getClosingTag(bm) == null) {
                        if (list.contains(bm)) break;
                        this.error(String.format("Missing isolated='yes' for opening code id='%s'.", bm.getId()));
                        break;
                    }
                    if (!list.contains(bm)) break;
                    this.error(String.format("Invalid isolated='yes' for opening code id='%s'.", bm.getId()));
                    break;
                }
                case CLOSING: {
                    if (markers.getOpeningTag(bm) == null) {
                        if (list.contains(bm)) break;
                        this.error(String.format("Missing isolated='yes' for closing code id='%s'.", bm.getId()));
                        break;
                    }
                    if (!list.contains(bm)) break;
                    this.error(String.format("Invalid isolated='yes' for closing code id='%s'.", bm.getId()));
                    break;
                }
            }
        }
    }

    private void checkTargetOrder(Unit unit) {
        if (this.checkTargetOrder) {
            int max = unit.getPartCount();
            int i = 0;
            for (Part part : unit) {
                int order1 = part.getTargetOrder();
                if (order1 == 0) {
                    order1 = i + 1;
                }
                if (order1 < 1 || order1 > max) {
                    this.error(String.format("Invalid target order '%d'.", order1));
                }
                for (int j = 0; j < max; ++j) {
                    Part part2 = unit.getPart(j);
                    int order2 = part2.getTargetOrder();
                    if (order2 == 0) {
                        order2 = j + 1;
                    }
                    if (i == j || order1 != order2) continue;
                    this.error(String.format("The parts %d and %d have the same target order: '%d'.", i + 1, j + 1, order1));
                }
                ++i;
            }
        }
    }

    private void copyOriginalDataToCodes(Store store, Map<String, DataElementContent> originalDataMap) {
        CTag code;
        String nid;
        if (store == null) {
            return;
        }
        if (store.hasSourceTag()) {
            for (Tag marker : store.getSourceTags()) {
                if (marker.isMarker() || (nid = (code = (CTag)marker).getDataRef()) == null) continue;
                if (originalDataMap == null) {
                    this.error(String.format("The code id='%s' refers to the <data> id='%s', but no <originalData> is declared.", code.getId(), nid));
                }
                if (!originalDataMap.containsKey(nid)) {
                    this.error(String.format("No original data found for the id '%s'.", nid));
                }
                code.setData(originalDataMap.get((Object)nid).content);
                code.setDataDir(originalDataMap.get((Object)nid).dir);
            }
        }
        if (store.hasTargetTag()) {
            for (Tag marker : store.getTargetTags()) {
                if (marker.isMarker() || (nid = (code = (CTag)marker).getDataRef()) == null) continue;
                if (originalDataMap == null) {
                    this.error(String.format("The code id='%s' refers to the <data> id='%s', but no <originalData> is declared.", code.getId(), nid));
                }
                if (!originalDataMap.containsKey(nid)) {
                    this.error(String.format("No original data found for the id '%s'.", nid));
                }
                code.setData(originalDataMap.get((Object)nid).content);
                code.setDataDir(originalDataMap.get((Object)nid).dir);
            }
        }
    }

    private void processNote(IWithNotes parent) throws XMLStreamException {
        Note note = new Note();
        note.setExtAttributes(this.gatherNamespaces(null));
        block17: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String ns = this.reader.getAttributeNamespace(i);
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "appliesTo": {
                        this.cannotBeEmpty("appliesTo", value);
                        if (value.equals("source")) {
                            note.setAppliesTo(Note.AppliesTo.SOURCE);
                            break;
                        }
                        if (value.equals("target")) {
                            note.setAppliesTo(Note.AppliesTo.TARGET);
                            break;
                        }
                        this.error(String.format("Invalid appliesTo value ('%s').", value));
                        break;
                    }
                    case "id": {
                        this.mustBeValidNmtoken("id", value, true);
                        this.checkAndAddSpecialId(NOTE_NS, value);
                        note.setId(value);
                        break;
                    }
                    case "priority": {
                        this.cannotBeEmpty("priority", value);
                        int num = this.checkIntegerValue("priority", value, 1, 10);
                        if (num <= -1) continue block17;
                        note.setPriority(num);
                        break;
                    }
                    case "category": {
                        this.cannotBeEmpty("category", value);
                        note.setCategory(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s' in <note>.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(note, i, false);
        }
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    sb.append(this.reader.getText());
                    break;
                }
                case 1: {
                    this.error("The <note> element has only text content.");
                }
                case 2: {
                    this.popXMLAttributes();
                    note.setText(sb.toString());
                    parent.addNote(note);
                    return;
                }
            }
        }
    }

    private void processNotes(IWithNotes parent) throws XMLStreamException {
        Notes notes = parent.getNotes();
        boolean hasNotes = false;
        notes.setExtAttributes(this.gatherNamespaces(null));
        if (this.reader.getAttributeCount() > 0) {
            this.error("No attributes are allowed on the <notes> element.");
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.pushXMLAttributes();
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("note")) {
                            this.processNote(parent);
                            hasNotes = true;
                            break;
                        }
                        this.error("Only <note> elements are allowed in <notes> elements.");
                        break;
                    }
                    this.error("Only <note> elements are allowed in <notes> elements.");
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0") || !tmp.equals("notes")) break;
                    if (!hasNotes) {
                        this.error("A <notes> element must have at least one <note>.");
                    }
                    return;
                }
            }
        }
    }

    private Map<String, DataElementContent> processOriginalData() throws XMLStreamException {
        LinkedHashMap<String, DataElementContent> map = new LinkedHashMap<String, DataElementContent>();
        StringBuilder content = new StringBuilder();
        String id = null;
        Directionality dir = null;
        boolean inData = false;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    if (id == null) break;
                    content.append(this.reader.getText());
                    break;
                }
                case 1: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("data")) {
                            id = this.reader.getAttributeValue("", "id");
                            this.mustBeValidNmtoken("id", id, false);
                            if (map.containsKey(id)) {
                                this.error(String.format("Duplicated id '%s' in original data table.", id));
                            }
                            dir = this.getDirectionality("dir", this.reader.getAttributeValue("", "dir"), Directionality.AUTO);
                            inData = true;
                            break;
                        }
                        if (tmp.equals("cp")) {
                            tmp = this.reader.getAttributeValue("", "hex");
                            this.cannotBeNullOrEmpty("hex", tmp);
                            content.append(this.convertHexAttribute(tmp));
                            break;
                        }
                        if (inData) {
                            this.error("Only text is allowed in <data> elements.");
                            break;
                        }
                        this.error("Only <data> is allowed in <originalData> elements.");
                        break;
                    }
                    if (inData) {
                        this.error("Only text is allowed in <data> elements.");
                        break;
                    }
                    this.error("Only <data> is allowed in <originalData> elements.");
                    break;
                }
                case 2: {
                    String tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (tmp.equals("data")) {
                        map.put(id, new DataElementContent(content.toString(), dir));
                        id = null;
                        dir = null;
                        content.setLength(0);
                        inData = false;
                        break;
                    }
                    if (!tmp.equals("originalData")) break;
                    if (map.isEmpty()) {
                        this.error("There must be at least one <data> in a <originalData>.");
                    }
                    return map;
                }
            }
        }
        return null;
    }

    private void processPart(boolean isSegment, HashMap<String, Boolean> partIds) throws XMLStreamException {
        String tmp;
        Part part;
        if (isSegment) {
            this.segment = this.unit.appendSegment();
            part = this.segment;
            this.segment.setCanResegment(this.inheritedData.peek().getCanResegment());
            block16: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                String ns = this.reader.getAttributeNamespace(i);
                String locName = this.reader.getAttributeLocalName(i);
                String value = this.reader.getAttributeValue(i);
                if (Util.isNoE(ns)) {
                    switch (locName) {
                        case "id": {
                            break;
                        }
                        case "canResegment": {
                            if (!this.canBeYesOrNo("canResegment", value)) continue block16;
                            this.segment.setCanResegment(value.equals("yes"));
                            break;
                        }
                        case "state": {
                            this.segment.setState(value);
                            break;
                        }
                        case "subState": {
                            if (this.reader.getAttributeValue("", "state") == null) {
                                this.error("If <segment> has a subState, state must be set explicitly.");
                            }
                            this.segment.setSubState(value);
                            break;
                        }
                        default: {
                            this.error(String.format("Invalid attribute '%s' in <segment>.", locName));
                            break;
                        }
                    }
                    continue;
                }
                this.error(String.format("Invalid attribute '%s' in <segment>.", locName));
            }
        } else {
            part = this.ignorable = this.unit.appendIgnorable();
        }
        if (this.mustBeValidNmtoken("id", tmp = this.reader.getAttributeValue("", "id"), true)) {
            if (partIds.containsKey(tmp)) {
                this.error(String.format("The id value '%s' is used more than once for <segment> or <ignorable>.", tmp));
            } else {
                partIds.put(tmp, false);
            }
            part.setId(tmp);
        }
        Boolean srcPreserveWS = null;
        Boolean trgPreserveWS = null;
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        if (tmp.equals("source")) {
                            if (srcPreserveWS != null) {
                                this.error("Cannot have more than one <source> per <segment> or <ignorable>.");
                            }
                            srcPreserveWS = this.xmlAttributes.peek().startsWith("p");
                            if (isSegment) {
                                this.processContent(this.segment, false, false);
                                break;
                            }
                            this.processContent(this.ignorable, false, false);
                            break;
                        }
                        if (tmp.equals("target")) {
                            if (trgPreserveWS != null) {
                                this.error("Cannot have more than one <target> per <segment> or <ignorable>.");
                            }
                            trgPreserveWS = this.xmlAttributes.peek().startsWith("p");
                            if (isSegment) {
                                this.processContent(this.segment, true, false);
                            } else {
                                this.processContent(this.ignorable, true, false);
                            }
                            if (this.docData.getTargetLanguage() != null) break;
                            this.error("No target language defined in a file with a target entry.");
                            break;
                        }
                        this.error("Only <source> and <target> are allowed in <segment> or <ignorable> elements.");
                        break;
                    }
                    this.error("Only <source> and <target> are allowed in <segment> or <ignorable> elements.");
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    String nsUri = this.reader.getNamespaceURI();
                    this.popXMLAttributes();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) break;
                    if (srcPreserveWS == null) {
                        this.error("Missing <source> element.");
                    }
                    if (srcPreserveWS != null && trgPreserveWS != null && !srcPreserveWS.equals(trgPreserveWS)) {
                        this.error("Source and target must be set to the same whitespace handling option.");
                    }
                    return;
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processContent(Part partToFill, boolean isTarget, boolean allowAnyTargetLang) throws XMLStreamException {
        frag = new Fragment(partToFill.getStore(), isTarget);
        code = null;
        inTextContent = true;
        dataRef = null;
        pairs = new Stack<Tag>();
        dirCtx = new Stack<Directionality>();
        dirCtx.push(isTarget != false ? partToFill.getStore().getTargetDir() : partToFill.getStore().getSourceDir());
        lang = this.xmlAttributes.peek().substring(1);
        if (!lang.isEmpty()) {
            if (isTarget) {
                if (this.docData.getTargetLanguage() == null) {
                    this.error("You must define a target language (trgLang) in the <xliff> element.");
                }
                if (!allowAnyTargetLang && !lang.equals(this.docData.getTargetLanguage())) {
                    this.error(String.format("Invalid target language ('%s') set or inherited. It should be '%s'.", new Object[]{lang, this.docData.getTargetLanguage()}));
                }
            } else if (!lang.equals(this.docData.getSourceLanguage())) {
                this.error(String.format("Invalid source language ('%s') set or inherited. It should be '%s'.", new Object[]{lang, this.docData.getSourceLanguage()}));
            }
        }
        partToFill.setPreserveWS(this.xmlAttributes.peek().startsWith("p"));
        block51: for (i = 0; i < this.reader.getAttributeCount(); ++i) {
            locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (isTarget && locName.equals("order")) {
                    try {
                        order = Integer.parseInt(value);
                        partToFill.setTargetOrder(order);
                        this.checkTargetOrder = true;
                    }
                    catch (NumberFormatException e) {
                        this.error(String.format("Invalid numeric value '%s' for order attribute.", new Object[]{value}));
                    }
                    continue;
                }
                if (isTarget) {
                    this.error(String.format("Invalid attribute '%s' in <target>.", new Object[]{locName}));
                    continue;
                }
                this.error(String.format("Invalid attribute '%s' <source>.", new Object[]{locName}));
                continue;
            }
            if (!ns.equals("http://www.w3.org/XML/1998/namespace")) ** GOTO lbl-1000
            e = locName;
            var17_21 = -1;
            switch (e.hashCode()) {
                case 109637894: {
                    if (!e.equals("space")) break;
                    var17_21 = 0;
                    break;
                }
                case 3314158: {
                    if (!e.equals("lang")) break;
                    var17_21 = 1;
                }
            }
            switch (var17_21) {
                case 0: 
                case 1: {
                    continue block51;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (isTarget) {
                        this.error(String.format("Invalid attribute '%s' in <target>.", new Object[]{locName}));
                        continue block51;
                    }
                    this.error(String.format("Invalid attribute '%s' <source>.", new Object[]{locName}));
                }
            }
        }
        currentElem = null;
        while (this.reader.hasNext()) {
            block8 : switch (this.reader.next()) {
                case 4: {
                    if (inTextContent) {
                        frag.append(this.reader.getText());
                        break;
                    }
                    this.error(String.format("The <%s> element must be empty.", new Object[]{currentElem}));
                    break;
                }
                case 3: 
                case 5: {
                    break;
                }
                case 1: {
                    currentElem = tmp = this.reader.getLocalName();
                    id = this.reader.getAttributeValue("", "id");
                    if (this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        var14_14 = tmp;
                        var15_16 = -1;
                        switch (var14_14.hashCode()) {
                            case 3664: {
                                if (!var14_14.equals("sc")) break;
                                var15_16 = 0;
                                break;
                            }
                            case 3230: {
                                if (!var14_14.equals("ec")) break;
                                var15_16 = 1;
                                break;
                            }
                            case 3576: {
                                if (!var14_14.equals("ph")) break;
                                var15_16 = 2;
                                break;
                            }
                            case 3571: {
                                if (!var14_14.equals("pc")) break;
                                var15_16 = 3;
                                break;
                            }
                            case 3674: {
                                if (!var14_14.equals("sm")) break;
                                var15_16 = 4;
                                break;
                            }
                            case 3240: {
                                if (!var14_14.equals("em")) break;
                                var15_16 = 5;
                                break;
                            }
                            case 108390: {
                                if (!var14_14.equals("mrk")) break;
                                var15_16 = 6;
                                break;
                            }
                            case 3181: {
                                if (!var14_14.equals("cp")) break;
                                var15_16 = 7;
                            }
                        }
                        switch (var15_16) {
                            case 0: {
                                this.mustBeValidNmtoken("id", id, false);
                                code = frag.append(TagType.OPENING, id, null, true);
                                dataRef = this.setDataRef(code);
                                inTextContent = false;
                                this.setOtherInlineAttributes('\ue101', code, null, false, isTarget, false, null, dirCtx);
                                break block8;
                            }
                            case 1: {
                                isolated = this.reader.getAttributeValue("", "isolated");
                                startRef = this.reader.getAttributeValue("", "startRef");
                                if (id != null && startRef != null) {
                                    this.error("You cannot have both id and startRef attributes on a <ec/> element.");
                                }
                                if (isolated != null) {
                                    this.canBeYesOrNo("isolated", isolated);
                                    this.mustBeValidNmtoken("id", id, false);
                                } else {
                                    this.mustBeValidNmtoken("startRef", startRef, false);
                                    id = startRef;
                                }
                                code = frag.append(TagType.CLOSING, id, null, true);
                                dataRef = this.setDataRef(code);
                                inTextContent = false;
                                this.setOtherInlineAttributes('\ue102', code, null, false, isTarget, isolated != null, (CTag)frag.getOpeningTag(code), dirCtx);
                                break block8;
                            }
                            case 2: {
                                this.mustBeValidNmtoken("id", id, false);
                                code = frag.appendCode(id, null);
                                dataRef = this.setDataRef(code);
                                inTextContent = false;
                                this.setOtherInlineAttributes('\ue103', code, null, false, isTarget, false, null, dirCtx);
                                break block8;
                            }
                            case 3: {
                                this.mustBeValidNmtoken("id", id, false);
                                code = frag.append(TagType.OPENING, id, null, false);
                                this.setOtherInlineAttributes('\ue101', code, null, true, isTarget, false, null, dirCtx);
                                tmp = this.reader.getAttributeValue("", "dataRefStart");
                                if (this.cannotBeEmpty("dataRef", tmp)) {
                                    dataRef = tmp;
                                    code.setDataRef(dataRef);
                                }
                                code.setInitialWithData(dataRef != null);
                                code = null;
                                closing = new CTag(TagType.CLOSING, id, null);
                                this.setOtherInlineAttributes('\ue102', closing, null, true, isTarget, false, null, dirCtx);
                                tmp = this.reader.getAttributeValue("", "dataRefEnd");
                                if (tmp != null && dataRef == null || tmp == null && dataRef != null) {
                                    this.warning(String.format("Both '%s' and '%s' should be present or absent.", new Object[]{"dataRefStart", "dataRefEnd"}));
                                }
                                if (this.cannotBeEmpty("dataRef", tmp)) {
                                    closing.setDataRef(tmp);
                                }
                                closing.setInitialWithData(dataRef != null);
                                dataRef = null;
                                pairs.push(closing);
                                break block8;
                            }
                            case 4: {
                                this.mustBeValidNmtoken("id", id, false);
                                ann = new MTag(id, null);
                                ann = (MTag)this.setOtherInlineAttributes('\ue104', null, ann, false, isTarget, false, null, dirCtx);
                                frag.append(ann);
                                break block8;
                            }
                            case 5: {
                                id = this.reader.getAttributeValue("", "startRef");
                                this.mustBeValidNmtoken("startRef", id, false);
                                ann = frag.closeMarkerSpan(id);
                                this.setOtherInlineAttributes('\ue105', null, ann, false, isTarget, false, null, dirCtx);
                                break block8;
                            }
                            case 6: {
                                this.mustBeValidNmtoken("id", id, false);
                                ann = new MTag(id, "generic");
                                ann = (MTag)this.setOtherInlineAttributes('\ue104', null, ann, true, isTarget, false, null, dirCtx);
                                frag.append(ann);
                                closing = new MTag(ann);
                                this.setOtherInlineAttributes('\ue105', null, closing, true, isTarget, false, null, dirCtx);
                                pairs.push(closing);
                                break block8;
                            }
                            case 7: {
                                this.readCP(inTextContent, frag);
                                break block8;
                            }
                        }
                        this.error(String.format("Invalid element in inline content: '%s'", new Object[]{this.reader.getName().toString()}));
                        break;
                    }
                    this.error(String.format("Invalid element in inline content: '%s'", new Object[]{this.reader.getName().toString()}));
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    if (!this.reader.getNamespaceURI().equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        this.error("Only the core namespace is allowed in content.");
                    }
                    var14_14 = tmp;
                    var15_16 = -1;
                    switch (var14_14.hashCode()) {
                        case 3664: {
                            if (!var14_14.equals("sc")) break;
                            var15_16 = 0;
                            break;
                        }
                        case 3230: {
                            if (!var14_14.equals("ec")) break;
                            var15_16 = 1;
                            break;
                        }
                        case 3576: {
                            if (!var14_14.equals("ph")) break;
                            var15_16 = 2;
                            break;
                        }
                        case 3571: {
                            if (!var14_14.equals("pc")) break;
                            var15_16 = 3;
                            break;
                        }
                        case 108390: {
                            if (!var14_14.equals("mrk")) break;
                            var15_16 = 4;
                            break;
                        }
                        case -896505829: {
                            if (!var14_14.equals("source")) break;
                            var15_16 = 5;
                            break;
                        }
                        case -880905839: {
                            if (!var14_14.equals("target")) break;
                            var15_16 = 6;
                        }
                    }
                    switch (var15_16) {
                        case 0: 
                        case 1: 
                        case 2: {
                            code.setInitialWithData(dataRef != null);
                            inTextContent = true;
                            dataRef = null;
                            break block8;
                        }
                        case 3: {
                            frag.append((Tag)pairs.pop());
                            break block8;
                        }
                        case 4: {
                            frag.append((Tag)pairs.pop());
                            break block8;
                        }
                        case 5: {
                            partToFill.setSource(frag);
                            this.popXMLAttributes();
                            return;
                        }
                        case 6: {
                            partToFill.setTarget(frag);
                            this.popXMLAttributes();
                            return;
                        }
                    }
                }
            }
        }
    }

    private void checkAnnotation(MTag marker, boolean expliciteTranslate) {
        String ref = marker.getRef();
        URIContext ctx = null;
        if (ref != null) {
            ctx = this.uriContext.peek();
            this.uriParser.setURL(ref, ctx.getFileId(), ctx.getGroupId(), ctx.getUnitId());
        }
        switch (marker.getType()) {
            case "comment": {
                String val = marker.getValue();
                if (val == null && ref == null) {
                    this.error("A comment annotation must have value or ref specified.");
                }
                if (val != null && ref != null) {
                    this.error("A comment annotation must use either the value or the ref attribute, not both.");
                }
                if (ref == null) break;
                String nid = this.uriParser.getNoteId();
                if (nid == null) {
                    this.error(String.format("The ref value of a comment annotation must be a note, but '%s' is not.", ref));
                }
                this.uriParser.complementReference();
                if (!this.uriParser.getUnitId().equals(ctx.getUnitId()) || !this.uriParser.getFileId().equals(ctx.getFileId()) || this.uriParser.getRefContainer() != 'u') {
                    this.error(String.format("The ref value of a comment annotation must be a note in the same unit, but '%s' is not.", ref));
                }
                boolean found = false;
                if (this.unit.getNoteCount() > 0) {
                    for (Note note : this.unit.getNotes()) {
                        if (!note.getId().equals(nid)) continue;
                        found = true;
                        break;
                    }
                }
                if (found) break;
                this.error(String.format("No note with id='%s' found in the unit for '%s'.", nid, ref));
                break;
            }
            case "generic": {
                if (expliciteTranslate) break;
                this.error("Annotation of type='generic' must have the translate attribute set explicitly.");
            }
        }
    }

    private void readCP(boolean inTextContent, Fragment frag) {
        char[] chars;
        if (!inTextContent) {
            this.error(String.format("The <%s> element must be empty.", "cp"));
        }
        String tmp = this.reader.getAttributeValue("", "hex");
        this.cannotBeNullOrEmpty("hex", tmp);
        for (char c : chars = this.convertHexAttribute(tmp)) {
            frag.append(c);
        }
    }

    private char[] convertHexAttribute(String value) {
        try {
            int cp = Integer.valueOf(value, 16);
            if (Util.isValidInXML(cp)) {
                this.error(String.format("Code-point U+%04X is valid in XML and must not be encoded with <cp/>.", cp));
            }
            return Character.toChars(cp);
        }
        catch (IllegalArgumentException e) {
            this.error(String.format("Invalid code-point value in '%s': '%s'", "hex", value));
            return null;
        }
    }

    private void checkECValueAgainstSC(String attName, String scValue, String ecValue) {
        if (scValue == null) {
            if (ecValue != null) {
                this.error(String.format("The value for '%s' is not defined in the <ec> element, but is defined in the <ec/> element.", attName));
            }
        } else if (!scValue.equals(ecValue)) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", ecValue, attName, scValue));
        }
    }

    private void checkECCanReorderAgainstSC(String attName, CanReorder scValue, String ecValue) {
        if (scValue == CanReorder.FIRSTNO) {
            if (ecValue.equals("yes")) {
                this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", new Object[]{ecValue, attName, scValue}));
            }
        } else if (!scValue.toString().equals(ecValue)) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", new Object[]{ecValue, attName, scValue}));
        }
    }

    private void checkECValueAgainstSC(String attName, boolean scValue, boolean ecValue) {
        if (scValue != ecValue) {
            this.error(String.format("The value '%s' for '%s' in <ec/> is not matching the value '%s' in <sc/>.", ecValue ? "yes" : "no", attName, scValue ? "yes" : "no"));
        }
    }

    private Tag setOtherInlineAttributes(char inlineType, CTag ctag, MTag mtag, boolean paired, boolean isTarget, boolean closingIsolated, CTag opening, Stack<Directionality> dirCtx) {
        boolean openingIsolated = false;
        boolean expliciteTranslate = false;
        Tag tag = null;
        tag = ctag != null ? ctag : mtag;
        boolean closingNonIsolated = inlineType == '\ue102' && opening != null;
        tag.setExtAttributes(this.gatherNamespaces(tag.getExtAttributes()));
        boolean canReorderChk = false;
        boolean dirChk = false;
        boolean copyOfChk = false;
        boolean subTypeChk = false;
        boolean canOverlapChk = false;
        boolean canDeleteChk = false;
        boolean canCopyChk = false;
        boolean typeChk = false;
        String value = this.reader.getAttributeValue("", "type");
        if (value != null) {
            switch (inlineType) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    if (closingNonIsolated) {
                        this.checkECValueAgainstSC("type", opening.getType(), value);
                        typeChk = true;
                        break;
                    }
                    ctag.setType(value);
                    break;
                }
                case '\ue104': {
                    if (value.equals("term") || value.equals("its:term-no")) {
                        mtag = new TermTag(mtag, value, this.inheritedData.peek().getAnnotatorsRef());
                        tag = mtag;
                        break;
                    }
                    mtag.setType(value);
                    break;
                }
            }
        }
        block135: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            value = this.reader.getAttributeValue(i);
            if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                block12 : switch (locName) {
                    case "id": {
                        break;
                    }
                    case "startRef": {
                        break;
                    }
                    case "dataRef": {
                        break;
                    }
                    case "dataRefStart": {
                        break;
                    }
                    case "dataRefEnd": {
                        break;
                    }
                    default: {
                        switch (locName) {
                            case "canCopy": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': 
                                    case '\ue103': {
                                        if (!this.canBeYesOrNo("canCopy", value)) continue block135;
                                        if (closingNonIsolated) {
                                            this.checkECValueAgainstSC("canCopy", opening.getCanCopy(), value.equals("yes"));
                                            canCopyChk = true;
                                            break;
                                        }
                                        ctag.setCanCopy(value.equals("yes"));
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        break;
                                    }
                                }
                                continue block135;
                            }
                            case "canDelete": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': 
                                    case '\ue103': {
                                        if (!this.canBeYesOrNo("canDelete", value)) continue block135;
                                        if (closingNonIsolated) {
                                            this.checkECValueAgainstSC("canDelete", opening.getCanDelete(), value.equals("yes"));
                                            canDeleteChk = true;
                                            break;
                                        }
                                        ctag.setCanDelete(value.equals("yes"));
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        break;
                                    }
                                }
                                continue block135;
                            }
                            case "canReorder": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': 
                                    case '\ue103': {
                                        if (!this.canBeYesOrNoOrFirstNo("canReorder", value)) continue block135;
                                        if (closingNonIsolated) {
                                            this.checkECCanReorderAgainstSC("canReorder", opening.getCanReorder(), value);
                                            canReorderChk = true;
                                            break;
                                        }
                                        switch (value) {
                                            case "firstNo": {
                                                ctag.setCanReorder(CanReorder.FIRSTNO);
                                                break;
                                            }
                                            case "no": {
                                                ctag.setCanReorder(CanReorder.NO);
                                                break;
                                            }
                                            default: {
                                                ctag.setCanReorder(CanReorder.YES);
                                            }
                                        }
                                        if (ctag.getCanReorder() == CanReorder.YES || this.reader.getAttributeValue("", "canCopy") != null && this.reader.getAttributeValue("", "canDelete") != null) continue block135;
                                        this.error("Both canCopy and canDelete must be set to 'no' if canReorder is not set to 'yes'.");
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        break;
                                    }
                                }
                                continue block135;
                            }
                            case "copyOf": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': 
                                    case '\ue103': {
                                        if (!this.cannotBeEmpty("copyOf", value)) continue block135;
                                        if (closingNonIsolated) {
                                            this.checkECValueAgainstSC("copyOf", opening.getCopyOf(), value);
                                            copyOfChk = true;
                                            break;
                                        }
                                        ctag.setCopyOf(value);
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        break;
                                    }
                                }
                                continue block135;
                            }
                            case "type": {
                                break block12;
                            }
                            case "subType": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': 
                                    case '\ue103': {
                                        if (this.reader.getAttributeValue("", "type") == null) {
                                            this.error("An inline code with a subType attribute must also have a type attribute.");
                                        }
                                        if (closingNonIsolated) {
                                            this.checkECValueAgainstSC("subType", opening.getSubType(), value);
                                            subTypeChk = true;
                                            break block12;
                                        }
                                        ctag.setSubType(value);
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "dir": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': {
                                        Directionality dir = this.getDirectionality("dir", value, dirCtx.peek());
                                        if (closingNonIsolated) {
                                            if (opening.getDir() != dir) {
                                                this.error(String.format("The value '%s' for 'dir' in <ec/> is not matching the value '%s' in <sc/>.", dir.toString(), dirCtx.peek().toString()));
                                            }
                                            dirChk = true;
                                        } else {
                                            ctag.setDir(dir);
                                        }
                                        if (inlineType == '\ue101') {
                                            dirCtx.push(dir);
                                            break;
                                        }
                                        if (dirCtx.isEmpty()) continue block135;
                                        dirCtx.pop();
                                        break;
                                    }
                                    default: {
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        break;
                                    }
                                }
                                continue block135;
                            }
                            case "value": {
                                switch (inlineType) {
                                    case '\ue104': 
                                    case '\ue105': {
                                        mtag.setValue(value);
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "ref": {
                                switch (inlineType) {
                                    case '\ue104': 
                                    case '\ue105': {
                                        mtag.setRef(value);
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "translate": {
                                switch (inlineType) {
                                    case '\ue104': 
                                    case '\ue105': {
                                        this.canBeYesOrNo("translate", value);
                                        mtag.setTranslate("yes".equals(value));
                                        expliciteTranslate = true;
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "isolated": {
                                switch (inlineType) {
                                    case '\ue101': {
                                        this.canBeYesOrNo("isolated", value);
                                        openingIsolated = true;
                                        break block12;
                                    }
                                    case '\ue102': {
                                        closingIsolated = true;
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "canOverlap": {
                                switch (inlineType) {
                                    case '\ue101': 
                                    case '\ue102': {
                                        boolean yon = this.getYesOrNo("canOverlap", value, !paired);
                                        if (closingNonIsolated) {
                                            this.checkECValueAgainstSC("canOverlap", opening.getCanOverlap(), yon);
                                            canOverlapChk = true;
                                            break block12;
                                        }
                                        ctag.setCanOverlap(yon);
                                        break block12;
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "equiv": {
                                if (!paired) {
                                    switch (inlineType) {
                                        case '\ue101': 
                                        case '\ue102': 
                                        case '\ue103': {
                                            ctag.setEquiv(value);
                                            break block12;
                                        }
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "equivStart": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue101': {
                                            ctag.setEquiv(value);
                                            break block12;
                                        }
                                    }
                                    break block12;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "equivEnd": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue102': {
                                            ctag.setEquiv(value);
                                            break block12;
                                        }
                                    }
                                    break block12;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "disp": {
                                if (!paired) {
                                    switch (inlineType) {
                                        case '\ue101': 
                                        case '\ue102': 
                                        case '\ue103': {
                                            ctag.setDisp(value);
                                            break block12;
                                        }
                                    }
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "dispStart": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue101': {
                                            ctag.setDisp(value);
                                            break block12;
                                        }
                                    }
                                    break block12;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "dispEnd": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue102': {
                                            ctag.setDisp(value);
                                            break block12;
                                        }
                                    }
                                    break block12;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "subFlows": {
                                if (!paired) {
                                    switch (inlineType) {
                                        case '\ue101': 
                                        case '\ue102': 
                                        case '\ue103': {
                                            ctag.setSubFlows(value);
                                            for (String id : ctag.getSubFlowsIds()) {
                                                this.subFlowIds.add(id);
                                            }
                                            break;
                                        }
                                    }
                                    break block12;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "subFlowsStart": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue101': {
                                            ctag.setSubFlows(value);
                                            for (String id : ctag.getSubFlowsIds()) {
                                                this.subFlowIds.add(id);
                                            }
                                            continue block135;
                                        }
                                    }
                                    continue block135;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            case "subFlowsEnd": {
                                if (paired) {
                                    switch (inlineType) {
                                        case '\ue102': {
                                            ctag.setSubFlows(value);
                                            for (String id : ctag.getSubFlowsIds()) {
                                                this.subFlowIds.add(id);
                                            }
                                            continue block135;
                                        }
                                    }
                                    continue block135;
                                }
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                            default: {
                                this.error(String.format("Invalid attribute '%s'.", locName));
                                break block12;
                            }
                        }
                    }
                }
                continue;
            }
            QName qname = this.reader.getAttributeName(i);
            if (ctag != null) {
                if (!qname.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:")) {
                    this.error(String.format("Invalid extension attribute (%s). Only attributes from core and modules can be used in inline codes.", qname.toString()));
                }
                if (inlineType == '\ue102') {
                    if (paired) continue;
                    if (!closingIsolated) {
                        this.error(String.format("Invalid module attribute %s. It is allowed in <ec> only when the element is isolated.", qname.toString()));
                    }
                    this.addExtAttribute(ctag, i, false);
                    continue;
                }
                this.addExtAttribute(ctag, i, false);
                continue;
            }
            if (inlineType == '\ue105') {
                if (paired) continue;
                this.error(String.format("Invalid attribute %s. No module or extension attribute is allowed in <em>.", qname.toString()));
                continue;
            }
            if (tag instanceof TermTag) {
                this.itsReader.readTerminology((TermTag)mtag, this.inheritedData.peek().getAnnotatorsRef());
            } else {
                this.itsReader.readAttributes(this.unit, mtag, this.inheritedData.peek().getAnnotatorsRef());
            }
            this.addExtAttribute(mtag, i, true);
        }
        if (ctag != null) {
            if (ctag.getCanReorder() != CanReorder.YES && (ctag.getCanCopy() || ctag.getCanDelete())) {
                this.error("If canReorder is not set to 'yes' then canCopy and canDelete must be set to 'no'.");
            }
            try {
                ctag.verifyTypeSubTypeValues();
            }
            catch (InvalidParameterException e) {
                this.error(e.getLocalizedMessage());
            }
            if (closingIsolated || openingIsolated) {
                if (isTarget) {
                    this.trgIsolated.add(ctag);
                } else {
                    this.srcIsolated.add(ctag);
                }
            }
            if (closingNonIsolated) {
                if (!canCopyChk && !ctag.getCanCopy()) {
                    this.error(String.format("In <ec> with startRef='%s', the default canCopy value does not match the one of the corresponding <sc> ('%s').", ctag.getId(), opening.getCanCopy() ? "yes" : "no"));
                }
                if (!canDeleteChk && !ctag.getCanDelete()) {
                    this.error(String.format("In <ec> with startRef='%s', the default canDelete value does not match the one of the corresponding <sc> ('%s').", ctag.getId(), opening.getCanDelete() ? "yes" : "no"));
                }
                if (!typeChk && ctag.getType() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default type value does not match the one of the corresponding <sc> ('%s').", ctag.getId(), opening.getType()));
                }
                if (!subTypeChk && ctag.getSubType() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default subType value does not match the one of the corresponding <sc> ('%s').", ctag.getId(), opening.getSubType()));
                }
                if (!copyOfChk && ctag.getCopyOf() != null) {
                    this.error(String.format("In <ec> with startRef='%s', the default copyOf value does not match the one of the corresponding <sc> ('%s').", ctag.getId(), opening.getCopyOf()));
                }
                if (!canReorderChk && ctag.getCanReorder() != CanReorder.YES) {
                    this.error(String.format("In <ec> with startRef='%s', the default canReorder value is not valid for the corresponding <sc> value ('%s').", new Object[]{ctag.getId(), opening.getCanReorder()}));
                }
            }
        } else if (mtag.getTagType() == TagType.OPENING) {
            this.checkAnnotation(mtag, expliciteTranslate);
        }
        return tag;
    }

    private String setDataRef(CTag code) {
        String tmp = this.reader.getAttributeValue("", "dataRef");
        if (this.cannotBeEmpty("dataRef", tmp)) {
            code.setDataRef(tmp);
            return tmp;
        }
        return null;
    }

    private ExtAttributes gatherExtAttributes(boolean isExtElement) {
        int i;
        ExtAttributes attrs = null;
        for (i = 0; i < this.reader.getNamespaceCount(); ++i) {
            String namespaceURI = this.reader.getNamespaceURI(i);
            if (namespaceURI.equals("urn:oasis:names:tc:xliff:document:2.0")) continue;
            if (attrs == null) {
                attrs = new ExtAttributes();
            }
            attrs.setNamespace(this.reader.getNamespacePrefix(i), namespaceURI);
        }
        for (i = 0; i < this.reader.getAttributeCount(); ++i) {
            QName qname = this.reader.getAttributeName(i);
            if (!isExtElement && qname.getNamespaceURI().isEmpty()) continue;
            if (attrs == null) {
                attrs = new ExtAttributes();
            }
            attrs.setAttribute(new ExtAttribute(qname, this.reader.getAttributeValue(i)));
            if (!qname.getLocalPart().equals("id") || !qname.getNamespaceURI().equals("http://www.w3.org/XML/1998/namespace") && !qname.getNamespaceURI().isEmpty()) continue;
            this.mustBeValidNmtoken(qname.toString(), this.reader.getAttributeValue(i), false);
            this.checkAndAddSpecialId(this.reader.getNamespaceURI(), this.reader.getAttributeValue(i));
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs;
    }

    private ExtAttributes gatherNamespaces(ExtAttributes attrs) {
        for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
            String namespaceURI = this.reader.getNamespaceURI(i);
            if (namespaceURI.equals("urn:oasis:names:tc:xliff:document:2.0")) continue;
            if (attrs == null) {
                attrs = new ExtAttributes();
            }
            attrs.setNamespace(this.reader.getNamespacePrefix(i), namespaceURI);
        }
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        return attrs;
    }

    private void addExtAttribute(IWithExtAttributes object, int attributeIndex, boolean skipITS) {
        QName qname = this.reader.getAttributeName(attributeIndex);
        String ns = qname.getNamespaceURI();
        if (skipITS && ns != null && (ns.equals("http://www.w3.org/2005/11/its") || ns.equals("http://www.w3.org/ns/its-xliff/"))) {
            return;
        }
        if (this.locValidator != null) {
            String parentName = this.reader.getLocalName();
            switch (this.locValidator.verify(parentName, qname, true)) {
                case 1: {
                    this.error(String.format("No modules are allowed in '%s'.", parentName));
                }
                case 2: {
                    this.error(String.format("Attribute '%s' is not allowed in '%s'.", qname, parentName));
                }
            }
        }
        object.getExtAttributes().setAttribute(new ExtAttribute(qname, this.reader.getAttributeValue(attributeIndex)));
    }

    private ExtElements processExtElement(String parentName, ExtElements extElements) {
        if (extElements == null) {
            extElements = new ExtElements();
        }
        if (this.locValidator != null) {
            switch (this.locValidator.verify(parentName, this.reader.getName(), false)) {
                case 1: {
                    this.error(String.format("No modules are allowed in '%s'.", parentName));
                }
                case 3: {
                    this.error(String.format("Too many occurrences of '%s' in '%s'.", this.reader.getName(), parentName));
                }
                case 2: {
                    this.error(String.format("Element '%s' is not allowed in '%s'.", this.reader.getName(), parentName));
                }
            }
        }
        extElements.add(this.readExtElement());
        return extElements;
    }

    private ExtElement readExtElement() {
        try {
            ExtElement elem = new ExtElement(this.reader.getName());
            elem.setExtAttributes(this.gatherExtAttributes(true));
            List<IExtChild> children = elem.getChildren();
            while (this.reader.hasNext()) {
                switch (this.reader.next()) {
                    case 1: {
                        this.pushXMLAttributes();
                        children.add(this.readExtElement());
                        break;
                    }
                    case 2: {
                        if (!this.reader.getName().equals(elem.getQName())) break;
                        this.popXMLAttributes();
                        return elem;
                    }
                    case 4: 
                    case 6: {
                        children.add(new ExtContent(this.reader.getText()));
                        break;
                    }
                    case 12: {
                        children.add(new ExtContent(this.reader.getText(), true));
                        break;
                    }
                    case 3: {
                        children.add(new ProcessingInstruction("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>"));
                    }
                }
            }
            throw new IOException("Unexpected end of file.");
        }
        catch (IOException | XMLStreamException e) {
            this.error("Error adding an extension element. " + e.getMessage());
            return null;
        }
    }

    private void processChangeTracking(IWithChangeTrack parent) throws XMLStreamException {
        if (!this.reader.getLocalName().equals("changeTrack")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        if (parent.hasChangeTrack()) {
            this.error(String.format("Too many elements '%s'", this.reader.getName().toString()));
        }
        ChangeTrack changeTrack = new ChangeTrack();
        block4: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processRevisions(changeTrack);
                    continue block4;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (changeTrack.isEmpty()) {
                        this.error("You must have at least one <revisions> element in a <changeTrack> element.");
                    }
                    parent.setChangeTrack(changeTrack);
                    return;
                }
            }
        }
    }

    private void processRevisions(ChangeTrack changeTrack) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("revisions") || !nsUri.equals("urn:oasis:names:tc:xliff:changetracking:2.0")) {
            this.error(String.format("Invalid element '%s' in <changeTrack>.", this.reader.getName().toString()));
        }
        Revisions revisions = new Revisions();
        this.pushXMLAttributes();
        revisions.setExtAttributes(this.gatherNamespaces(revisions.getExtAttributes()));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "appliesTo": {
                        revisions.setAppliesTo(value);
                        break;
                    }
                    case "ref": {
                        revisions.setRef(value);
                        break;
                    }
                    case "currentVersion": {
                        revisions.setCurrentVersion(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(revisions, i, false);
        }
        if (revisions.getAppliesTo() == null) {
            this.error("Attribute appliesTo is required for <revisions> element.");
        }
        block15: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processRevision(revisions);
                    continue block15;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (revisions.isEmpty()) {
                        this.error("You must have at least one <revision> element in a <revisions> element.");
                    }
                    if (revisions.getCurrentVersion() != null && !revisions.getCurrentVersion().isEmpty()) {
                        boolean found = false;
                        for (Revision rev : revisions) {
                            String ver = rev.getVersion();
                            if (ver == null || !ver.equals(revisions.getCurrentVersion())) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            this.error(String.format("The '%s' '%s' was not found in the list of '%s' elements.", "currentVersion", revisions.getCurrentVersion(), "revision"));
                        }
                    }
                    changeTrack.add(revisions);
                    return;
                }
            }
        }
    }

    private void processRevision(Revisions revisions) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("revision") || !nsUri.equals("urn:oasis:names:tc:xliff:changetracking:2.0")) {
            this.error(String.format("Invalid element '%s' in <revisions>.", this.reader.getName().toString()));
        }
        Revision revision = new Revision();
        this.pushXMLAttributes();
        revision.setExtAttributes(this.gatherNamespaces(revision.getExtAttributes()));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "author": {
                        revision.setAuthor(value);
                        break;
                    }
                    case "datetime": {
                        revision.setDatetime(value);
                        break;
                    }
                    case "version": {
                        revision.setVersion(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(revision, i, false);
        }
        block15: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processItem(revision);
                    continue block15;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (revision.isEmpty()) {
                        this.error(String.format("You must have at least one '%s' element in a '%s' element.", "item", "revision"));
                    }
                    revisions.add(revision);
                    return;
                }
            }
        }
    }

    private void processItem(Revision revision) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("item") || !nsUri.equals("urn:oasis:names:tc:xliff:changetracking:2.0")) {
            this.error(String.format("Invalid element '%s' in '%s'.", this.reader.getName().toString(), "revision"));
        }
        Item item = new Item();
        this.pushXMLAttributes();
        item.setExtAttributes(this.gatherNamespaces(item.getExtAttributes()));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (locName.equals("property")) {
                    item.setProperty(value);
                    continue;
                }
                this.error(String.format("Invalid attribute '%s'.", locName));
                continue;
            }
            this.addExtAttribute(item, i, false);
        }
        StringBuilder sb = new StringBuilder();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: {
                    sb.append(this.reader.getText());
                    break;
                }
                case 1: {
                    this.error(String.format("The '%s' element has only text content.", "item"));
                }
                case 2: {
                    this.popXMLAttributes();
                    item.setText(sb.toString());
                    revision.add(item);
                    return;
                }
            }
        }
    }

    protected void processMatches() throws XMLStreamException {
        if (!this.reader.getLocalName().equals("matches")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Matches matches = new Matches();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processMatch(matches);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (matches.isEmpty()) {
                        this.error("You must have at least one <match> element in a <matches> element.");
                    }
                    this.unit.setMatches(matches);
                    this.popSpecialIds();
                    this.srcIsolated.clear();
                    this.trgIsolated.clear();
                    return;
                }
            }
        }
    }

    private void processMatch(Matches matches) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("match") || !nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) {
            this.error(String.format("Invalid element '%s' in <matches>.", this.reader.getName().toString()));
        }
        Match match = new Match();
        Map<String, DataElementContent> matchODM = null;
        ExtElements extElems = null;
        this.pushXMLAttributes();
        match.setExtAttributes(this.gatherNamespaces(match.getExtAttributes()));
        AnnotatorsRef ar = this.inheritedData.peek().getAnnotatorsRef();
        if (ar != null) {
            match.setAnnoatorRef(ar.get("mt-confidence"));
        }
        block36: for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "ref": {
                        match.setRef(value);
                        break;
                    }
                    case "type": {
                        match.setType(value);
                        break;
                    }
                    case "subType": {
                        if (value == null) continue block36;
                        if (this.reader.getAttributeValue("", "type") == null) {
                            this.error("If <match> has a subType, type must be set explicitly.");
                        }
                        match.setSubType(value);
                        break;
                    }
                    case "id": {
                        this.mustBeValidNmtoken("id", value, true);
                        this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:matches:2.0", value);
                        match.setId(value);
                        break;
                    }
                    case "similarity": {
                        match.setSimilarity(Double.valueOf(value));
                        break;
                    }
                    case "matchQuality": {
                        match.setMatchQuality(Double.valueOf(value));
                        break;
                    }
                    case "matchSuitability": {
                        match.setMatchSuitability(Double.valueOf(value));
                        break;
                    }
                    case "origin": {
                        match.setOrigin(value);
                        break;
                    }
                    case "reference": {
                        if (!this.canBeYesOrNo("reference", value)) continue block36;
                        match.setReference(value.equals("yes"));
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            if (ns.equals("http://www.w3.org/XML/1998/namespace")) {
                if (!locName.equals("lang")) continue;
                this.error("The attribute xml:lang is not allowed in <match>.");
                continue;
            }
            if (ns.equals("http://www.w3.org/2005/11/its")) {
                if (locName.equals("annotatorsRef")) {
                    AnnotatorsRef tmpAR = this.itsReader.readAnnotatorsRef(false, ar);
                    if (tmpAR == null) continue;
                    match.setAnnoatorRef(tmpAR.get("mt-confidence"));
                    continue;
                }
                this.warning("Unexpected ITS attribute: " + locName);
                continue;
            }
            this.addExtAttribute(match, i, false);
        }
        Part part = new Part(match.getStore());
        int state = 0;
        while (this.reader.hasNext()) {
            block22 : switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:metadata:2.0")) {
                        if (state > 0) {
                            this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                        }
                        this.processMetadata(match);
                        state = 1;
                        break;
                    }
                    if (nsUri.equals("urn:oasis:names:tc:xliff:document:2.0")) {
                        switch (tmp) {
                            case "originalData": {
                                if (state > 1) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                matchODM = this.processOriginalData();
                                state = 2;
                                break block22;
                            }
                            case "source": {
                                if (state > 2) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                this.processContent(part, false, false);
                                match.setSource(part.getSource());
                                state = 3;
                                break block22;
                            }
                            case "target": {
                                if (state > 3) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                this.processContent(part, true, match.isReference());
                                match.setTarget(part.getTarget());
                                state = 4;
                                break block22;
                            }
                        }
                        this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
                        break;
                    }
                    if (state < 4) {
                        this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                    }
                    if (this.locValidator != null) {
                        this.locValidator.reset();
                    }
                    extElems = this.processExtElement("mtc:match", extElems);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:matches:2.0")) break;
                    if (state < 4) {
                        this.error("Missing element(s) in <match>.");
                    }
                    this.copyOriginalDataToCodes(match.getStore(), matchODM);
                    matches.add(match);
                    if (extElems != null) {
                        match.setExtElements(extElems);
                    }
                    this.popXMLAttributes();
                    return;
                }
            }
        }
    }

    private void processGlossary() throws XMLStreamException {
        if (!this.reader.getLocalName().equals("glossary")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Glossary glossary = new Glossary();
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    this.processGlossEntry(glossary);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (glossary.isEmpty()) {
                        this.error("You must have at least one <glossEntry> element in a <glossary> element.");
                    }
                    this.unit.setGlossary(glossary);
                    this.popSpecialIds();
                    return;
                }
            }
        }
    }

    private void processGlossEntry(Glossary glossary) throws XMLStreamException {
        String tmp = this.reader.getLocalName();
        String nsUri = this.reader.getNamespaceURI();
        if (!tmp.equals("glossEntry") || !nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) {
            this.error(String.format("Invalid element '%s' in <glossary>.", this.reader.getName().toString()));
        }
        GlossEntry entry = new GlossEntry();
        ExtElements extElems = null;
        this.pushXMLAttributes();
        entry.setExtAttributes(this.gatherNamespaces(entry.getExtAttributes()));
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                if (locName.equals("ref")) {
                    entry.setRef(value);
                    continue;
                }
                if (locName.equals("id")) {
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:glossary:2.0", value);
                    entry.setId(value);
                    continue;
                }
                this.error(String.format("Invalid attribute '%s'.", locName));
                continue;
            }
            this.addExtAttribute(entry, i, false);
        }
        int state = 0;
        while (this.reader.hasNext()) {
            block0 : switch (this.reader.next()) {
                case 1: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    this.pushXMLAttributes();
                    if (nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) {
                        switch (tmp) {
                            case "term": {
                                if (state != 0) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                                    String locName = this.reader.getAttributeLocalName(i);
                                    String value = this.reader.getAttributeValue(i);
                                    String ns = this.reader.getAttributeNamespace(i);
                                    if (Util.isNoE(ns)) {
                                        if (locName.equals("source")) {
                                            entry.getTerm().setSource(value);
                                            continue;
                                        }
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        continue;
                                    }
                                    this.addExtAttribute(entry.getTerm(), i, false);
                                }
                                entry.getTerm().setText(this.readTextContent(true));
                                state = 1;
                                break block0;
                            }
                            case "translation": {
                                String ns;
                                String value;
                                String locName;
                                int i;
                                if (state != 1) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                Translation trans = new Translation((String)null);
                                for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                                    locName = this.reader.getAttributeLocalName(i);
                                    value = this.reader.getAttributeValue(i);
                                    ns = this.reader.getAttributeNamespace(i);
                                    if (Util.isNoE(ns)) {
                                        switch (locName) {
                                            case "ref": {
                                                trans.setRef(value);
                                                break;
                                            }
                                            case "source": {
                                                trans.setSource(value);
                                                break;
                                            }
                                            case "id": {
                                                this.mustBeValidNmtoken("id", value, true);
                                                this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:glossary:2.0", value);
                                                trans.setId(value);
                                                break;
                                            }
                                            default: {
                                                this.error(String.format("Invalid attribute '%s'.", locName));
                                                break;
                                            }
                                        }
                                        continue;
                                    }
                                    this.addExtAttribute(trans, i, false);
                                }
                                trans.setText(this.readTextContent(true));
                                entry.getTranslations().add(trans);
                                break block0;
                            }
                            case "definition": {
                                String ns;
                                String value;
                                String locName;
                                int i;
                                if (state < 1 || state > 2) {
                                    this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                                }
                                entry.setDefinition(new Definition(""));
                                for (i = 0; i < this.reader.getAttributeCount(); ++i) {
                                    locName = this.reader.getAttributeLocalName(i);
                                    value = this.reader.getAttributeValue(i);
                                    ns = this.reader.getAttributeNamespace(i);
                                    if (Util.isNoE(ns)) {
                                        if (locName.equals("source")) {
                                            entry.getDefinition().setSource(value);
                                            continue;
                                        }
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        continue;
                                    }
                                    this.addExtAttribute(entry.getDefinition(), i, false);
                                }
                                entry.getDefinition().setText(this.readTextContent(true));
                                state = 3;
                                break block0;
                            }
                        }
                        this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
                        break;
                    }
                    if (state < 1) {
                        this.error(String.format("Element '%s' misplaced.", this.reader.getName().toString()));
                    }
                    if (this.locValidator != null) {
                        this.locValidator.reset();
                    }
                    extElems = this.processExtElement("gls:glossEntry", extElems);
                    break;
                }
                case 2: {
                    tmp = this.reader.getLocalName();
                    nsUri = this.reader.getNamespaceURI();
                    if (!nsUri.equals("urn:oasis:names:tc:xliff:glossary:2.0")) break;
                    if (state < 1) {
                        this.error("Missing element(s) in <glossEntry>.");
                    }
                    if ((entry.getDefinition() == null || Util.isNoE(entry.getDefinition().getText())) && entry.getTranslations().isEmpty()) {
                        this.error("A <glossEntry> must have at least a <translation> or a <definition>.");
                    }
                    glossary.add(entry);
                    if (extElems != null) {
                        entry.setExtElements(extElems);
                    }
                    this.popXMLAttributes();
                    return;
                }
            }
        }
    }

    private void processMetadata(IWithMetadata parent) throws XMLStreamException {
        if (!this.reader.getLocalName().equals("metadata")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        if (parent.hasMetadata()) {
            this.error(String.format("Too many elements '%s'", this.reader.getName().toString()));
        }
        this.pushSpecialIds();
        Metadata metadata = new Metadata();
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                if (locName.equals("id")) {
                    String value = this.reader.getAttributeValue(i);
                    this.mustBeValidNmtoken("id", value, true);
                    this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:metadata:2.0", value);
                    metadata.setId(value);
                    continue;
                }
                this.error(String.format("Invalid attribute '%s'.", locName));
                continue;
            }
            this.error(String.format("Invalid attribute '%s'.", locName));
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!"urn:oasis:names:tc:xliff:metadata:2.0".equals(this.reader.getNamespaceURI()) || !"metaGroup".equals(this.reader.getLocalName())) {
                        this.error(String.format("Invalid element '%s' in <metadata>.", this.reader.getName().toString()));
                    }
                    this.processMetaGroup(metadata);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (metadata.isEmpty()) {
                        this.error("You must have at least one entry a <metadata> element.");
                    }
                    parent.setMetadata(metadata);
                    this.popSpecialIds();
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processMetaGroup(IWithMetaGroup parent) throws XMLStreamException {
        MetaGroup group = new MetaGroup();
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "category": {
                        group.setCategory(value);
                        break;
                    }
                    case "appliesTo": {
                        group.setAppliesTo(MetaGroup.AppliesTo.fromString(value));
                        break;
                    }
                    case "id": {
                        this.mustBeValidNmtoken("id", value, true);
                        this.checkAndAddSpecialId("urn:oasis:names:tc:xliff:metadata:2.0", value);
                        group.setId(value);
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.error(String.format("Invalid attribute '%s'.", locName));
        }
        while (this.reader.hasNext()) {
            block10 : switch (this.reader.next()) {
                case 1: {
                    if ("urn:oasis:names:tc:xliff:metadata:2.0".equals(this.reader.getNamespaceURI())) {
                        switch (this.reader.getLocalName()) {
                            case "metaGroup": {
                                this.processMetaGroup(group);
                                break block10;
                            }
                            case "meta": {
                                String type = null;
                                for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
                                    String locName = this.reader.getAttributeLocalName(i);
                                    if (Util.isNoE(this.reader.getAttributeNamespace(i))) {
                                        if (locName.equals("type")) {
                                            type = this.reader.getAttributeValue(i);
                                            continue;
                                        }
                                        this.error(String.format("Invalid attribute '%s'.", locName));
                                        continue;
                                    }
                                    this.error(String.format("Invalid attribute '%s'.", locName));
                                }
                                if (type == null) {
                                    this.error("The <meta> element must have a type attribute.");
                                }
                                group.add(new Meta(type, this.readTextContent(false)));
                                break block10;
                            }
                        }
                    }
                    this.error(String.format("Invalid element '%s' in <metaGroup>.", this.reader.getName().toString()));
                    break;
                }
                case 2: {
                    if (group.isEmpty()) {
                        this.error("You must have at least one entry a <metaGroup> element.");
                    }
                    parent.addGroup(group);
                    return;
                }
            }
        }
        return;
    }

    private void processValidation(IWithValidation parent) throws XMLStreamException {
        if (!this.reader.getLocalName().equals("validation")) {
            this.error(String.format("Invalid element '%s'", this.reader.getName().toString()));
        }
        if (parent.hasValidation() && parent.getValidation().getDeclarationCount() > 0) {
            this.error(String.format("Too many elements '%s'", this.reader.getName().toString()));
        }
        Validation validation = parent.hasValidation() ? parent.getValidation() : this.valContext.peek();
        validation.addDeclaration();
        validation.setExtAttributes(this.gatherExtAttributes(false));
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 1: {
                    if (!"urn:oasis:names:tc:xliff:validation:2.0".equals(this.reader.getNamespaceURI()) || !"rule".equals(this.reader.getLocalName())) {
                        this.error(String.format("Invalid element '%s' in <validation>.", this.reader.getName().toString()));
                    }
                    this.processValidationRule(validation);
                    break;
                }
                case 2: {
                    this.popXMLAttributes();
                    if (validation.isEmpty()) {
                        this.error("You must have at least one entry a <validation> element.");
                    }
                    parent.setValidation(validation);
                    return;
                }
            }
        }
    }

    private void processValidationRule(Validation validation) throws XMLStreamException {
        Rule rule = new Rule("isPresent", null);
        String type = null;
        String occurs = null;
        String existsInSource = null;
        String caseSensitive = null;
        String disabled = null;
        String normalization = null;
        for (int i = 0; i < this.reader.getAttributeCount(); ++i) {
            String locName = this.reader.getAttributeLocalName(i);
            String value = this.reader.getAttributeValue(i);
            String ns = this.reader.getAttributeNamespace(i);
            if (Util.isNoE(ns)) {
                switch (locName) {
                    case "isPresent": 
                    case "isNotPresent": 
                    case "startsWith": 
                    case "endsWith": {
                        if (type != null) {
                            this.error(String.format("Attribute %s cannot be used is %s is also used.", locName, type));
                        }
                        this.cannotBeEmpty(locName, value);
                        type = locName;
                        rule.setType(Rule.Type.fromString(type));
                        rule.setData(value);
                        break;
                    }
                    case "occurs": {
                        occurs = value;
                        break;
                    }
                    case "caseSensitive": {
                        caseSensitive = value;
                        break;
                    }
                    case "normalization": {
                        normalization = value;
                        break;
                    }
                    case "existsInSource": {
                        existsInSource = value;
                        break;
                    }
                    case "disabled": {
                        disabled = value;
                        break;
                    }
                    default: {
                        this.error(String.format("Invalid attribute '%s'.", locName));
                        break;
                    }
                }
                continue;
            }
            this.addExtAttribute(rule, i, true);
        }
        if (type == null) {
            if (!rule.hasExtAttribute()) {
                this.error("Missing the type of the rule (isPresent, etc.)");
            }
            rule.setType(Rule.Type.CUSTOM);
        }
        if (this.canBeYesOrNo("caseSensitive", caseSensitive)) {
            rule.setCaseSensitive(caseSensitive.equals("yes"));
        }
        if (normalization != null) {
            rule.setNormalization(Rule.Normalization.fromString(normalization));
        }
        if (this.canBeYesOrNo("disabled", disabled)) {
            rule.setEnabled(disabled.equals("no"));
        }
        if (existsInSource != null) {
            switch (rule.getType()) {
                case ISPRESENT: 
                case STARTSWITH: 
                case ENDSWITH: {
                    this.canBeYesOrNo("existsInSource", existsInSource);
                    rule.setExistsInSource(existsInSource.equals("yes"));
                    break;
                }
                case ISNOTPRESENT: 
                case CUSTOM: {
                    this.error("The attribute existsInSource is not valid for this type of rule.");
                }
            }
        }
        if (occurs != null) {
            try {
                int number = Integer.parseInt(occurs);
                if (number < 1) {
                    this.error("The value of the attribute 'occurs' must be 1 or higer.");
                }
                rule.setOccurs(number);
            }
            catch (NumberFormatException e) {
                this.error(String.format("Invalid syntax for attribute 'occurs' (%s).", occurs));
            }
        }
        while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 2: {
                    boolean add = true;
                    int i = 0;
                    for (Rule existing : validation) {
                        if (!existing.isInherited() || existing.getType() == Rule.Type.CUSTOM) continue;
                        if (existing.getType() == rule.getType() && existing.getData().equals(rule.getData())) {
                            rule.prepare();
                            validation.set(i, rule);
                            add = false;
                        }
                        ++i;
                    }
                    if (add) {
                        rule.prepare();
                        validation.add(rule);
                    }
                    return;
                }
            }
        }
    }

    private String readTextContent(boolean popXMLAttributes) throws XMLStreamException {
        StringBuilder tmp = new StringBuilder();
        block5: while (this.reader.hasNext()) {
            switch (this.reader.next()) {
                case 4: 
                case 6: 
                case 12: {
                    tmp.append(this.reader.getText());
                    continue block5;
                }
                case 3: 
                case 5: {
                    continue block5;
                }
                case 2: {
                    if (popXMLAttributes) {
                        this.popXMLAttributes();
                    }
                    return tmp.toString();
                }
            }
            this.error(String.format("Invalid element '%s' in text content.", this.reader.getName().toString()));
        }
        return null;
    }

    private static class DataElementContent {
        String content;
        Directionality dir;

        DataElementContent(String content, Directionality dir) {
            this.content = content;
            this.dir = dir;
        }
    }
}

