/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.serialization.textunitflat;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.Note;
import net.sf.okapi.common.annotation.NoteAnnotation;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.WhitespaceStrategy;
import net.sf.okapi.proto.textunitflat.AltTranslation;
import net.sf.okapi.proto.textunitflat.Note;
import net.sf.okapi.proto.textunitflat.Property;
import net.sf.okapi.proto.textunitflat.TextFragment;
import net.sf.okapi.proto.textunitflat.TextPart;
import net.sf.okapi.proto.textunitflat.TextUnits;

public class Proto2TextUnitFlat {
    static TextFragment.TagType toTagType(TextFragment.TagType tt) {
        switch (tt) {
            case CLOSING: {
                return TextFragment.TagType.CLOSING;
            }
            case OPENING: {
                return TextFragment.TagType.OPENING;
            }
            case PLACEHOLDER: {
                return TextFragment.TagType.PLACEHOLDER;
            }
        }
        return TextFragment.TagType.valueOf("ERROR");
    }

    static Code toCode(net.sf.okapi.proto.textunitflat.Code code) {
        Code result = new Code(Proto2TextUnitFlat.toTagType(code.getTagType()), code.getCodeType(), code.getData());
        result.setId(code.getId());
        result.setOuterData(code.getOuterData());
        result.setFlag(code.getFlag());
        result.setDisplayText(code.getDisplayText());
        code.getOriginalId();
        result.setOriginalId(code.getOriginalId());
        result.setAdded(code.getAdded());
        if (code.hasMergedData()) {
            result.setMergedData(code.getMergedData());
        }
        for (Property property : code.getPropertiesList()) {
            result.setProperty(Proto2TextUnitFlat.toProperty(property));
        }
        return result;
    }

    static net.sf.okapi.common.resource.TextFragment toTextFragment(TextFragment tf) {
        net.sf.okapi.common.resource.TextFragment result = new net.sf.okapi.common.resource.TextFragment(tf.getText());
        int codeCount = 0;
        for (net.sf.okapi.proto.textunitflat.Code code : tf.getCodesList()) {
            result.insert(code.getPosition() + codeCount * 2, Proto2TextUnitFlat.toCode(code));
            ++codeCount;
        }
        result.balanceMarkers();
        return result;
    }

    private static TextPart toTextPart(net.sf.okapi.proto.textunitflat.TextPart part) {
        TextPart result = part.getSegment() ? new Segment(part.getId(), Proto2TextUnitFlat.toTextFragment(part.getText())) : new TextPart(Proto2TextUnitFlat.toTextFragment(part.getText()));
        for (Property property : part.getPropertiesList()) {
            result.setProperty(Proto2TextUnitFlat.toProperty(property));
        }
        result.setOriginalId(part.getOriginalId());
        result.setWhitespaceStrategy(Proto2TextUnitFlat.toWhitespaceStrategy(part.getWhitespaceStrategy()));
        return result;
    }

    private static WhitespaceStrategy toWhitespaceStrategy(TextPart.WhitespaceStrategy whitespaceStrategy) {
        switch (whitespaceStrategy.getNumber()) {
            case 0: {
                return WhitespaceStrategy.INHERIT;
            }
            case 1: {
                return WhitespaceStrategy.PRESERVE;
            }
            case 2: {
                return WhitespaceStrategy.NORMALIZE;
            }
        }
        return WhitespaceStrategy.INHERIT;
    }

    static net.sf.okapi.common.resource.Property toProperty(Property prop) {
        return new net.sf.okapi.common.resource.Property(prop.getName(), prop.getValue(), prop.getReadOnly());
    }

    static TextContainer toTextContainer(net.sf.okapi.proto.textunitflat.TextContainer tc) {
        ArrayList<TextPart> parts = new ArrayList<TextPart>();
        for (net.sf.okapi.proto.textunitflat.TextPart textPart : tc.getPartsList()) {
            parts.add(Proto2TextUnitFlat.toTextPart(textPart));
        }
        TextContainer result = new TextContainer(parts.toArray(new TextPart[0]));
        result.setId(tc.getId());
        result.setMimeType(tc.getMimeType());
        result.setName(tc.getName());
        result.setType(tc.getTuType());
        result.setIsTranslatable(tc.getTranslatable());
        result.setPreserveWhitespaces(tc.getPreserveWS());
        result.setHasBeenSegmentedFlag(tc.getSegApplied());
        for (Property property : tc.getPropertiesList()) {
            result.setProperty(Proto2TextUnitFlat.toProperty(property));
        }
        if (tc.getAltTransCount() > 0) {
            AltTranslationsAnnotation altTranslationsAnnotation = new AltTranslationsAnnotation();
            for (net.sf.okapi.proto.textunitflat.AltTranslation at : tc.getAltTransList()) {
                altTranslationsAnnotation.add(Proto2TextUnitFlat.toAltTrans(at));
            }
            result.setAnnotation(altTranslationsAnnotation);
        }
        NoteAnnotation noteAnnotation = new NoteAnnotation();
        for (Note note : tc.getNotesList()) {
            noteAnnotation.add(Proto2TextUnitFlat.toNote(note));
        }
        result.setAnnotation(noteAnnotation);
        return result;
    }

    public static net.sf.okapi.common.annotation.Note toNote(Note note) {
        net.sf.okapi.common.annotation.Note result = new net.sf.okapi.common.annotation.Note(note.getNote());
        result.setAnnotates(Proto2TextUnitFlat.toAnnotates(note.getAnnotates()));
        result.setPriority(Proto2TextUnitFlat.toPriority(note.getPriority()));
        result.setFrom(note.getFrom());
        result.setXmlLang(note.getXmlLang());
        return result;
    }

    public static Note.Annotates toAnnotates(Note.Annotates annotates) {
        switch (annotates.name()) {
            case "source": {
                return Note.Annotates.SOURCE;
            }
            case "target": {
                return Note.Annotates.TARGET;
            }
        }
        return Note.Annotates.GENERAL;
    }

    public static Note.Priority toPriority(Note.Priority priority) {
        switch (priority.getNumber()) {
            case 0: {
                return Note.Priority.ONE;
            }
            case 1: {
                return Note.Priority.TWO;
            }
            case 2: {
                return Note.Priority.THREE;
            }
            case 3: {
                return Note.Priority.FOUR;
            }
            case 4: {
                return Note.Priority.FIVE;
            }
            case 5: {
                return Note.Priority.SIX;
            }
            case 6: {
                return Note.Priority.SEVEN;
            }
            case 7: {
                return Note.Priority.EIGHT;
            }
            case 8: {
                return Note.Priority.NINE;
            }
        }
        return Note.Priority.TEN;
    }

    public static MatchType toMatchType(AltTranslation.MatchType matchType) {
        switch (matchType.toString()) {
            case "ACCEPTED": {
                return MatchType.ACCEPTED;
            }
            case "EXACT_UNIQUE_ID": {
                return MatchType.EXACT_UNIQUE_ID;
            }
            case "EXACT_LOCAL_CONTEXT": {
                return MatchType.EXACT_LOCAL_CONTEXT;
            }
            case "EXACT": {
                return MatchType.EXACT;
            }
            case "EXACT_TEXT_ONLY": {
                return MatchType.EXACT_TEXT_ONLY;
            }
            case "FUZZY": {
                return MatchType.FUZZY;
            }
        }
        return MatchType.UKNOWN;
    }

    public static AltTranslation toAltTrans(net.sf.okapi.proto.textunitflat.AltTranslation altTrans) {
        LocaleId srcLoc = LocaleId.fromBCP47(altTrans.getSourceLocale());
        LocaleId trgLoc = LocaleId.fromBCP47(altTrans.getTargetLocale());
        AltTranslation result = new AltTranslation(srcLoc, trgLoc, Proto2TextUnitFlat.toTextUnit(altTrans.getTextUnit()), Proto2TextUnitFlat.toMatchType(altTrans.getType()), altTrans.getCombinedScore(), altTrans.getOrigin());
        result.setEngine(altTrans.getEngine());
        result.setFromOriginal(altTrans.getFromOriginal());
        result.setFuzzyScore(altTrans.getFuzzyScore());
        result.setQualityScore(altTrans.getQualityScore());
        result.setAltTransType(altTrans.getAltTransType());
        return result;
    }

    public static TextUnit toTextUnit(net.sf.okapi.proto.textunitflat.TextUnit tu) {
        TextUnit result = new TextUnit(tu.getId(), "");
        result.setSource(Proto2TextUnitFlat.toTextContainer(tu.getSource()));
        result.setMimeType(tu.getMimeType());
        result.setName(tu.getName());
        result.setType(tu.getTuType());
        result.setIsTranslatable(tu.getTranslatable());
        result.setPreserveWhitespaces(tu.getPreserveWS());
        for (Map.Entry<String, net.sf.okapi.proto.textunitflat.TextContainer> trg : tu.getTargetsMap().entrySet()) {
            result.setTarget(LocaleId.fromBCP47(trg.getKey()), Proto2TextUnitFlat.toTextContainer(trg.getValue()));
        }
        for (Property property : tu.getPropertiesList()) {
            result.setProperty(Proto2TextUnitFlat.toProperty(property));
        }
        NoteAnnotation na = new NoteAnnotation();
        for (Note note : tu.getNotesList()) {
            na.add(Proto2TextUnitFlat.toNote(note));
        }
        result.setAnnotation(na);
        return result;
    }

    public static List<TextUnit> toTextUnits(TextUnits tus) {
        ArrayList<TextUnit> result = new ArrayList<TextUnit>();
        for (net.sf.okapi.proto.textunitflat.TextUnit tu : tus.getTextUnitsList()) {
            result.add(Proto2TextUnitFlat.toTextUnit(tu));
        }
        return result;
    }
}

