/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.yaml.parser;

import java.util.LinkedList;
import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.filters.yaml.parser.Line;
import net.sf.okapi.filters.yaml.parser.YamlScalarTypes;

public class QuotedScalar {
    public YamlScalarTypes type;
    private String firstLine;
    public boolean firstLineHasContinuation = false;
    private List<Line> additionalLines = new LinkedList<Line>();

    public void setFirstLine(String line) {
        this.firstLine = line;
        if (line.startsWith("\"") || line.startsWith("'")) {
            this.firstLine = line.substring(1);
        }
    }

    public void addLine(Line line) {
        if (!line.line.isEmpty()) {
            this.additionalLines.add(line);
        }
    }

    public boolean isEmpty() {
        return this.firstLine.isEmpty();
    }

    public List<Line> getTranslatableStrings() {
        if (this.isEmpty()) {
            return null;
        }
        LinkedList<Line> lines = new LinkedList<Line>();
        StringBuilder t = new StringBuilder();
        Line lastLine = null;
        if (!this.additionalLines.isEmpty()) {
            if (!this.firstLineHasContinuation) {
                this.firstLine = Util.trimEnd(this.firstLine, " ");
                this.firstLine = this.firstLine + " ";
            }
            lastLine = this.additionalLines.remove(this.additionalLines.size() - 1);
        }
        String f = Line.decode(this.type.getQuoteChar() + this.firstLine + this.type.getQuoteChar());
        t.append(f);
        for (Line l : this.additionalLines) {
            if (l.isSkeleton) {
                if (l.isThrowAway) continue;
                if (t.length() > 0) {
                    lines.add(new Line(t.toString(), false));
                    t.setLength(0);
                }
                lines.add(l);
                continue;
            }
            String a = Line.decode(this.type.getQuoteChar() + this.adjustWhiteSpace(l, false) + this.type.getQuoteChar());
            t.append(a);
        }
        t.append(Line.decode(this.type.getQuoteChar() + this.adjustWhiteSpace(lastLine, true) + this.type.getQuoteChar()));
        lines.add(new Line(t.toString(), false));
        if (lastLine != null) {
            this.additionalLines.add(lastLine);
        }
        return lines;
    }

    private String adjustWhiteSpace(Line line, boolean lastLine) {
        if (line == null) {
            return "";
        }
        Object currentLine = line.line;
        switch (this.type) {
            case DOUBLE: {
                if (lastLine) {
                    if (line.startContinuation) {
                        return currentLine;
                    }
                    return Util.trimStart((String)currentLine, " ");
                }
                if (!line.startContinuation) {
                    currentLine = Util.trimStart((String)currentLine, " ");
                }
                if (!line.endContinuation) {
                    currentLine = Util.trimEnd((String)currentLine, " ");
                    currentLine = (String)currentLine + " ";
                }
                return currentLine;
            }
            case SINGLE: {
                if (lastLine) {
                    currentLine = Util.trimStart((String)currentLine, " ");
                } else {
                    currentLine = ((String)currentLine).trim();
                    currentLine = (String)currentLine + " ";
                }
                return currentLine;
            }
        }
        return currentLine;
    }

    public String getOriginalString() {
        StringBuilder s = new StringBuilder();
        s.append(this.type.getQuoteChar());
        s.append(this.firstLine);
        for (Line l : this.additionalLines) {
            s.append(l.line);
        }
        s.append(this.type.getQuoteChar());
        return s.toString();
    }

    public String toString() {
        return this.firstLine + "," + this.additionalLines.toString();
    }
}

