/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.filterwriter.XLIFFContent;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.SdlXliffConfLevel;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.its.ITSStandoffManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdlXliffSkeletonWriter
extends XLIFFSkeletonWriter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String SDL_SEG_LOCKED_MARKER = "[@#$SDLSEGLOCKED$#@]";
    public static final String SDL_SEG_CONF_MARKER = "[@#$SDLSEGCONF$#@]";
    public static final String SDL_SEG_ORIGIN_MARKER = "[@#$SDLSEGORIGIN$#@]";
    public static final String SDL_SEG_LOCKED_STARTMARKER = "[@#$SDLSEGLOCKED";
    public static final String SDL_SEG_CONF_STARTMARKER = "[@#$SDLSEGCONF";
    public static final String SDL_SEG_ORIGIN_STARTMARKER = "[@#$SDLSEGORIGIN";
    public static final String SDL_SEG_PROP_ENDMARKER = "$#@]";
    public static final String PROP_SDL_LOCKED = "sdl_lock";
    public static final String PROP_SDL_CONF = "sdl_conf";
    public static final String PROP_SDL_ORIGIN = "sdl_origin";
    public static final String PROP_ORIG_SDL_SEG_CONF = "orig_sdl_seg_conf";
    public static final String PROP_SDL_ORIGIN_SYSTEM = "sdl_origin_system";
    public static final String PROP_SDL_PERCENT = "sdl_percent";
    public static final String PROP_SDL_TEXT_MATCH = "sdl_text_match";
    private static final Pattern MID_REGEX = Pattern.compile("<sdl:seg.*id=\"(\\d*)\".*");

    public SdlXliffSkeletonWriter(Parameters params) {
        super(params);
    }

    public SdlXliffSkeletonWriter(Parameters params, XLIFFContent fmt, ITSContent itsCont, ITSStandoffManager itsStandoffManager, Map<String, GenericAnnotations> lqiStandoff, Map<String, GenericAnnotations> provStandoff, CharsetEncoder chsEnc) {
        super(params, fmt, itsCont, itsStandoffManager, lqiStandoff, provStandoff, chsEnc);
    }

    @Override
    public String processTextUnit(ITextUnit resource) {
        LocaleId tl;
        if (!resource.getTargetLocales().isEmpty() && resource.hasTarget(tl = resource.getTargetLocales().iterator().next())) {
            if (this.getParams().getUseSegsForSdlProps()) {
                resource.setSkeleton(this.updateSdlSegUsingSeg(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
            } else {
                resource.setSkeleton(this.updateSdlSegUsingTc(resource.getTarget(tl), (GenericSkeleton)resource.getSkeleton()));
            }
        }
        return super.processTextUnit(resource);
    }

    private ISkeleton updateSdlSegUsingSeg(TextContainer target, GenericSkeleton skeleton) {
        ISegments segs = target.getSegments();
        for (Segment seg : segs) {
            Property propLocked = seg.getProperty(PROP_SDL_LOCKED);
            Property propConf = seg.getProperty(PROP_SDL_CONF);
            Property propOrigin = seg.getProperty(PROP_SDL_ORIGIN);
            if (propLocked == null && propConf == null && propOrigin == null) continue;
            String lockedMarker = SDL_SEG_LOCKED_STARTMARKER + seg.getId() + SDL_SEG_PROP_ENDMARKER;
            String confMarker = SDL_SEG_CONF_STARTMARKER + seg.getId() + SDL_SEG_PROP_ENDMARKER;
            String originMarker = SDL_SEG_ORIGIN_STARTMARKER + seg.getId() + SDL_SEG_PROP_ENDMARKER;
            for (GenericSkeletonPart p : skeleton.getParts()) {
                String d = p.getData().toString();
                if (propLocked != null) {
                    d = d.replace(lockedMarker, propLocked.getValue() != null ? propLocked.getValue() : SdlXliffConfLevel.UNSPECIFIED.getConfValue());
                }
                if (propConf != null) {
                    d = d.replace(confMarker, propConf.getValue() != null ? propConf.getValue() : SdlXliffConfLevel.UNSPECIFIED.getConfValue());
                }
                if (propOrigin != null) {
                    d = d.replace(originMarker, propOrigin.getValue() != null ? propOrigin.getValue() : SdlXliffConfLevel.UNSPECIFIED.getConfValue());
                }
                p.setData(d);
            }
        }
        return skeleton;
    }

    private ISkeleton updateSdlSegUsingTc(TextContainer target, GenericSkeleton skeleton) {
        for (GenericSkeletonPart p : skeleton.getParts()) {
            String d;
            Property o;
            block12: {
                Property l = target.getProperty(PROP_SDL_LOCKED);
                Property c = target.getProperty(PROP_SDL_CONF);
                o = target.getProperty(PROP_SDL_ORIGIN);
                if (l == null && c == null && o == null) {
                    return skeleton;
                }
                d = p.getData().toString();
                if (l != null) {
                    d = d.replace(SDL_SEG_LOCKED_MARKER, Util.isEmpty(this.getParams().getSdlSegLockedValue()) ? l.getValue() : this.getParams().getSdlSegLockedValue());
                }
                if (c != null) {
                    if (!target.hasProperty("state") || !SdlXliffConfLevel.isValidStateValue(target.getProperty("state").getValue())) {
                        d = target.hasProperty(PROP_ORIG_SDL_SEG_CONF) && target.getProperty(PROP_ORIG_SDL_SEG_CONF).getValue() != null ? d.replace(SDL_SEG_CONF_MARKER, target.getProperty(PROP_ORIG_SDL_SEG_CONF).getValue()) : d.replace(SDL_SEG_CONF_MARKER, Util.isEmpty(this.getParams().getSdlSegConfValue()) ? c.getValue() : this.getParams().getSdlSegConfValue());
                    } else {
                        Matcher midRegexMatcher = MID_REGEX.matcher(d);
                        String id = midRegexMatcher.find() ? midRegexMatcher.group(1) : null;
                        Optional<TextPart> maybeSdlSeg = target.getParts().stream().filter(part -> part.id != null && part.id.equals(id)).findFirst();
                        if (maybeSdlSeg.isPresent() && maybeSdlSeg.get().getProperty(PROP_SDL_CONF) != null) {
                            try {
                                SdlXliffConfLevel confLevelFromSdlSeg = SdlXliffConfLevel.fromConfValue(maybeSdlSeg.get().getProperty(PROP_SDL_CONF).getValue());
                                SdlXliffConfLevel confLevelFromState = SdlXliffConfLevel.fromStateValue(target.getProperty("state").getValue());
                                if (confLevelFromSdlSeg.compareTo(confLevelFromState) > 0) {
                                    d = d.replace(SDL_SEG_CONF_MARKER, confLevelFromSdlSeg.getConfValue());
                                    break block12;
                                }
                                d = d.replace(SDL_SEG_CONF_MARKER, confLevelFromState.getConfValue());
                            }
                            catch (IllegalArgumentException e) {
                                this.logger.debug("Invalid sdl:conf value. Using state value from text container.", (Throwable)e);
                                SdlXliffConfLevel confLevel = SdlXliffConfLevel.fromStateValue(target.getProperty("state").getValue());
                                d = d.replace(SDL_SEG_CONF_MARKER, confLevel.getConfValue());
                            }
                        } else {
                            SdlXliffConfLevel confLevel = SdlXliffConfLevel.fromStateValue(target.getProperty("state").getValue());
                            d = d.replace(SDL_SEG_CONF_MARKER, confLevel.getConfValue());
                        }
                    }
                }
            }
            if (o != null) {
                d = d.replace(SDL_SEG_ORIGIN_MARKER, Util.isEmpty(this.getParams().getSdlSegOriginValue()) ? o.getValue() : this.getParams().getSdlSegOriginValue());
            }
            p.setData(d);
        }
        return skeleton;
    }
}

