/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xini;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xini.GroupType;
import net.sf.okapi.filters.xini.InlineCodeTransformer;
import net.sf.okapi.filters.xini.XINIProperties;
import net.sf.okapi.filters.xini.jaxb.Element;
import net.sf.okapi.filters.xini.jaxb.ElementType;
import net.sf.okapi.filters.xini.jaxb.Field;
import net.sf.okapi.filters.xini.jaxb.Fields;
import net.sf.okapi.filters.xini.jaxb.INITD;
import net.sf.okapi.filters.xini.jaxb.INITR;
import net.sf.okapi.filters.xini.jaxb.INITable;
import net.sf.okapi.filters.xini.jaxb.Main;
import net.sf.okapi.filters.xini.jaxb.ObjectFactory;
import net.sf.okapi.filters.xini.jaxb.Page;
import net.sf.okapi.filters.xini.jaxb.Seg;
import net.sf.okapi.filters.xini.jaxb.TD;
import net.sf.okapi.filters.xini.jaxb.TR;
import net.sf.okapi.filters.xini.jaxb.Table;
import net.sf.okapi.filters.xini.jaxb.TargetLanguages;
import net.sf.okapi.filters.xini.jaxb.TextContent;
import net.sf.okapi.filters.xini.jaxb.Xini;

public class XINIWriter
implements IFilterWriter {
    private EncoderManager encodingManager;
    private IParameters params;
    private ObjectFactory objectFactory = new ObjectFactory();
    private String outputPath;
    private InlineCodeTransformer transformer = new InlineCodeTransformer();
    private Xini xini;
    private Page currentPage;
    private Element currentElement;
    private Fields currentFields;
    private Field currentField;
    private Table currentTable;
    private TR currentTr;
    private TD currentTd;
    private INITable currentIniTable;
    private INITR currentIniTr;
    private INITD currentIniTd;
    private int currentSegmentId;
    private OutputStream outputStream;

    public XINIWriter() {
    }

    public XINIWriter(IParameters params) {
        this();
        this.params = params;
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
    }

    @Override
    public String getName() {
        return "XINIWriter";
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_GROUP: 
            case START_SUBFILTER: {
                this.processStartGroup((StartGroup)event.getResource());
                break;
            }
            case TEXT_UNIT: 
            case END_SUBFILTER: {
                this.processTextUnit(event.getTextUnit());
                break;
            }
        }
        return event;
    }

    private void processStartGroup(StartGroup startGroup) {
        String type = startGroup.getType();
        GroupType gt = GroupType.fromValue(type);
        this.currentSegmentId = 0;
        switch (gt) {
            case PAGE: {
                Page newPage = this.objectFactory.createPage();
                Property pageIdProperty = startGroup.getProperty(XINIProperties.PAGE_ID.value());
                Property contextInformationUrlProperty = startGroup.getProperty(XINIProperties.CONTEXT_INFORMATION_URL.value());
                int pageId = Integer.valueOf(pageIdProperty.getValue());
                String contextInformationUrl = contextInformationUrlProperty.getValue();
                newPage.setPageID(pageId);
                newPage.setPageName(startGroup.getName());
                newPage.setContextInformationURL(contextInformationUrl);
                this.xini.getMain().getPage().add(newPage);
                this.currentPage = newPage;
                break;
            }
            case ELEMENT: {
                if (this.currentPage.getElements() == null) {
                    this.currentPage.setElements(new Page.Elements());
                }
                Element newElement = this.objectFactory.createElement();
                this.addGroupPropertiesToElement(newElement, startGroup);
                this.currentPage.getElements().getElement().add(newElement);
                this.currentElement = newElement;
                break;
            }
            case FIELDS: {
                this.currentElement.setElementContent(new Element.ElementContent());
                Fields newFields = this.objectFactory.createFields();
                this.currentElement.getElementContent().setFields(newFields);
                this.currentFields = newFields;
                break;
            }
            case FIELD: {
                Field newField = this.objectFactory.createField();
                this.addGroupPropertiesToField(newField, startGroup);
                this.currentFields.getField().add(newField);
                this.currentField = newField;
                this.currentIniTd = null;
                this.currentTd = null;
                break;
            }
            case TABLE: {
                this.currentElement.setElementContent(new Element.ElementContent());
                Table newTable = this.objectFactory.createTable();
                this.currentElement.getElementContent().setTable(newTable);
                this.currentTable = newTable;
                break;
            }
            case TR: {
                TR newTr = this.objectFactory.createTR();
                this.currentTable.getTR().add(newTr);
                this.currentTr = newTr;
                break;
            }
            case TD: {
                TD newTd = this.objectFactory.createTD();
                this.addGroupPropertiesToTD(newTd, startGroup);
                this.currentTr.getTD().add(newTd);
                this.currentTd = newTd;
                this.currentField = null;
                this.currentIniTd = null;
                break;
            }
            case INITABLE: {
                this.currentElement.setElementContent(new Element.ElementContent());
                INITable newIniTable = this.objectFactory.createINITable();
                this.currentElement.getElementContent().setINITable(newIniTable);
                this.currentIniTable = newIniTable;
                break;
            }
            case INITR: {
                INITR newIniTr = this.objectFactory.createINITR();
                this.currentIniTable.getTR().add(newIniTr);
                this.currentIniTr = newIniTr;
                break;
            }
            case INITD: {
                INITD newIniTd = this.objectFactory.createINITD();
                this.addGroupPropertiesToINITD(newIniTd, startGroup);
                this.currentIniTr.getTD().add(newIniTd);
                this.currentIniTd = newIniTd;
                this.currentField = null;
                this.currentTd = null;
            }
        }
    }

    private void addGroupPropertiesToTD(TD newTd, StartGroup startGroup) {
        for (String propertyName : startGroup.getPropertyNames()) {
            XINIProperties propertyType = XINIProperties.fromValue(propertyName);
            if (propertyType == null) continue;
            String propertyValue = startGroup.getProperty(propertyName).getValue();
            switch (propertyType) {
                case TABLE_CUSTOMER_TEXT_ID: {
                    newTd.setCustomerTextID(propertyValue);
                    break;
                }
                case TABLE_EMPTY_SEGMENTS_FLAGS: {
                    newTd.setEmptySegmentsFlags(propertyValue);
                    break;
                }
                case TABLE_EXTERNAL_ID: {
                    newTd.setExternalID(propertyValue);
                    break;
                }
                case TABLE_LABEL: {
                    newTd.setLabel(propertyValue);
                    break;
                }
                case TABLE_NO_CONTENT: {
                    newTd.setNoContent(Boolean.valueOf(propertyValue));
                    break;
                }
            }
        }
    }

    private void addGroupPropertiesToINITD(INITD newIniTd, StartGroup startGroup) {
        for (String propertyName : startGroup.getPropertyNames()) {
            XINIProperties propertyType = XINIProperties.fromValue(propertyName);
            if (propertyType == null) continue;
            String propertyValue = startGroup.getProperty(propertyName).getValue();
            switch (propertyType) {
                case INITABLE_CUSTOMER_TEXT_ID: {
                    newIniTd.setCustomerTextID(propertyValue);
                    break;
                }
                case INITABLE_EMPTY_SEGMENTS_FLAGS: {
                    newIniTd.setEmptySegmentsFlags(propertyValue);
                    break;
                }
                case INITABLE_EXTERNAL_ID: {
                    newIniTd.setExternalID(propertyValue);
                    break;
                }
                case INITABLE_LABEL: {
                    newIniTd.setLabel(propertyValue);
                    break;
                }
                case INITABLE_NO_CONTENT: {
                    newIniTd.setNoContent(Boolean.valueOf(propertyValue));
                    break;
                }
            }
        }
    }

    private void addGroupPropertiesToField(Field newField, StartGroup startGroup) {
        for (String propertyName : startGroup.getPropertyNames()) {
            XINIProperties propertyType = XINIProperties.fromValue(propertyName);
            if (propertyType == null) continue;
            String propertyValue = startGroup.getProperty(propertyName).getValue();
            switch (propertyType) {
                case FIELD_ID: {
                    newField.setFieldID(Integer.valueOf(propertyValue));
                    break;
                }
                case FIELD_CUSTOMER_TEXT_ID: {
                    newField.setCustomerTextID(propertyValue);
                    break;
                }
                case FIELD_EMPTY_SEGMENTS_FLAGS: {
                    newField.setEmptySegmentsFlags(propertyValue);
                    break;
                }
                case FIELD_EXTERNAL_ID: {
                    newField.setExternalID(propertyValue);
                    break;
                }
                case FIELD_LABEL: {
                    newField.setLabel(propertyValue);
                    break;
                }
                case FIELD_RAW_SOURCE_BEFORE_FIELD: {
                    newField.setRawSourceBeforeField(propertyValue);
                    break;
                }
                case FIELD_RAW_SOURCE_AFTER_FIELD: {
                    newField.setRawSourceAfterField(propertyValue);
                    break;
                }
                case FIELD_NO_CONTENT: {
                    newField.setNoContent(Boolean.valueOf(propertyValue));
                    break;
                }
            }
        }
    }

    private void addGroupPropertiesToElement(Element newElement, StartGroup startGroup) {
        for (String propertyName : startGroup.getPropertyNames()) {
            XINIProperties propertyType = XINIProperties.fromValue(propertyName);
            if (propertyType == null) continue;
            String propertyValue = startGroup.getProperty(propertyName).getValue();
            switch (propertyType) {
                case ELEMENT_ID: {
                    newElement.setElementID(Integer.valueOf(propertyValue));
                    break;
                }
                case ELEMENT_CUSTOMER_TEXT_ID: {
                    newElement.setCustomerTextID(propertyValue);
                    break;
                }
                case ELEMENT_SIZE: {
                    newElement.setSize(Integer.valueOf(propertyValue));
                    break;
                }
                case ELEMENT_ALPHA_LIST: {
                    newElement.setAlphaList(Boolean.valueOf(propertyValue));
                    break;
                }
                case ELEMENT_ELEMENT_TYPE: {
                    newElement.setElementType(ElementType.fromValue(propertyValue));
                    break;
                }
                case ELEMENT_RAW_SOURCE_BEFORE_ELEMENT: {
                    newElement.setRawSourceBeforeElement(propertyValue);
                    break;
                }
                case ELEMENT_RAW_SOURCE_AFTER_ELEMENT: {
                    newElement.setRawSourceAfterElement(propertyValue);
                    break;
                }
                case ELEMENT_LABEL: {
                    newElement.setLabel(propertyValue);
                    break;
                }
                case ELEMENT_STYLE: {
                    newElement.setStyle(propertyValue);
                    break;
                }
            }
        }
    }

    private void processTextUnit(ITextUnit tu) {
        List<TextContent> segList = null;
        if (this.currentField != null) {
            segList = this.currentField.getSegAndTrans();
        } else if (this.currentTd != null) {
            segList = this.currentTd.getSegAndTrans();
        } else if (this.currentIniTd != null) {
            segList = this.currentIniTd.getSegAndTrans();
        }
        Property segIdProperty = tu.getProperty(XINIProperties.SEGMENT_ID.value());
        Integer originalSegmentId = Integer.valueOf(segIdProperty.getValue());
        if (this.params.getBoolean("useOkapiSegmentation")) {
            segList.addAll(this.createXINISegments(tu, originalSegmentId));
        } else {
            Property emptyTranslationPropertiy = tu.getProperty(XINIProperties.EMPTY_TRANSLATION.value());
            boolean emptyTranslation = emptyTranslationPropertiy != null && emptyTranslationPropertiy.getBoolean();
            segList.add(this.createSingleXINISegment(tu, originalSegmentId, emptyTranslation));
        }
    }

    private TextContent createSingleXINISegment(ITextUnit tu, Integer originalSegmentId, boolean emptyTranslation) {
        Seg xiniSegment = this.objectFactory.createSeg();
        if (emptyTranslation) {
            xiniSegment.setEmptyTranslation(emptyTranslation);
        }
        xiniSegment.setSegID(originalSegmentId);
        TextContainer textContainer = tu.getSource();
        for (TextPart part : textContainer) {
            if (part.isSegment()) {
                Segment okapiSegment = (Segment)part;
                TextFragment textFragment = okapiSegment.getContent();
                this.addSegmentContentToXiniSeg(xiniSegment, textFragment);
                continue;
            }
            String whitespaceContent = part.getContent().getText();
            xiniSegment.getContent().add((Serializable)((Object)whitespaceContent));
        }
        return xiniSegment;
    }

    private List<TextContent> createXINISegments(ITextUnit tu, Integer originalSegmentId) {
        ArrayList<TextContent> newSegments = new ArrayList<TextContent>();
        Seg xiniSegment = null;
        String whitespaces = null;
        TextContainer textContainer = tu.getSource();
        this.undoSegmentationIfCodeEndsInOtherSegment(textContainer);
        for (TextPart part : textContainer) {
            if (part.isSegment()) {
                Segment okapiSegment = (Segment)part;
                TextFragment textFragment = okapiSegment.getContent();
                xiniSegment = this.objectFactory.createSeg();
                xiniSegment.setSegID(this.currentSegmentId);
                xiniSegment.setSegmentIDBeforeSegmentation(originalSegmentId);
                Property segEmptyTranslationProperty = tu.getProperty(XINIProperties.EMPTY_TRANSLATION.value());
                if (segEmptyTranslationProperty != null) {
                    Boolean emptyTranslation = Boolean.valueOf(segEmptyTranslationProperty.getValue());
                    xiniSegment.setEmptyTranslation(emptyTranslation);
                }
                this.addSegmentContentToXiniSeg(xiniSegment, textFragment);
                if (whitespaces != null && xiniSegment != null) {
                    xiniSegment.setLeadingSpacer(whitespaces);
                    whitespaces = null;
                }
                newSegments.add(xiniSegment);
                ++this.currentSegmentId;
                continue;
            }
            String whitespacePart = part.getContent().getText();
            if (xiniSegment == null) {
                whitespaces = whitespacePart;
                continue;
            }
            xiniSegment.setTrailingSpacer(whitespacePart);
        }
        return newSegments;
    }

    private void addSegmentContentToXiniSeg(Seg xiniSegment, TextFragment textFragment) {
        List<Code> codes = textFragment.getCodes();
        ArrayList<Object> newSerializedContent = new ArrayList<Object>();
        if (codes.size() > 0) {
            newSerializedContent.addAll(this.transformer.codesToJAXBForFilter(textFragment.getCodedText(), codes));
        } else {
            newSerializedContent.add(textFragment.getText());
        }
        Serializable lastElementInSeg = null;
        if (xiniSegment.getContent().size() > 0) {
            lastElementInSeg = xiniSegment.getContent().get(xiniSegment.getContent().size() - 1);
        }
        for (Object newPart : newSerializedContent) {
            if (newPart instanceof String && lastElementInSeg != null && lastElementInSeg instanceof String) {
                newPart = (String)((Object)lastElementInSeg) + (Serializable)newPart;
                xiniSegment.getContent().remove(lastElementInSeg);
            }
            xiniSegment.getContent().add((Serializable)newPart);
            lastElementInSeg = newPart;
        }
    }

    private void undoSegmentationIfCodeEndsInOtherSegment(TextContainer textContainer) {
        this.undoSegmentationIfCodeEndsInOtherSegment(textContainer, 0);
    }

    private void undoSegmentationIfCodeEndsInOtherSegment(TextContainer textContainer, int textPartStartIndex) {
        for (int textPartIndex = textPartStartIndex; textPartIndex < textContainer.count(); ++textPartIndex) {
            int mergeTo = textPartIndex;
            TextPart part = textContainer.get(textPartIndex);
            TextFragment textFragment = part.getContent();
            List<Code> codes = textFragment.getCodes();
            block1: for (int i = 0; i < codes.size(); ++i) {
                int codeId;
                Code code = codes.get(i);
                if (code.getTagType() != TextFragment.TagType.OPENING || this.isClosingCodeInTextPart(part, codeId = code.getId(), i)) continue;
                if (textPartIndex + 1 >= textContainer.count()) break;
                for (int j = textPartIndex + 1; j < textContainer.count(); ++j) {
                    TextPart followingTp = textContainer.get(j);
                    if (!this.isClosingCodeInTextPart(followingTp, codeId, 0)) continue;
                    if (j <= mergeTo) continue block1;
                    mergeTo = j;
                    continue block1;
                }
            }
            if (mergeTo <= textPartIndex) continue;
            this.joinTextContainerWithNextParts(textContainer, textPartIndex, mergeTo - textPartIndex);
            this.undoSegmentationIfCodeEndsInOtherSegment(textContainer, textPartIndex);
            return;
        }
    }

    private void joinTextContainerWithNextParts(TextContainer tc, int partIndex, int partCount) {
        if (tc.count() == 1) {
            return;
        }
        TextFragment tf = tc.get(partIndex).getContent();
        int max = tc.count() - partIndex - 1;
        if (partCount == -1 || partCount > max) {
            partCount = max;
        }
        for (int i = 0; i < partCount; ++i) {
            tf.insert(-1, tc.get(partIndex + 1).getContent(), true);
            tc.remove(partIndex + 1);
        }
    }

    private boolean isClosingCodeInTextPart(TextPart tp, int openingCodeId, int codePosition) {
        TextFragment tf = tp.getContent();
        if (tf.hasCode()) {
            List<Code> codeList = tf.getCodes().subList(codePosition, tf.getCodes().size());
            for (Code code : codeList) {
                if (!code.getTagType().equals((Object)TextFragment.TagType.CLOSING) || code.getId() != openingCodeId) continue;
                return true;
            }
        }
        return false;
    }

    private void processStartDocument(StartDocument startDoc) {
        this.xini = this.objectFactory.createXini();
        this.addStartDocumentPropertiesToXini(this.xini, startDoc);
        this.xini.setSchemaVersion("1.0");
        Main main = this.objectFactory.createMain();
        this.xini.setMain(main);
    }

    private void addStartDocumentPropertiesToXini(Xini xini, StartDocument startDoc) {
        for (String propertyName : startDoc.getPropertyNames()) {
            XINIProperties propertyType = XINIProperties.fromValue(propertyName);
            if (propertyType == null) continue;
            String propertyValue = startDoc.getProperty(propertyName).getValue();
            switch (propertyType) {
                case SOURCE_LANGUAGE: {
                    xini.setSourceLanguage(propertyValue);
                    break;
                }
                case TARGET_LANGUAGES: {
                    TargetLanguages targetLanguages = this.objectFactory.createTargetLanguages();
                    String[] languages = propertyValue.split(",");
                    for (int i = 0; i < languages.length; ++i) {
                        targetLanguages.getLanguage().add(languages[i]);
                    }
                    xini.setTargetLanguages(targetLanguages);
                    break;
                }
            }
        }
    }

    private void processEndDocument() {
        OutputStream os = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
            Marshaller m = jc.createMarshaller();
            m.setProperty("jaxb.noNamespaceSchemaLocation", (Object)"http://www.ontram.com/xsd/xini.xsd");
            if (this.outputPath != null) {
                os = new FileOutputStream(this.outputPath);
            } else if (this.outputStream != null) {
                os = new BufferedOutputStream(this.outputStream);
            } else {
                throw new OkapiBadFilterParametersException("Output path or stream must be set");
            }
            m.marshal((Object)this.xini, os);
        }
        catch (JAXBException | FileNotFoundException e) {
            throw new OkapiException(e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new OkapiException(e);
                }
            }
        }
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = params;
    }

    @Override
    public EncoderManager getEncoderManager() {
        return this.encodingManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }

    protected Xini getXini() {
        return this.xini;
    }
}

