/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.table.tsv;

import java.util.List;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.TextProcessingResult;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.filters.table.base.BaseTableFilter;
import net.sf.okapi.filters.table.tsv.Parameters;

public class TabSeparatedValuesFilter
extends BaseTableFilter {
    public static final String FILTER_NAME = "okf_table_tsv";
    public static final String FILTER_CONFIG = "okf_table_tsv";

    public TabSeparatedValuesFilter() {
        this.setName("okf_table_tsv");
        this.addConfiguration(true, "okf_table_tsv", "Table (Tab-Separated Values)", "Columns, separated by one or more tabs.", "okf_table_tsv.fprm");
        this.setParameters(new Parameters());
    }

    @Override
    protected TextProcessingResult extractCells(List<ITextUnit> cells, TextContainer lineContainer, long lineNum) {
        if (cells == null) {
            return TextProcessingResult.REJECTED;
        }
        if (lineContainer == null) {
            return TextProcessingResult.REJECTED;
        }
        String line = lineContainer.getCodedText();
        if (Util.isEmpty(line)) {
            return TextProcessingResult.REJECTED;
        }
        int start = -1;
        int prevStart = -1;
        for (int i = 0; i < line.length(); ++i) {
            if (start > -1 && line.charAt(i) == '\t') {
                if (prevStart > -1) {
                    cells.add(TextUnitUtil.buildGenericTU(line.substring(prevStart, start)));
                }
                prevStart = start;
                start = -1;
                continue;
            }
            if (start != -1 || line.charAt(i) < ' ') continue;
            start = i;
        }
        if (start == -1) {
            start = line.length();
        }
        if (prevStart > -1 && start > -1) {
            cells.add(TextUnitUtil.buildGenericTU(line.substring(prevStart, start)));
        }
        if (start < line.length()) {
            cells.add(TextUnitUtil.buildGenericTU(line.substring(start, line.length())));
        }
        return TextProcessingResult.ACCEPTED;
    }
}

