/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.Collections;
import java.util.zip.ZipEntry;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Namespace;
import net.sf.okapi.filters.openxml.NonVisualIdentificationPropertyFragments;
import net.sf.okapi.filters.openxml.Placeholder;
import net.sf.okapi.filters.openxml.SlideFragments;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.StyledTextPart;

class SlidablePart
extends StyledTextPart {
    private static final String EMPTY = "";
    private final SlideFragments slideFragments;
    private final StyleDefinitions initialStyleDefinitions;
    private final StyleOptimisation.Bypass bypassStyleOptimisation;
    private String contentType;
    private boolean inShape;
    private boolean inNonVisualProperties;
    private boolean placeholderAvailable;
    private boolean inGraphicFrame;
    private String graphicFrameId;
    private int tableCellNumber;

    SlidablePart(Document.General generalDocument, ZipEntry entry, SlideFragments slideFragments) {
        super(generalDocument, entry, new StyleDefinitions.Empty(), new StyleOptimisation.Bypass());
        this.contentType = this.generalDocument.contentTypeFor(this.entry);
        this.slideFragments = slideFragments;
        this.initialStyleDefinitions = new StyleDefinitions.Empty();
        this.bypassStyleOptimisation = new StyleOptimisation.Bypass();
        this.graphicFrameId = EMPTY;
    }

    @Override
    protected void preProcess(XMLEvent e) throws IOException, XMLStreamException {
        String localPart;
        if (e.isStartElement()) {
            localPart = e.asStartElement().getName().getLocalPart();
            if ("sp".equals(localPart)) {
                this.inShape = true;
            }
            if (this.inShape && "cNvPr".equals(localPart)) {
                this.actualiseStyleDefinitionsAndStyleOptimisation(e.asStartElement());
            }
            if (this.inShape && "nvPr".equals(localPart)) {
                this.inNonVisualProperties = true;
            }
            if (this.inNonVisualProperties && "ph".equals(localPart)) {
                this.placeholderAvailable = true;
                this.actualiseStyleDefinitionsAndStyleOptimisation(e.asStartElement());
            }
            if ("graphicFrame".equals(localPart)) {
                this.inGraphicFrame = true;
            }
            if (this.inGraphicFrame && "cNvPr".equals(localPart)) {
                this.graphicFrameId = new NonVisualIdentificationPropertyFragments.Default(e.asStartElement()).id();
            }
            if (!this.graphicFrameId.isEmpty() && "tc".equals(localPart)) {
                ++this.tableCellNumber;
                this.actualiseStyleDefinitionsAndStyleOptimisation();
            }
        }
        if (e.isEndElement()) {
            localPart = e.asEndElement().getName().getLocalPart();
            if ("nvPr".equals(localPart)) {
                this.inNonVisualProperties = false;
            }
            if ("sp".equals(localPart)) {
                this.inShape = false;
                this.placeholderAvailable = false;
                this.resetStyleDefinitionsAndStyleOptimisation();
            }
            if ("graphicFrame".equals(localPart)) {
                this.inGraphicFrame = false;
                this.graphicFrameId = EMPTY;
                this.resetStyleDefinitionsAndStyleOptimisation();
            }
        }
    }

    private void actualiseStyleDefinitionsAndStyleOptimisation() throws IOException, XMLStreamException {
        this.styleDefinitions = this.slideFragments.listStyleFor(this.graphicFrameId, this.tableCellNumber);
        this.styleOptimisation = this.styleOptimisationFor(this.entry, this.styleDefinitions);
    }

    private void actualiseStyleDefinitionsAndStyleOptimisation(StartElement startElement) throws IOException, XMLStreamException {
        if (!this.placeholderAvailable) {
            NonVisualIdentificationPropertyFragments.Default nvipf = new NonVisualIdentificationPropertyFragments.Default(startElement);
            this.styleDefinitions = this.slideFragments.listStyleFor(nvipf.id());
        } else {
            this.styleDefinitions = this.slideFragments.listStyleFor(new Placeholder.Default(startElement));
        }
        this.styleOptimisation = this.styleOptimisationFor(this.entry, this.styleDefinitions);
    }

    private StyleOptimisation styleOptimisationFor(ZipEntry entry, StyleDefinitions styleDefinitions) throws IOException, XMLStreamException {
        Namespace namespace = this.generalDocument.namespacesOf(entry).forPrefix("a");
        if (null == namespace) {
            return this.bypassStyleOptimisation;
        }
        return new StyleOptimisation.Default(this.bypassStyleOptimisation, this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), new QName(namespace.uri(), "pPr", namespace.prefix()), new QName(namespace.uri(), "defRPr", namespace.prefix()), Collections.emptyList(), styleDefinitions);
    }

    private void resetStyleDefinitionsAndStyleOptimisation() {
        this.styleDefinitions = this.initialStyleDefinitions;
        this.styleOptimisation = this.bypassStyleOptimisation;
    }

    @Override
    protected boolean isCurrentBlockTranslatable() {
        return !"application/vnd.openxmlformats-officedocument.presentationml.slideMaster+xml".equals(this.contentType()) && !"application/vnd.openxmlformats-officedocument.presentationml.slideLayout+xml".equals(this.contentType()) && !"application/vnd.openxmlformats-officedocument.presentationml.notesMaster+xml".equals(this.contentType()) || !this.generalDocument.conditionalParameters().getIgnorePlaceholdersInPowerpointMasters() || !this.placeholderAvailable;
    }

    private String contentType() {
        if (null == this.contentType) {
            this.contentType = this.generalDocument.contentTypeFor(this.entry);
        }
        return this.contentType;
    }
}

