/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Arrays;
import java.util.LinkedList;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import net.sf.okapi.filters.openxml.CellFormat;
import net.sf.okapi.filters.openxml.DifferentialFormat;
import net.sf.okapi.filters.openxml.ExcelStyleDefinition;
import net.sf.okapi.filters.openxml.ExcelStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.ParagraphBlockProperties;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleDefinitionsReader;

final class ExcelStyleDefinitions
implements StyleDefinitions {
    static final String STYLESHEET = "styleSheet";
    private StartDocument startDocument;
    private StartElement startElement;
    private ExcelStyleDefinition.NumberFormats numberFormats;
    private ExcelStyleDefinition.Fonts fonts;
    private ExcelStyleDefinition.Fills fills;
    private ExcelStyleDefinition.Borders borders;
    private ExcelStyleDefinition.CellStyleFormats cellStyleFormats;
    private ExcelStyleDefinition.CellFormats cellFormats;
    private ExcelStyleDefinition.CellStyles cellStyles;
    private ExcelStyleDefinition.DifferentialFormats differentialFormats;
    private ExcelStyleDefinition.TableStyles tableStyles;
    private ExcelStyleDefinition.Colors colors;
    private ExcelStyleDefinition.Extensions extensions;
    private EndElement endElement;
    private EndDocument endDocument;

    ExcelStyleDefinitions() {
    }

    @Override
    public void readWith(StyleDefinitionsReader reader) throws XMLStreamException {
        ExcelStyleDefinitionsReader styleDefinitionsReader = (ExcelStyleDefinitionsReader)reader;
        this.startDocument = styleDefinitionsReader.startDocument();
        this.startElement = styleDefinitionsReader.startElement();
        this.numberFormats = styleDefinitionsReader.numberFormats();
        this.fonts = styleDefinitionsReader.fonts();
        this.fills = styleDefinitionsReader.fills();
        this.borders = styleDefinitionsReader.borders();
        this.cellStyleFormats = styleDefinitionsReader.cellStyleFormats();
        this.cellFormats = styleDefinitionsReader.cellFormats();
        this.cellStyles = styleDefinitionsReader.cellStyles();
        this.differentialFormats = styleDefinitionsReader.differentialFormats();
        this.tableStyles = styleDefinitionsReader.tableStyles();
        this.colors = styleDefinitionsReader.colors();
        this.extensions = styleDefinitionsReader.extensions();
        this.endElement = styleDefinitionsReader.endElement();
        this.endDocument = styleDefinitionsReader.endDocument();
    }

    @Override
    public void place(String parentId, ParagraphBlockProperties paragraphBlockProperties, RunProperties runProperties) {
    }

    @Override
    public String placedId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ParagraphBlockProperties combinedParagraphBlockProperties(ParagraphBlockProperties paragraphBlockProperties) {
        return null;
    }

    @Override
    public RunProperties combinedRunProperties(String paragraphStyle, String runStyle, RunProperties runProperties) {
        return null;
    }

    @Override
    public DifferentialFormat.Combined combinedDifferentialFormatFor(int cellFormatIndex) {
        CellFormat format = this.cellFormats.referencedBy(cellFormatIndex);
        return new DifferentialFormat.Combined(this.numberFormats.referencedBy(format.numberFormatId()), this.fonts.referencedBy(format.fontId()), this.fills.referencedBy(format.fillId()), format.alignment(), format.protection());
    }

    @Override
    public StyleDefinitions mergedWith(StyleDefinitions other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Markup asMarkup() {
        Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
        markup.addComponent(new MarkupComponent.General(Arrays.asList(this.startDocument, this.startElement)));
        markup.addMarkup(this.numberFormats.asMarkup());
        markup.addMarkup(this.fonts.asMarkup());
        markup.addMarkup(this.fills.asMarkup());
        markup.addMarkup(this.borders.asMarkup());
        markup.addMarkup(this.cellStyleFormats.asMarkup());
        markup.addMarkup(this.cellFormats.asMarkup());
        markup.addMarkup(this.cellStyles.asMarkup());
        markup.addMarkup(this.differentialFormats.asMarkup());
        markup.addMarkup(this.tableStyles.asMarkup());
        markup.addMarkup(this.colors.asMarkup());
        markup.addMarkup(this.extensions.asMarkup());
        markup.addComponent(new MarkupComponent.General(Arrays.asList(this.endElement, this.endDocument)));
        return markup;
    }
}

