/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.filters.openxml.BlockProperty;
import net.sf.okapi.filters.openxml.ClarificationContext;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunPropertyFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;

interface ElementsClarification {
    public void performFor(List<Property> var1);

    public static final class RunPropertyLang
    implements ElementsClarification {
        private final RunPropertyDefault runPropertyDefault;
        private final String elementName;
        private final String attributeName;

        RunPropertyLang(RunPropertyDefault runPropertyDefault, String elementName, String attributeName) {
            this.runPropertyDefault = runPropertyDefault;
            this.elementName = elementName;
            this.attributeName = attributeName;
        }

        @Override
        public void performFor(List<Property> properties) {
            this.runPropertyDefault.performFor(properties);
            if (this.runPropertyDefault.clarificationContext.sourceLtr() && this.runPropertyDefault.clarificationContext.targetLtr() || this.runPropertyDefault.clarificationContext.sourceRtl() && this.runPropertyDefault.clarificationContext.targetRtl()) {
                return;
            }
            if (this.runPropertyDefault.clarificationContext.targetHasCharactersAsNumeralSeparators()) {
                properties.add(RunPropertyFactory.createRunProperty(this.runPropertyDefault.clarificationContext.creationalParameters(), this.elementName, Collections.singletonMap(this.attributeName, this.runPropertyDefault.clarificationContext.targetLocale().toString())));
            }
        }
    }

    public static final class RunPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;
        private final String defaultValue;
        private final String defaultValueWhenAbsent;
        private final Set<String> falseValues;
        private final Set<String> trueValues;

        RunPropertyDefault(ClarificationContext clarificationContext, String elementName, String defaultValue, String defaultValueWhenAbsent, Set<String> falseValues, Set<String> trueValues) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
            this.defaultValue = defaultValue;
            this.defaultValueWhenAbsent = defaultValueWhenAbsent;
            this.falseValues = falseValues;
            this.trueValues = trueValues;
        }

        @Override
        public void performFor(List<Property> properties) {
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl()) {
                return;
            }
            String combinedValue = this.clarificationContext.combinedRunProperties().properties().stream().filter(p -> p.getName().getLocalPart().equals(this.elementName)).map(p -> {
                String value = p.value();
                return null == value ? this.defaultValue : value;
            }).findFirst().orElse(this.defaultValueWhenAbsent);
            if (this.falseValues.contains(combinedValue)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    this.adjustPropertyValueToTrue(properties);
                }
            } else if (this.trueValues.contains(combinedValue) && this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                this.adjustPropertyValueToFalse(properties);
            }
        }

        private void adjustPropertyValueToFalse(List<Property> properties) {
            Iterator<Property> iterator = properties.iterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.remove();
                return;
            }
            properties.add(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values((String)this.falseValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("False values are empty")))));
        }

        void adjustPropertyValueToTrue(List<Property> properties) {
            String trueValue = (String)this.trueValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.set(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values(trueValue)));
                return;
            }
            properties.add(RunPropertyFactory.createRunProperty(this.clarificationContext.creationalParameters(), this.elementName, this.values(trueValue)));
        }

        private Map<String, String> values(String trueValue) {
            Map<String, String> values = this.defaultValue.contains(trueValue) ? Collections.emptyMap() : Collections.singletonMap("val", trueValue);
            return values;
        }
    }

    public static final class ParagraphBlockPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;
        private final String defaultValue;
        private final String defaultValueWhenAbsent;
        private final Set<String> falseValues;
        private final Set<String> trueValues;

        ParagraphBlockPropertyDefault(ClarificationContext clarificationContext, String elementName, String defaultValue, String defaultValueWhenAbsent, Set<String> falseValues, Set<String> trueValues) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
            this.defaultValue = defaultValue;
            this.defaultValueWhenAbsent = defaultValueWhenAbsent;
            this.falseValues = falseValues;
            this.trueValues = trueValues;
        }

        @Override
        public void performFor(List<Property> properties) {
            if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetLtr() || this.clarificationContext.sourceRtl() && this.clarificationContext.targetRtl()) {
                return;
            }
            String combinedValue = this.clarificationContext.combinedParagraphProperties().properties().stream().filter(p -> p.getName().getLocalPart().equals(this.elementName)).map(p -> {
                String value = p.value();
                return null == value ? this.defaultValue : value;
            }).findFirst().orElse(this.defaultValueWhenAbsent);
            if (this.falseValues.contains(combinedValue)) {
                if (this.clarificationContext.sourceLtr() && this.clarificationContext.targetRtl()) {
                    this.adjustPropertyValueToTrue(properties);
                }
            } else if (this.trueValues.contains(combinedValue) && this.clarificationContext.sourceRtl() && this.clarificationContext.targetLtr()) {
                this.adjustPropertyValueToFalse(properties);
            }
        }

        private void adjustPropertyValueToFalse(List<Property> properties) {
            Iterator<Property> iterator = properties.iterator();
            while (iterator.hasNext()) {
                Property property = iterator.next();
                if (!this.elementName.equals(property.getName().getLocalPart())) continue;
                iterator.remove();
                return;
            }
            String falseValue = (String)this.falseValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            properties.add(new BlockProperty(this.elementName, this.values(falseValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
        }

        void adjustPropertyValueToTrue(List<Property> properties) {
            String trueValue = (String)this.trueValues.stream().findFirst().orElseThrow(() -> new IllegalStateException("True values are empty"));
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property runProperty = iterator.next();
                if (!this.elementName.equals(runProperty.getName().getLocalPart())) continue;
                iterator.set(new BlockProperty(this.elementName, this.values(trueValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
                return;
            }
            properties.add(new BlockProperty(this.elementName, this.values(trueValue), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
        }

        private Map<String, String> values(String trueValue) {
            Map<String, String> values = this.defaultValue.contains(trueValue) ? Collections.emptyMap() : Collections.singletonMap("val", trueValue);
            return values;
        }
    }

    public static final class TableBlockPropertyDefault
    implements ElementsClarification {
        private final ClarificationContext clarificationContext;
        private final String elementName;

        TableBlockPropertyDefault(ClarificationContext clarificationContext, String elementName) {
            this.clarificationContext = clarificationContext;
            this.elementName = elementName;
        }

        @Override
        public void performFor(List<Property> properties) {
            ListIterator<Property> iterator = properties.listIterator();
            while (iterator.hasNext()) {
                Property blockProperty = iterator.next();
                if (!this.elementName.equals(blockProperty.getName().getLocalPart())) continue;
                if (!this.clarificationContext.targetRtl()) {
                    iterator.remove();
                    return;
                }
                return;
            }
            if (this.clarificationContext.targetRtl()) {
                iterator.add(new BlockProperty(this.elementName, Collections.emptyMap(), this.clarificationContext.creationalParameters(), this.clarificationContext.conditionalParameters(), new StrippableAttributes.DrawingRunProperties(this.clarificationContext.conditionalParameters(), this.clarificationContext.creationalParameters().getEventFactory())));
            }
        }
    }

    public static final class Bypass
    implements ElementsClarification {
        @Override
        public void performFor(List<Property> properties) {
        }
    }
}

