/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.fontmappings.DefaultFontMappings;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsInput;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsOutput;
import net.sf.okapi.filters.openxml.ParametersStringWorksheetConfigurationsInput;
import net.sf.okapi.filters.openxml.ParametersStringWorksheetConfigurationsOutput;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.WorksheetConfiguration;
import net.sf.okapi.filters.openxml.WorksheetConfigurations;

public class ConditionalParameters
extends StringParameters {
    static final String EMPTY_SUBFILTER_CONFIGURATION = "";
    private static final String MAX_ATTRIBUTE_SIZE = "maxAttributeSize";
    private static final String TRANSLATEDOCPROPERTIES = "bPreferenceTranslateDocProperties";
    private static final String TRANSLATECOMMENTS = "bPreferenceTranslateComments";
    private static final String AGGRESSIVECLEANUP = "bPreferenceAggressiveCleanup";
    private static final String AUTOMATICALLY_ACCEPT_REVISIONS = "bPreferenceAutomaticallyAcceptRevisions";
    private static final String TRANSLATEPOWERPOINTNOTES = "bPreferenceTranslatePowerpointNotes";
    private static final String TRANSLATEPOWERPOINTMASTERS = "bPreferenceTranslatePowerpointMasters";
    private static final String IGNOREPLACEHOLDERSINPOWERPOINTMASTERS = "bPreferenceIgnorePlaceholdersInPowerpointMasters";
    private static final String TRANSLATEWORDHEADERSFOOTERS = "bPreferenceTranslateWordHeadersFooters";
    private static final String TRANSLATE_WORD_HIDDEN = "bPreferenceTranslateWordHidden";
    private static final String TRANSLATEEXCELEXCLUDECOLORS = "bPreferenceTranslateExcelExcludeColors";
    private static final String TRANSLATEEXELEXCLUDECOLUMNS = "bPreferenceTranslateExcelExcludeColumns";
    private static final String TRANSLATEEXELSHEETNAMES = "bPreferenceTranslateExcelSheetNames";
    private static final String TRANSLATE_EXCEL_DIAGRAM_DATA = "bPreferenceTranslateExcelDiagramData";
    private static final String TRANSLATE_EXCEL_DRAWINGS = "bPreferenceTranslateExcelDrawings";
    private static final String TRANSLATE_POWERPOINT_HIDDEN = "bPreferenceTranslatePowerpointHidden";
    private static final String TRANSLATEWORDEXCLUDEGRAPHICMETADATA = "bPreferenceTranslateWordExcludeGraphicMetaData";
    private static final String TRANSLATE_EXCEL_HIDDEN = "bPreferenceTranslateExcelHidden";
    private static final String EXTRACT_EXTERNAL_HYPERLINKS = "bExtractExternalHyperlinks";
    private static final String TRANSLATE_WORD_EXCLUDE_STYLE_MODE = "bInExcludeMode";
    private static final String TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE = "bInExcludeHighlightMode";
    private static final String TRANSLATE_WORD_EXCLUDE_COLORS = "bPreferenceTranslateWordExcludeColors";
    private static final String ADDTABASCHARACTER = "bPreferenceAddTabAsCharacter";
    private static final String ADDLINESEPARATORASCHARACTER = "bPreferenceAddLineSeparatorAsCharacter";
    private static final String LINESEPARATORREPLACEMENT = "sPreferenceLineSeparatorReplacement";
    private static final String REPLACE_NO_BREAK_HYPHEN_TAG = "bPreferenceReplaceNoBreakHyphenTag";
    private static final String IGNORE_SOFT_HYPHEN_TAG = "bPreferenceIgnoreSoftHyphenTag";
    private static final String POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY = "bPreferencePowerpointIncludedSlideNumbersOnly";
    private static final String REORDER_POWERPOINT_NOTES_AND_COMMENTS = "bReorderPowerpointNotesAndComments";
    private static final String ALLOW_EMPTY_TARGETS = "bPreferenceAllowEmptyTargets";
    private static final String SUBFILTER = "subfilter";
    public static final int MSWORD = 1;
    public TreeSet<String> tsComplexFieldDefinitionsToExtract;
    public TreeSet<String> tsExcelExcludedColors;
    public TreeSet<String> tsExcludeWordStyles;
    public TreeSet<String> tsWordHighlightColors;
    public TreeSet<String> tsWordExcludedColors;
    public TreeSet<Integer> tsPowerpointIncludedSlideNumbers;
    public ParseType nFileType = ParseType.MSWORD;
    private WorksheetConfigurations worksheetConfigurations;
    private FontMappings fontMappings;

    public int getMaxAttributeSize() {
        return this.getInteger(MAX_ATTRIBUTE_SIZE);
    }

    public void setMaxAttributeSize(int maxAttributeSize) {
        this.setInteger(MAX_ATTRIBUTE_SIZE, maxAttributeSize);
    }

    public boolean getTranslateDocProperties() {
        return this.getBoolean(TRANSLATEDOCPROPERTIES);
    }

    public void setTranslateDocProperties(boolean translateDocProperties) {
        this.setBoolean(TRANSLATEDOCPROPERTIES, translateDocProperties);
    }

    public boolean getTranslateComments() {
        return this.getBoolean(TRANSLATECOMMENTS);
    }

    public void setTranslateComments(boolean translateComments) {
        this.setBoolean(TRANSLATECOMMENTS, translateComments);
    }

    public boolean getCleanupAggressively() {
        return this.getBoolean(AGGRESSIVECLEANUP);
    }

    public void setCleanupAggressively(boolean aggressiveCleanup) {
        this.setBoolean(AGGRESSIVECLEANUP, aggressiveCleanup);
    }

    public boolean getAutomaticallyAcceptRevisions() {
        return this.getBoolean(AUTOMATICALLY_ACCEPT_REVISIONS);
    }

    public void setAutomaticallyAcceptRevisions(boolean automaticallyAcceptRevisions) {
        this.setBoolean(AUTOMATICALLY_ACCEPT_REVISIONS, automaticallyAcceptRevisions);
    }

    public boolean getTranslatePowerpointNotes() {
        return this.getBoolean(TRANSLATEPOWERPOINTNOTES);
    }

    public void setTranslatePowerpointNotes(boolean translatePowerpointNotes) {
        this.setBoolean(TRANSLATEPOWERPOINTNOTES, translatePowerpointNotes);
    }

    public boolean getTranslatePowerpointMasters() {
        return this.getBoolean(TRANSLATEPOWERPOINTMASTERS);
    }

    public void setTranslatePowerpointMasters(boolean translatePowerpointMasters) {
        this.setBoolean(TRANSLATEPOWERPOINTMASTERS, translatePowerpointMasters);
    }

    public void setIgnorePlaceholdersInPowerpointMasters(boolean ignorePlaceholdersInPowerpointMasters) {
        this.setBoolean(IGNOREPLACEHOLDERSINPOWERPOINTMASTERS, ignorePlaceholdersInPowerpointMasters);
    }

    public boolean getIgnorePlaceholdersInPowerpointMasters() {
        return this.getBoolean(IGNOREPLACEHOLDERSINPOWERPOINTMASTERS);
    }

    public boolean getTranslateWordHeadersFooters() {
        return this.getBoolean(TRANSLATEWORDHEADERSFOOTERS);
    }

    public void setTranslateWordHeadersFooters(boolean translateWordHeadersFooters) {
        this.setBoolean(TRANSLATEWORDHEADERSFOOTERS, translateWordHeadersFooters);
    }

    public boolean getTranslateWordHidden() {
        return this.getBoolean(TRANSLATE_WORD_HIDDEN);
    }

    public void setTranslateWordHidden(boolean translateWordHidden) {
        this.setBoolean(TRANSLATE_WORD_HIDDEN, translateWordHidden);
    }

    public boolean getTranslatePowerpointHidden() {
        return this.getBoolean(TRANSLATE_POWERPOINT_HIDDEN);
    }

    public void setTranslatePowerpointHidden(boolean translatePowerpointHidden) {
        this.setBoolean(TRANSLATE_POWERPOINT_HIDDEN, translatePowerpointHidden);
    }

    public boolean getTranslateExcelHidden() {
        return this.getBoolean(TRANSLATE_EXCEL_HIDDEN);
    }

    public void setTranslateExcelHidden(boolean translateExcelHidden) {
        this.setBoolean(TRANSLATE_EXCEL_HIDDEN, translateExcelHidden);
    }

    public boolean getTranslateExcelExcludeColors() {
        return this.getBoolean(TRANSLATEEXCELEXCLUDECOLORS);
    }

    public void setTranslateExcelExcludeColors(boolean translateExcelExcludeColors) {
        this.setBoolean(TRANSLATEEXCELEXCLUDECOLORS, translateExcelExcludeColors);
    }

    public boolean getTranslateExcelSheetNames() {
        return this.getBoolean(TRANSLATEEXELSHEETNAMES);
    }

    public void setTranslateExcelSheetNames(boolean translateExcelSheetNames) {
        this.setBoolean(TRANSLATEEXELSHEETNAMES, translateExcelSheetNames);
    }

    public boolean getTranslateExcelDiagramData() {
        return this.getBoolean(TRANSLATE_EXCEL_DIAGRAM_DATA);
    }

    public void setTranslateExcelDiagramData(boolean translateExcelDiagramData) {
        this.setBoolean(TRANSLATE_EXCEL_DIAGRAM_DATA, translateExcelDiagramData);
    }

    public boolean getTranslateExcelDrawings() {
        return this.getBoolean(TRANSLATE_EXCEL_DRAWINGS);
    }

    public void setTranslateExcelDrawings(boolean translateExcelDrawings) {
        this.setBoolean(TRANSLATE_EXCEL_DRAWINGS, translateExcelDrawings);
    }

    public boolean getTranslateWordExcludeGraphicMetaData() {
        return this.getBoolean(TRANSLATEWORDEXCLUDEGRAPHICMETADATA);
    }

    public void setTranslateWordExcludeGraphicMetaData(boolean excludeGraphicMetaData) {
        this.setBoolean(TRANSLATEWORDEXCLUDEGRAPHICMETADATA, excludeGraphicMetaData);
    }

    public boolean getAddTabAsCharacter() {
        return this.getBoolean(ADDTABASCHARACTER);
    }

    public void setAddTabAsCharacter(boolean bAddTabAsCharacter) {
        this.setBoolean(ADDTABASCHARACTER, bAddTabAsCharacter);
    }

    public boolean getAddLineSeparatorCharacter() {
        return this.getBoolean(ADDLINESEPARATORASCHARACTER);
    }

    public void setAddLineSeparatorCharacter(boolean bAddLineSeparatorAsCharacter) {
        this.setBoolean(ADDLINESEPARATORASCHARACTER, bAddLineSeparatorAsCharacter);
    }

    public char getLineSeparatorReplacement() {
        return this.getString(LINESEPARATORREPLACEMENT).charAt(0);
    }

    public void setLineSeparatorReplacement(char lineSeparatorReplacement) {
        this.setString(LINESEPARATORREPLACEMENT, String.valueOf(lineSeparatorReplacement));
    }

    public boolean getReplaceNoBreakHyphenTag() {
        return this.getBoolean(REPLACE_NO_BREAK_HYPHEN_TAG);
    }

    public void setReplaceNoBreakHyphenTag(boolean bReplaceNoBreakHyphenTag) {
        this.setBoolean(REPLACE_NO_BREAK_HYPHEN_TAG, bReplaceNoBreakHyphenTag);
    }

    public boolean getIgnoreSoftHyphenTag() {
        return this.getBoolean(IGNORE_SOFT_HYPHEN_TAG);
    }

    public void setIgnoreSoftHyphenTag(boolean bIgnoreSoftHyphenTag) {
        this.setBoolean(IGNORE_SOFT_HYPHEN_TAG, bIgnoreSoftHyphenTag);
    }

    public void setExtractExternalHyperlinks(boolean bExtractExternalHyperlinks) {
        this.setBoolean(EXTRACT_EXTERNAL_HYPERLINKS, bExtractExternalHyperlinks);
    }

    public boolean getExtractExternalHyperlinks() {
        return this.getBoolean(EXTRACT_EXTERNAL_HYPERLINKS);
    }

    public void setPowerpointIncludedSlideNumbersOnly(boolean bIncludedSlideNumbersOnly) {
        this.setBoolean(POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY, bIncludedSlideNumbersOnly);
    }

    public boolean getPowerpointIncludedSlideNumbersOnly() {
        return this.getBoolean(POWERPOINT_INCLUDED_SLIDE_NUMBERS_ONLY);
    }

    public boolean getTranslateWordInExcludeStyleMode() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_STYLE_MODE);
    }

    public void setTranslateWordInExcludeStyleMode(boolean inExcludeMode) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_STYLE_MODE, inExcludeMode);
    }

    public boolean getTranslateWordInExcludeHighlightMode() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE);
    }

    public void setTranslateWordInExcludeHighlightMode(boolean inExcludeHighlightMode) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_HIGHLIGHT_MODE, inExcludeHighlightMode);
    }

    public boolean getTranslateWordExcludeColors() {
        return this.getBoolean(TRANSLATE_WORD_EXCLUDE_COLORS);
    }

    public void setTranslateWordExcludeColors(boolean translateWordExcludeColors) {
        this.setBoolean(TRANSLATE_WORD_EXCLUDE_COLORS, translateWordExcludeColors);
    }

    public boolean getReorderPowerpointNotesAndComments() {
        return this.getBoolean(REORDER_POWERPOINT_NOTES_AND_COMMENTS);
    }

    public void setReorderPowerpointNotesAndComments(boolean reorderPowerpointNotesAndComments) {
        this.setBoolean(REORDER_POWERPOINT_NOTES_AND_COMMENTS, reorderPowerpointNotesAndComments);
    }

    public boolean getAllowEmptyTargets() {
        return this.getBoolean(ALLOW_EMPTY_TARGETS);
    }

    public void setAllowEmptyTargets(boolean useSourceForEmptyTarget) {
        this.setBoolean(ALLOW_EMPTY_TARGETS, useSourceForEmptyTarget);
    }

    public String getSubfilter() {
        return this.getString(SUBFILTER);
    }

    public void setSubfilter(String subfilter) {
        this.setString(SUBFILTER, subfilter);
    }

    public WorksheetConfigurations worksheetConfigurations() {
        return this.worksheetConfigurations;
    }

    void worksheetConfigurations(WorksheetConfigurations worksheetConfigurations) {
        this.worksheetConfigurations = worksheetConfigurations;
    }

    public FontMappings fontMappings() {
        return this.fontMappings;
    }

    void fontMappings(FontMappings fontMappings) {
        this.fontMappings = fontMappings;
    }

    @Override
    public void reset() {
        this.worksheetConfigurations = new WorksheetConfigurations.Default(new LinkedList<WorksheetConfiguration>());
        this.fontMappings = new DefaultFontMappings(new LinkedList<FontMapping>());
        super.reset();
        this.setMaxAttributeSize(0x400000);
        this.setTranslateDocProperties(true);
        this.setTranslateComments(true);
        this.setTranslatePowerpointNotes(true);
        this.setTranslatePowerpointMasters(true);
        this.setIgnorePlaceholdersInPowerpointMasters(false);
        this.setTranslateWordHeadersFooters(true);
        this.setTranslateWordHidden(false);
        this.setTranslateWordExcludeGraphicMetaData(false);
        this.setTranslatePowerpointHidden(false);
        this.setTranslateExcelHidden(false);
        this.setTranslateExcelExcludeColors(false);
        this.setTranslateExcelSheetNames(false);
        this.setAddLineSeparatorCharacter(false);
        this.setLineSeparatorReplacement('\n');
        this.setReplaceNoBreakHyphenTag(false);
        this.setIgnoreSoftHyphenTag(false);
        this.setAddTabAsCharacter(false);
        this.setCleanupAggressively(false);
        this.setAutomaticallyAcceptRevisions(true);
        this.setPowerpointIncludedSlideNumbersOnly(false);
        this.setTranslateExcelDiagramData(false);
        this.setTranslateExcelDrawings(false);
        this.setSubfilter(EMPTY_SUBFILTER_CONFIGURATION);
        this.setTranslateWordInExcludeStyleMode(true);
        this.setTranslateWordInExcludeHighlightMode(true);
        this.setTranslateWordExcludeColors(false);
        this.setReorderPowerpointNotesAndComments(false);
        this.setAllowEmptyTargets(false);
        this.tsComplexFieldDefinitionsToExtract = new TreeSet();
        this.tsComplexFieldDefinitionsToExtract.add("HYPERLINK");
        this.tsExcelExcludedColors = new TreeSet();
        this.tsExcludeWordStyles = new TreeSet();
        this.tsPowerpointIncludedSlideNumbers = new TreeSet();
        this.tsWordHighlightColors = new TreeSet();
        this.tsWordExcludedColors = new TreeSet();
    }

    @Override
    public void fromString(String data) {
        String sNummer;
        int i;
        super.fromString(data);
        this.worksheetConfigurations.addFrom(new ParametersStringWorksheetConfigurationsInput(this.buffer));
        this.fontMappings.addFrom(new ParametersStringFontMappingsInput(this.buffer));
        int siz = this.buffer.getInteger("tsComplexFieldDefinitionsToExtract");
        if (siz > 0) {
            this.tsComplexFieldDefinitionsToExtract = new TreeSet();
            for (i = 0; i < siz; ++i) {
                sNummer = "cfd" + i;
                this.tsComplexFieldDefinitionsToExtract.add(this.buffer.getString(sNummer, EMPTY_SUBFILTER_CONFIGURATION));
            }
        }
        this.tsExcelExcludedColors = new TreeSet();
        siz = this.buffer.getInteger("tsExcelExcludedColors");
        for (i = 0; i < siz; ++i) {
            sNummer = "ccc" + i;
            this.tsExcelExcludedColors.add(this.buffer.getString(sNummer, "F1F2F3F4"));
        }
        this.tsExcludeWordStyles = new TreeSet();
        siz = this.buffer.getInteger("tsExcludeWordStyles");
        for (i = 0; i < siz; ++i) {
            this.tsExcludeWordStyles.add(this.buffer.getString("sss" + i, "zzzzz"));
        }
        this.tsWordHighlightColors = new TreeSet();
        siz = this.buffer.getInteger("tsWordHighlightColors");
        for (i = 0; i < siz; ++i) {
            this.tsWordHighlightColors.add(this.buffer.getString("hlt" + i, EMPTY_SUBFILTER_CONFIGURATION));
        }
        this.tsWordExcludedColors = new TreeSet();
        siz = this.buffer.getInteger("tsWordExcludedColors");
        for (i = 0; i < siz; ++i) {
            sNummer = "yyy" + i;
            this.tsWordExcludedColors.add(this.buffer.getString(sNummer, "F1F2F3F4"));
        }
        this.tsPowerpointIncludedSlideNumbers = new TreeSet();
        siz = this.buffer.getInteger("tsPowerpointIncludedSlideNumbers");
        for (i = 0; i < siz; ++i) {
            this.tsPowerpointIncludedSlideNumbers.add(this.buffer.getInteger("sln" + i, 1));
        }
    }

    @Override
    public String toString() {
        int i;
        int siz = this.tsComplexFieldDefinitionsToExtract == null ? 0 : this.tsComplexFieldDefinitionsToExtract.size();
        this.buffer.setInteger("tsComplexFieldDefinitionsToExtract", siz);
        Iterator<String> it = this.tsComplexFieldDefinitionsToExtract.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("cfd" + i, it.next());
        }
        siz = this.tsExcelExcludedColors == null ? 0 : this.tsExcelExcludedColors.size();
        this.buffer.setInteger("tsExcelExcludedColors", siz);
        it = this.tsExcelExcludedColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("ccc" + i, it.next());
        }
        siz = this.tsExcludeWordStyles == null ? 0 : this.tsExcludeWordStyles.size();
        this.buffer.setInteger("tsExcludeWordStyles", siz);
        it = this.tsExcludeWordStyles.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("sss" + i, it.next());
        }
        siz = this.tsWordHighlightColors == null ? 0 : this.tsWordHighlightColors.size();
        this.buffer.setInteger("tsWordHighlightColors", siz);
        it = this.tsWordHighlightColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("hlt" + i, it.next());
        }
        siz = this.tsWordExcludedColors == null ? 0 : this.tsWordExcludedColors.size();
        this.buffer.setInteger("tsWordExcludedColors", siz);
        it = this.tsWordExcludedColors.iterator();
        for (i = 0; i < siz && it.hasNext(); ++i) {
            this.buffer.setString("yyy" + i, it.next());
        }
        siz = this.tsPowerpointIncludedSlideNumbers == null ? 0 : this.tsPowerpointIncludedSlideNumbers.size();
        this.buffer.setInteger("tsPowerpointIncludedSlideNumbers", siz);
        Iterator<Integer> slideIterator = this.tsPowerpointIncludedSlideNumbers.iterator();
        for (i = 0; i < siz && slideIterator.hasNext(); ++i) {
            this.buffer.setInteger("sln" + i, slideIterator.next());
        }
        this.buffer.fromParametersString(this.worksheetConfigurations.writtenTo(new ParametersStringWorksheetConfigurationsOutput()), false);
        this.buffer.fromParametersString(this.fontMappings.writtenTo(new ParametersStringFontMappingsOutput()), false);
        return this.buffer.toString();
    }

    @Override
    public void save(String newPath) {
        Writer SW = null;
        try {
            SW = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(newPath)), StandardCharsets.UTF_8);
            SW.write(this.toString());
            this.path = newPath;
        }
        catch (IOException e) {
            throw new OkapiException(e);
        }
        finally {
            if (SW != null) {
                try {
                    SW.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(URI inputURI, boolean p_bIgnoreErrors) {
        try {
            int nCount;
            this.reset();
            URL url = inputURI.toURL();
            InputStreamReader SR = new InputStreamReader((InputStream)new BufferedInputStream(url.openStream()), StandardCharsets.UTF_8);
            StringBuilder sbTmp = new StringBuilder(1024);
            char[] aBuf = new char[1024];
            while ((nCount = SR.read(aBuf)) > -1) {
                sbTmp.append(aBuf, 0, nCount);
            }
            ((Reader)SR).close();
            SR = null;
            String tmp = sbTmp.toString().replace("\r\n", "\n");
            this.fromString(tmp.replace("\r", "\n"));
            this.path = inputURI.getPath();
        }
        catch (IOException e) {
            if (!p_bIgnoreErrors) {
                throw new OkapiException(e);
            }
        }
        finally {
            Object aBuf = null;
        }
    }

    public ConditionalParameters clone() {
        ConditionalParameters cpnew = new ConditionalParameters();
        cpnew.fromString(this.toString());
        cpnew.nFileType = this.nFileType;
        return cpnew;
    }

    boolean isWordExcludedStyle(String style) {
        if (null == style || null == this.tsExcludeWordStyles || this.tsExcludeWordStyles.isEmpty()) {
            return false;
        }
        return this.tsExcludeWordStyles.contains(style);
    }

    boolean isWordHighlightColor(String color) {
        if (null == color || null == this.tsWordHighlightColors || this.tsWordHighlightColors.isEmpty()) {
            return false;
        }
        return this.tsWordHighlightColors.contains(color);
    }

    boolean isWordExcludedColor(String color) {
        if (null == color || null == this.tsWordExcludedColors || this.tsWordExcludedColors.isEmpty()) {
            return false;
        }
        return this.tsWordExcludedColors.contains(color);
    }
}

