/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.XMLEventsReader;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.CreationalParameters;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunPropertiesParser;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunSkippableElements;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

final class BlockProperty
implements Property {
    private static final QName DEFAULT_NAME = new QName("");
    private static final String BU_FONT = "buFont";
    private final List<XMLEvent> events;
    private final XMLEventFactory eventFactory;
    private final ConditionalParameters conditionalParameters;
    private final StrippableAttributes strippableAttributes;

    BlockProperty(String localName, Map<String, String> attributes, CreationalParameters creationalParameters, ConditionalParameters conditionalParameters, StrippableAttributes strippableAttributes) {
        this(Stream.of(creationalParameters.getEventFactory().createStartElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName, attributes.entrySet().stream().map(e -> creationalParameters.getEventFactory().createAttribute(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), (String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()).iterator(), null), creationalParameters.getEventFactory().createEndElement(creationalParameters.getPrefix(), creationalParameters.getNamespaceUri(), localName)).collect(Collectors.toList()), conditionalParameters, creationalParameters.getEventFactory(), strippableAttributes);
    }

    BlockProperty(List<XMLEvent> events, ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, StrippableAttributes strippableAttributes) {
        this.events = events;
        this.conditionalParameters = conditionalParameters;
        this.eventFactory = eventFactory;
        this.strippableAttributes = strippableAttributes;
    }

    @Override
    public List<XMLEvent> getEvents() {
        return this.events;
    }

    @Override
    public QName getName() {
        return null == this.events.get(0) ? DEFAULT_NAME : this.events.get(0).asStartElement().getName();
    }

    @Override
    public RunProperties asRunProperties() throws XMLStreamException {
        if (!"rPr".equals(this.getName().getLocalPart()) && !"defRPr".equals(this.getName().getLocalPart())) {
            throw new IllegalStateException(String.format("The %s block property can't become run properties", this.getName().toString()));
        }
        XMLEventsReader eventReader = new XMLEventsReader(this.events);
        StartElementContext startElementContext = StartElementContextFactory.createStartElementContext(this.strippableAttributes.strip(eventReader.nextEvent().asStartElement()), null, eventReader, this.eventFactory, this.conditionalParameters);
        RunProperties runProperties = new RunPropertiesParser(startElementContext, new RunSkippableElements(startElementContext)).parse();
        if (runProperties.properties().isEmpty()) {
            return new RunProperties.Default(this.eventFactory, this.events.get(0).asStartElement(), this.events.get(this.events.size() - 1).asEndElement(), new ArrayList<Property>());
        }
        return runProperties;
    }

    @Override
    public void apply(FontMappings fontMappings) {
        if (this.events.isEmpty()) {
            return;
        }
        StartElement startElement = this.events.get(0).asStartElement();
        if (BU_FONT.equals(startElement.getName().getLocalPart())) {
            String newFont;
            String font = XMLEventHelpers.getAttributeValue(startElement, RunProperty.FontRunProperty.TYPEFACE);
            if (font.equals(newFont = fontMappings.targetFontFor(font))) {
                return;
            }
            LinkedList<Attribute> attributes = new LinkedList<Attribute>();
            Iterator<Attribute> iterator = startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                if (RunProperty.FontRunProperty.TYPEFACE.equals(attribute.getName())) {
                    attributes.add(this.eventFactory.createAttribute(attribute.getName(), newFont));
                    continue;
                }
                attributes.add(attribute);
            }
            this.events.set(0, this.eventFactory.createStartElement(startElement.getName(), attributes.iterator(), null));
        }
        if ("rPr".equals(startElement.getName().getLocalPart()) || "defRPr".equals(startElement.getName().getLocalPart())) {
            RunProperties runProperties;
            try {
                runProperties = this.asRunProperties();
            }
            catch (XMLStreamException e) {
                throw new OkapiBadFilterInputException("Error with reading the XML");
            }
            if (0 == runProperties.count()) {
                return;
            }
            runProperties.apply(fontMappings);
            if (this.events.equals(runProperties.getEvents())) {
                return;
            }
            this.events.clear();
            this.events.addAll(runProperties.getEvents());
        }
    }

    @Override
    public String value() {
        String value;
        StartElement startElement = this.events.get(0).asStartElement();
        if ("w".equals(startElement.getName().getPrefix())) {
            value = XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.WPML_VAL);
        } else if ("a".equals(startElement.getName().getPrefix())) {
            value = XMLEventHelpers.getAttributeValue(startElement, XMLEventHelpers.DML_VAL);
        } else {
            throw new IllegalStateException("The operation is not supported");
        }
        return value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockProperty that = (BlockProperty)o;
        return XMLEventHelpers.eventEquals(this.events, that.events);
    }

    public int hashCode() {
        return this.events.hashCode();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + XMLEventSerializer.serialize(this.getEvents()) + ")";
    }
}

