/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Token;

final class Statements {
    private static final String UNEXPECTED_END_OF_STREAM = "Unexpected end of stream.";
    private static final char COMMENT_START = '#';
    private static final char MARKUP_START = '<';
    private static final char MARKUP_END = '>';
    private static final char MACRO_DEFINE_START = 'd';
    private static final char MACRO_INCLUDE_START = 'i';
    private static final char MARKUP_STRING_LITERAL_START = '`';
    private static final Set<Character> COMMENT_OR_MARKUP_STARTS = new HashSet<Character>(Arrays.asList(Character.valueOf('#'), Character.valueOf('<')));
    private static final Set<String> MACRO_STARTS = new HashSet<String>(Arrays.asList("define", "include"));
    private static final Set<Character> WHITESPACES = new HashSet<Character>(Arrays.asList(Character.valueOf(' '), Character.valueOf('\t'), Character.valueOf('\r'), Character.valueOf('\n')));
    private static final Set<Character> COMMENT_ENDS = new HashSet<Character>(Arrays.asList(Character.valueOf('\r'), Character.valueOf('\n')));
    private static final Set<Character> MACRO_LITERAL_ENDS = Collections.singleton(Character.valueOf(')'));
    private static final Set<Character> MARKUP_STRING_LITERAL_ENDS = Collections.singleton(Character.valueOf('\''));
    private static final Set<Character> WHITESPACES_AND_MARKUP_ENDS = new HashSet<Character>(WHITESPACES);
    private static final String IMPORT_OBJECT = "ImportObject";
    private static final char IMPORT_OBJECT_FACET_START = '=';
    private static final String IMPORT_OBJECT_FACET_END = "=EndInset";
    private static final Set<Character> IMPORT_OBJECT_FACET_DATA_ENDS;
    private final Reader reader;

    Statements(Reader reader) {
        this.reader = reader;
    }

    Statement partialMarkup() throws IOException {
        LinkedList<Token> tokens;
        block4: {
            char ch;
            tokens = new LinkedList<Token>();
            StringBuilder sb = new StringBuilder();
            while (true) {
                ch = this.readWhileCharactersPresent(sb, WHITESPACES);
                tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
                if ('>' == ch) {
                    tokens.add(new Token.Default(ch, Token.Type.END));
                    break block4;
                }
                if ('`' != ch) break;
                tokens.add(new Token.Default(ch, Token.Type.START));
                sb.setLength(0);
                ch = this.readWhileNoCharactersPresent(sb, MARKUP_STRING_LITERAL_ENDS);
                tokens.add(new Token.Default(sb, Token.Type.LITERAL));
                tokens.add(new Token.Default(ch, Token.Type.END));
                sb.setLength(0);
            }
            while (true) {
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileNoCharactersPresent(sb, WHITESPACES_AND_MARKUP_ENDS);
                tokens.add(new Token.Default(sb, Token.Type.LITERAL));
                if ('>' == ch) {
                    tokens.add(new Token.Default(ch, Token.Type.END));
                    break;
                }
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileCharactersPresent(sb, WHITESPACES);
                tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
            }
        }
        return new Statement.Default(tokens, Statement.Type.MARKUP);
    }

    Statement empty(StringBuilder stringBuilder) {
        return new Statement.Default(new Token.Default(stringBuilder.toString(), Token.Type.WHITESPACE), Statement.Type.EMPTY);
    }

    Statement fromFirstCharacter(char firstCharacter) throws IOException {
        switch (firstCharacter) {
            case '#': {
                return this.comment(firstCharacter);
            }
            case 'd': 
            case 'i': {
                return this.macro(firstCharacter);
            }
            case '<': {
                return this.markup(firstCharacter);
            }
        }
        throw new OkapiNotImplementedException("An unsupported statement starts with '" + firstCharacter + "'");
    }

    private Statement comment(char firstCharacter) throws IOException {
        LinkedList<Token> tokens = new LinkedList<Token>();
        tokens.add(new Token.Default(firstCharacter, Token.Type.START));
        StringBuilder sb = new StringBuilder();
        char ch = this.readWhileNoCharactersPresent(sb, COMMENT_ENDS);
        tokens.add(new Token.Default(sb, Token.Type.LITERAL));
        tokens.add(new Token.Default(ch, Token.Type.END));
        return new Statement.Default(tokens, Statement.Type.COMMENT);
    }

    private Statement macro(char firstCharacter) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(firstCharacter);
        char ch = this.readWhileNoCharactersPresent(sb, WHITESPACES);
        return this.macro(sb, ch);
    }

    private Statement macro(StringBuilder sb, char nextCharacter) throws IOException {
        LinkedList<Token> tokens = new LinkedList<Token>();
        tokens.add(new Token.Default(sb, Token.Type.IDENTITY));
        sb.setLength(0);
        sb.append(nextCharacter);
        char ch = this.readWhileCharactersPresent(sb, WHITESPACES);
        tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
        sb.setLength(0);
        tokens.add(new Token.Default(ch, Token.Type.START));
        ch = this.readWhileNoCharactersPresent(sb, MACRO_LITERAL_ENDS);
        tokens.add(new Token.Default(sb, Token.Type.LITERAL));
        tokens.add(new Token.Default(ch, Token.Type.END));
        return new Statement.Default(tokens, Statement.Type.MACRO);
    }

    private Statement markup(char firstCharacter) throws IOException {
        LinkedList<Token> tokens;
        block12: {
            char ch;
            tokens = new LinkedList<Token>();
            tokens.add(new Token.Default(firstCharacter, Token.Type.START));
            StringBuilder sb = new StringBuilder();
            boolean importObject = false;
            while (true) {
                ch = this.readWhileCharactersPresent(sb, WHITESPACES);
                tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
                if ('>' == ch) {
                    tokens.add(new Token.Default(ch, Token.Type.END));
                    break block12;
                }
                if (COMMENT_OR_MARKUP_STARTS.contains(Character.valueOf(ch))) {
                    tokens.add(this.fromFirstCharacter(ch));
                    sb.setLength(0);
                    continue;
                }
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileNoCharactersPresent(sb, WHITESPACES);
                if (MACRO_STARTS.contains(sb.toString())) {
                    tokens.add(this.macro(sb, ch));
                    sb.setLength(0);
                    continue;
                }
                if (importObject && '=' == sb.charAt(0)) {
                    tokens.addAll(this.importObjectFacets(sb, ch));
                    sb.setLength(0);
                    continue;
                }
                if (tokens.stream().map(t -> t.type()).anyMatch(v -> v == Token.Type.IDENTITY)) {
                    tokens.add(new Token.Default(sb, Token.Type.LITERAL));
                } else {
                    tokens.add(new Token.Default(sb, Token.Type.IDENTITY));
                    if (IMPORT_OBJECT.equals(sb.toString())) {
                        importObject = true;
                    }
                }
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileCharactersPresent(sb, WHITESPACES);
                tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
                if ('>' == ch) {
                    tokens.add(new Token.Default(ch, Token.Type.END));
                    break block12;
                }
                if (COMMENT_OR_MARKUP_STARTS.contains(Character.valueOf(ch))) {
                    tokens.add(this.fromFirstCharacter(ch));
                    sb.setLength(0);
                    continue;
                }
                if ('`' != ch) break;
                sb.setLength(0);
                tokens.add(new Token.Default(ch, Token.Type.START));
                ch = this.readWhileNoCharactersPresent(sb, MARKUP_STRING_LITERAL_ENDS);
                tokens.add(new Token.Default(sb, Token.Type.LITERAL));
                tokens.add(new Token.Default(ch, Token.Type.END));
                sb.setLength(0);
            }
            do {
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileNoCharactersPresent(sb, WHITESPACES_AND_MARKUP_ENDS);
                tokens.add(new Token.Default(sb, Token.Type.LITERAL));
                if ('>' == ch) {
                    tokens.add(new Token.Default(ch, Token.Type.END));
                    break block12;
                }
                sb.setLength(0);
                sb.append(ch);
                ch = this.readWhileCharactersPresent(sb, WHITESPACES);
                tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
            } while ('>' != ch);
            tokens.add(new Token.Default(ch, Token.Type.END));
        }
        return new Statement.Default(tokens, Statement.Type.MARKUP);
    }

    private List<Token> importObjectFacets(StringBuilder sb, char nextCharacter) throws IOException {
        char ch;
        LinkedList<Token> tokens = new LinkedList<Token>();
        tokens.add(new Token.Default(sb, Token.Type.START));
        sb.setLength(0);
        sb.append(nextCharacter);
        while (true) {
            ch = this.readWhileCharactersPresent(sb, IMPORT_OBJECT_FACET_DATA_ENDS);
            tokens.add(new Token.Default(sb, Token.Type.WHITESPACE));
            sb.setLength(0);
            sb.append(ch);
            ch = this.readWhileNoCharactersPresent(sb, IMPORT_OBJECT_FACET_DATA_ENDS);
            if (IMPORT_OBJECT_FACET_END.equals(sb.toString())) break;
            tokens.add(new Token.Default(sb, '=' == sb.charAt(0) ? Token.Type.START : Token.Type.LITERAL));
            sb.setLength(0);
            sb.append(ch);
        }
        tokens.add(new Token.Default(sb, Token.Type.END));
        tokens.add(new Token.Default(ch, Token.Type.WHITESPACE));
        return tokens;
    }

    private char readWhileNoCharactersPresent(StringBuilder stringBuilder, Set<Character> delimiters) throws IOException {
        int ch;
        while (true) {
            if (-1 == (ch = this.reader.read())) {
                throw new OkapiIllegalFilterOperationException(UNEXPECTED_END_OF_STREAM);
            }
            if (delimiters.contains(Character.valueOf((char)ch))) break;
            stringBuilder.append((char)ch);
        }
        return (char)ch;
    }

    private char readWhileCharactersPresent(StringBuilder stringBuilder, Set<Character> delimiters) throws IOException {
        int ch;
        while (true) {
            if (-1 == (ch = this.reader.read())) {
                throw new OkapiIllegalFilterOperationException(UNEXPECTED_END_OF_STREAM);
            }
            if (!delimiters.contains(Character.valueOf((char)ch))) break;
            stringBuilder.append((char)ch);
        }
        return (char)ch;
    }

    static {
        WHITESPACES_AND_MARKUP_ENDS.add(Character.valueOf('>'));
        IMPORT_OBJECT_FACET_DATA_ENDS = COMMENT_ENDS;
    }
}

