/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.filters.mif.Token;
import org.slf4j.Logger;

final class CharLiteralToken
implements Token {
    private final Token token;
    private final Logger logger;

    CharLiteralToken(Token token, Logger logger) {
        this.token = token;
        this.logger = logger;
    }

    @Override
    public Token.Type type() {
        return this.token.type();
    }

    @Override
    public String toString() {
        switch (this.token.toString()) {
            case "": {
                return this.token.toString();
            }
            case "Tab": {
                return "\t";
            }
            case "HardSpace": {
                return "\u00a0";
            }
            case "SoftHyphen": {
                return "";
            }
            case "HardHyphen": {
                return "\u2011";
            }
            case "DiscHyphen": {
                return "\u00ad";
            }
            case "NoHyphen": {
                return "\u200d";
            }
            case "Cent": {
                return "\u00a2";
            }
            case "Pound": {
                return "\u00a3";
            }
            case "Yen": {
                return "\u00a5";
            }
            case "EnDash": {
                return "\u2013";
            }
            case "EmDash": {
                return "\u2014";
            }
            case "Dagger": {
                return "\u2020";
            }
            case "DoubleDagger": {
                return "\u2021";
            }
            case "Bullet": {
                return "\u2022";
            }
            case "HardReturn": {
                return "\n";
            }
            case "NumberSpace": {
                return "\u2007";
            }
            case "ThinSpace": {
                return "\u2009";
            }
            case "EnSpace": {
                return "\u2002";
            }
            case "EmSpace": {
                return "\u2003";
            }
        }
        this.logger.warn("Unknown Char literal will be ignored: '{}'", (Object)this.token.toString());
        return "";
    }
}

