/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.filters.idml.CodeTypes;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.SpecialCharacter;
import net.sf.okapi.filters.idml.TextSkeleton;

final class TextElementMapping {
    private static final String SPECIAL_CHARACTER = "special-character";
    private static final String DASH = "-";
    private static final String TAG_OPENING = "<";
    private static final String TAG_CLOSING = "/>";
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator textUnitIds;
    private TextFragment textFragment;
    private Map<Integer, MarkupRange> codeMap;
    private int nextCodeId;

    TextElementMapping(Parameters parameters, XMLEventFactory eventFactory, IdGenerator textUnitIds) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.textUnitIds = textUnitIds;
    }

    ITextUnit textUnitFor(Element textElement) {
        this.codeMap = new HashMap<Integer, MarkupRange>();
        this.nextCodeId = 1;
        this.textFragment = new TextFragment();
        this.mapCodesIn(textElement.innerEvents());
        TextUnit textUnit = new TextUnit(this.textUnitIds.createId());
        textUnit.setPreserveWhitespaces(true);
        textUnit.setSource(new TextContainer(this.textFragment));
        TextSkeleton skeleton = new TextSkeleton(textElement, this.codeMap);
        skeleton.setParent(textUnit);
        textUnit.setSkeleton(skeleton);
        return textUnit;
    }

    private void mapCodesIn(List<XMLEvent> events) {
        for (XMLEvent event : events) {
            if (event.isProcessingInstruction()) {
                this.addIsolatedCodeFor(new SpecialCharacter.Instruction(event));
                continue;
            }
            if (!event.isCharacters()) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.isolateSpecialCharactersIn(event.asCharacters().getData());
        }
    }

    private void addIsolatedCodeFor(MarkupRange markupRange) {
        String codeType = CodeTypes.createCodeType(markupRange);
        String codeData = "<special-character-" + this.nextCodeId + TAG_CLOSING;
        Code code = new Code(TextFragment.TagType.PLACEHOLDER, codeType, codeData);
        code.setId(this.nextCodeId);
        this.textFragment.append(code);
        this.codeMap.put(this.nextCodeId, markupRange);
        ++this.nextCodeId;
    }

    private void isolateSpecialCharactersIn(String characters) {
        for (int i = 0; i < characters.length(); ++i) {
            char character = characters.charAt(i);
            SpecialCharacter.Type specialCharacterType = SpecialCharacter.Type.fromDefaultString(String.valueOf(character));
            if (this.parameters.getSkipDiscretionaryHyphens() && SpecialCharacter.Type.DISCRETIONARY_HYPHEN == specialCharacterType) continue;
            if (SpecialCharacter.Type.UNSUPPORTED != specialCharacterType) {
                SpecialCharacter.Default specialCharacter = new SpecialCharacter.Default(this.eventFactory.createCharacters(String.valueOf(character)));
                this.addIsolatedCodeFor(specialCharacter);
                continue;
            }
            this.textFragment.append(character);
        }
    }
}

