/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.idml.Accumulation;
import net.sf.okapi.filters.idml.DocumentPartEventBuilder;
import net.sf.okapi.filters.idml.Markup;
import net.sf.okapi.filters.idml.MarkupRange;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.StoryChildElement;
import net.sf.okapi.filters.idml.StyledTextElementsAccumulation;
import net.sf.okapi.filters.idml.StyledTextElementsMapping;

class StoryChildElementsEventsAccumulation
implements Accumulation<Event> {
    private final Parameters parameters;
    private final XMLEventFactory eventFactory;
    private final IdGenerator documentPartIdGenerator;
    private final IdGenerator textUnitIdGenerator;
    private final ListIterator<StoryChildElement> storyChildElementIterator;
    private List<Event> events;
    private List<Event> referentEvents;

    StoryChildElementsEventsAccumulation(Parameters parameters, XMLEventFactory eventFactory, IdGenerator documentPartIdGenerator, IdGenerator textUnitIdGenerator, ListIterator<StoryChildElement> storyChildElementIterator) {
        this.parameters = parameters;
        this.eventFactory = eventFactory;
        this.documentPartIdGenerator = documentPartIdGenerator;
        this.textUnitIdGenerator = textUnitIdGenerator;
        this.storyChildElementIterator = storyChildElementIterator;
        this.events = new ArrayList<Event>();
        this.referentEvents = new ArrayList<Event>();
    }

    @Override
    public List<Event> asList() throws XMLStreamException {
        DocumentPartEventBuilder documentPartEventBuilder = new DocumentPartEventBuilder(this.documentPartIdGenerator, new Markup.Default(new LinkedList<MarkupRange>()));
        while (this.storyChildElementIterator.hasNext()) {
            StoryChildElement storyChildElement = this.storyChildElementIterator.next();
            if (storyChildElement instanceof StoryChildElement.StyledTextElement) {
                documentPartEventBuilder = this.addMarkupElementsEvent(documentPartEventBuilder);
                this.storyChildElementIterator.previous();
                this.addStyledTextElementsEvents(new StyledTextElementsAccumulation(this.parameters, this.storyChildElementIterator).asList());
                continue;
            }
            documentPartEventBuilder.addMarkupRangeElement(storyChildElement);
        }
        this.addMarkupElementsEvent(documentPartEventBuilder);
        this.events.addAll(this.referentEvents);
        return this.events;
    }

    private DocumentPartEventBuilder addMarkupElementsEvent(DocumentPartEventBuilder documentPartEventBuilder) {
        this.events.add(documentPartEventBuilder.build());
        return new DocumentPartEventBuilder(this.documentPartIdGenerator, new Markup.Default(new LinkedList<MarkupRange>()));
    }

    private void addStyledTextElementsEvents(List<StoryChildElement> styledTextElements) throws XMLStreamException {
        List<Event> currentEvents = new StyledTextElementsMapping(this.parameters, this.eventFactory, this.documentPartIdGenerator, this.textUnitIdGenerator).eventsFor(styledTextElements);
        this.events.add(currentEvents.get(0));
        this.referentEvents.addAll(currentEvents.subList(1, currentEvents.size()));
    }
}

