/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.LinkedList;
import net.sf.okapi.common.Sanitiser;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.StringSanitiser;
import net.sf.okapi.common.filters.fontmappings.DefaultFontMappings;
import net.sf.okapi.common.filters.fontmappings.FontMapping;
import net.sf.okapi.common.filters.fontmappings.FontMappings;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsInput;
import net.sf.okapi.common.filters.fontmappings.ParametersStringFontMappingsOutput;
import net.sf.okapi.filters.idml.StyleIgnorances;

public class Parameters
extends StringParameters {
    private static final String EMPTY = "";
    private static final String VALUE_IS_NOT_VALID = " \"%s\" value is not valid";
    private static final String MAX_ATTRIBUTE_SIZE = "maxAttributeSize";
    private static final String UNTAG_XML_STRUCTURES = "untagXmlStructures";
    private static final String EXTRACT_NOTES = "extractNotes";
    private static final String EXTRACT_MASTER_SPREADS = "extractMasterSpreads";
    private static final String EXTRACT_HIDDEN_LAYERS = "extractHiddenLayers";
    private static final String EXTRACT_HIDDEN_PASTEBOARD_ITEMS = "extractHiddenPasteboardItems";
    private static final String SKIP_DISCRETIONARY_HYPHENS = "skipDiscretionaryHyphens";
    private static final String EXTRACT_BREAKS_INLINE = "extractBreaksInline";
    private static final String EXTRACT_CUSTOM_TEXT_VARIABLES = "extractCustomTextVariables";
    private static final String EXTRACT_INDEX_TOPICS = "extractIndexTopics";
    private static final String IGNORE_CHARACTER_KERNING = "ignoreCharacterKerning";
    private static final String CHARACTER_KERNING_MIN_IGNORANCE_THRESHOLD = "characterKerningMinIgnoranceThreshold";
    private static final String CHARACTER_KERNING_MAX_IGNORANCE_THRESHOLD = "characterKerningMaxIgnoranceThreshold";
    private static final String IGNORE_CHARACTER_TRACKING = "ignoreCharacterTracking";
    private static final String CHARACTER_TRACKING_MIN_IGNORANCE_THRESHOLD = "characterTrackingMinIgnoranceThreshold";
    private static final String CHARACTER_TRACKING_MAX_IGNORANCE_THRESHOLD = "characterTrackingMaxIgnoranceThreshold";
    private static final String IGNORE_CHARACTER_LEADING = "ignoreCharacterLeading";
    private static final String CHARACTER_LEADING_MIN_IGNORANCE_THRESHOLD = "characterLeadingMinIgnoranceThreshold";
    private static final String CHARACTER_LEADING_MAX_IGNORANCE_THRESHOLD = "characterLeadingMaxIgnoranceThreshold";
    private static final String IGNORE_CHARACTER_BASELINE_SHIFT = "ignoreCharacterBaselineShift";
    private static final String CHARACTER_BASELINE_SHIFT_MIN_IGNORANCE_THRESHOLD = "characterBaselineShiftMinIgnoranceThreshold";
    private static final String CHARACTER_BASELINE_SHIFT_MAX_IGNORANCE_THRESHOLD = "characterBaselineShiftMaxIgnoranceThreshold";
    private static final String CHARACTER_KERNING_MINIMUM_IGNORANCE_THRESHOLD = "Character kerning minimum ignorance threshold";
    private static final String CHARACTER_KERNING_MAXIMUM_IGNORANCE_THRESHOLD = "Character kerning maximum ignorance threshold";
    private static final String CHARACTER_TRACKING_MINIMUM_IGNORANCE_THRESHOLD = "Character tracking minimum ignorance threshold";
    private static final String CHARACTER_TRACKING_MAXIMUM_IGNORANCE_THRESHOLD = "Character tracking maximum ignorance threshold";
    private static final String CHARACTER_LEADING_MINIMUM_IGNORANCE_THRESHOLD = "Character leading minimum ignorance threshold";
    private static final String CHARACTER_LEADING_MAXIMUM_IGNORANCE_THRESHOLD = "Character leading maximum ignorance threshold";
    private static final String CHARACTER_BASELINE_SHIFT_MINIMUM_IGNORANCE_THRESHOLD = "Character baseline shift minimum ignorance threshold";
    private static final String CHARACTER_BASELINE_SHIFT_MAXIMUM_IGNORANCE_THRESHOLD = "Character baseline shift maximum ignorance threshold";
    private StyleIgnorances styleIgnorances;
    private FontMappings fontMappings;

    @Override
    public void reset() {
        this.styleIgnorances = new StyleIgnorances(new EnumMap<StyleIgnorances.AttributeName, StyleIgnorances.Thresholds>(StyleIgnorances.AttributeName.class), new EnumMap<StyleIgnorances.PropertyName, StyleIgnorances.Thresholds>(StyleIgnorances.PropertyName.class));
        this.fontMappings = new DefaultFontMappings(new LinkedList<FontMapping>());
        super.reset();
        this.setMaxAttributeSize(0x400000);
        this.setUntagXmlStructures(true);
        this.setExtractNotes(false);
        this.setExtractMasterSpreads(true);
        this.setExtractHiddenLayers(false);
        this.setExtractHiddenPasteboardItems(false);
        this.setSkipDiscretionaryHyphens(false);
        this.setExtractBreaksInline(false);
        this.setExtractCustomTextVariables(false);
        this.setExtractIndexTopics(false);
        this.setIgnoreCharacterKerning(false);
        this.setIgnoreCharacterTracking(false);
        this.setIgnoreCharacterLeading(false);
        this.setIgnoreCharacterBaselineShift(false);
    }

    public int getMaxAttributeSize() {
        return this.getInteger(MAX_ATTRIBUTE_SIZE);
    }

    public void setMaxAttributeSize(int maxAttributeSize) {
        this.setInteger(MAX_ATTRIBUTE_SIZE, maxAttributeSize);
    }

    public boolean getUntagXmlStructures() {
        return this.getBoolean(UNTAG_XML_STRUCTURES);
    }

    public void setUntagXmlStructures(boolean untagXmlStructures) {
        this.setBoolean(UNTAG_XML_STRUCTURES, untagXmlStructures);
    }

    public boolean getExtractNotes() {
        return this.getBoolean(EXTRACT_NOTES);
    }

    public void setExtractNotes(boolean extractNotes) {
        this.setBoolean(EXTRACT_NOTES, extractNotes);
    }

    public boolean getExtractMasterSpreads() {
        return this.getBoolean(EXTRACT_MASTER_SPREADS);
    }

    public void setExtractMasterSpreads(boolean extractMasterSpreads) {
        this.setBoolean(EXTRACT_MASTER_SPREADS, extractMasterSpreads);
    }

    public boolean getExtractHiddenLayers() {
        return this.getBoolean(EXTRACT_HIDDEN_LAYERS);
    }

    public void setExtractHiddenLayers(boolean extractHiddenLayers) {
        this.setBoolean(EXTRACT_HIDDEN_LAYERS, extractHiddenLayers);
    }

    public boolean getExtractHiddenPasteboardItems() {
        return this.getBoolean(EXTRACT_HIDDEN_PASTEBOARD_ITEMS);
    }

    public void setExtractHiddenPasteboardItems(boolean extractHiddenPasteboardItems) {
        this.setBoolean(EXTRACT_HIDDEN_PASTEBOARD_ITEMS, extractHiddenPasteboardItems);
    }

    public void setSkipDiscretionaryHyphens(boolean skipDiscretionaryHyphens) {
        this.setBoolean(SKIP_DISCRETIONARY_HYPHENS, skipDiscretionaryHyphens);
    }

    public boolean getSkipDiscretionaryHyphens() {
        return this.getBoolean(SKIP_DISCRETIONARY_HYPHENS);
    }

    public void setExtractBreaksInline(boolean extractBreaksInline) {
        this.setBoolean(EXTRACT_BREAKS_INLINE, extractBreaksInline);
    }

    public boolean getExtractBreaksInline() {
        return this.getBoolean(EXTRACT_BREAKS_INLINE);
    }

    public void setExtractCustomTextVariables(boolean extractCustomTextVariables) {
        this.setBoolean(EXTRACT_CUSTOM_TEXT_VARIABLES, extractCustomTextVariables);
    }

    public boolean getExtractCustomTextVariables() {
        return this.getBoolean(EXTRACT_CUSTOM_TEXT_VARIABLES);
    }

    public void setExtractIndexTopics(boolean extractIndexTopics) {
        this.setBoolean(EXTRACT_INDEX_TOPICS, extractIndexTopics);
    }

    public boolean getExtractIndexTopics() {
        return this.getBoolean(EXTRACT_INDEX_TOPICS);
    }

    public boolean getIgnoreCharacterKerning() {
        return this.getBoolean(IGNORE_CHARACTER_KERNING);
    }

    public void setIgnoreCharacterKerning(boolean ignore) {
        this.setBoolean(IGNORE_CHARACTER_KERNING, ignore);
        if (ignore) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_METHOD, StyleIgnorances.Thresholds.empty());
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_VALUE, StyleIgnorances.Thresholds.empty());
        } else {
            this.styleIgnorances.removeAttribute(StyleIgnorances.AttributeName.KERNING_METHOD);
            this.styleIgnorances.removeAttribute(StyleIgnorances.AttributeName.KERNING_VALUE);
        }
    }

    public String getCharacterKerningMinIgnoranceThreshold() {
        return this.getString(CHARACTER_KERNING_MIN_IGNORANCE_THRESHOLD);
    }

    public void setCharacterKerningMinIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterKerning()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_KERNING_MIN_IGNORANCE_THRESHOLD, threshold, "Character kerning minimum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_VALUE, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, threshold, this.getCharacterKerningMaxIgnoranceThreshold()));
    }

    public String getCharacterKerningMaxIgnoranceThreshold() {
        return this.getString(CHARACTER_KERNING_MAX_IGNORANCE_THRESHOLD);
    }

    public void setCharacterKerningMaxIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterKerning()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_KERNING_MAX_IGNORANCE_THRESHOLD, threshold, "Character kerning maximum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_VALUE, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterKerningMinIgnoranceThreshold(), threshold));
    }

    public boolean getIgnoreCharacterTracking() {
        return this.getBoolean(IGNORE_CHARACTER_TRACKING);
    }

    public void setIgnoreCharacterTracking(boolean ignore) {
        this.setBoolean(IGNORE_CHARACTER_TRACKING, ignore);
        if (ignore) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.TRACKING, StyleIgnorances.Thresholds.empty());
        } else {
            this.styleIgnorances.removeAttribute(StyleIgnorances.AttributeName.TRACKING);
        }
    }

    public String getCharacterTrackingMinIgnoranceThreshold() {
        return this.getString(CHARACTER_TRACKING_MIN_IGNORANCE_THRESHOLD);
    }

    public void setCharacterTrackingMinIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterTracking()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_TRACKING_MIN_IGNORANCE_THRESHOLD, threshold, "Character tracking minimum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.TRACKING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, threshold, this.getCharacterTrackingMaxIgnoranceThreshold()));
    }

    public String getCharacterTrackingMaxIgnoranceThreshold() {
        return this.getString(CHARACTER_TRACKING_MAX_IGNORANCE_THRESHOLD);
    }

    public void setCharacterTrackingMaxIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterTracking()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_TRACKING_MAX_IGNORANCE_THRESHOLD, threshold, "Character tracking maximum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.TRACKING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterTrackingMinIgnoranceThreshold(), threshold));
    }

    public boolean getIgnoreCharacterLeading() {
        return this.getBoolean(IGNORE_CHARACTER_LEADING);
    }

    public void setIgnoreCharacterLeading(boolean ignore) {
        this.setBoolean(IGNORE_CHARACTER_LEADING, ignore);
        if (ignore) {
            this.styleIgnorances.putProperty(StyleIgnorances.PropertyName.LEADING, StyleIgnorances.Thresholds.empty());
        } else {
            this.styleIgnorances.removeProperty(StyleIgnorances.PropertyName.LEADING);
        }
    }

    public String getCharacterLeadingMinIgnoranceThreshold() {
        return this.getString(CHARACTER_LEADING_MIN_IGNORANCE_THRESHOLD);
    }

    public void setCharacterLeadingMinIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterLeading()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_LEADING_MIN_IGNORANCE_THRESHOLD, threshold, "Character leading minimum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putProperty(StyleIgnorances.PropertyName.LEADING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, threshold, this.getCharacterLeadingMaxIgnoranceThreshold()));
    }

    public String getCharacterLeadingMaxIgnoranceThreshold() {
        return this.getString(CHARACTER_LEADING_MAX_IGNORANCE_THRESHOLD);
    }

    public void setCharacterLeadingMaxIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterLeading()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_LEADING_MAX_IGNORANCE_THRESHOLD, threshold, "Character leading maximum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putProperty(StyleIgnorances.PropertyName.LEADING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterLeadingMinIgnoranceThreshold(), threshold));
    }

    public boolean getIgnoreCharacterBaselineShift() {
        return this.getBoolean(IGNORE_CHARACTER_BASELINE_SHIFT);
    }

    public void setIgnoreCharacterBaselineShift(boolean ignore) {
        this.setBoolean(IGNORE_CHARACTER_BASELINE_SHIFT, ignore);
        if (ignore) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.BASELINE_SHIFT, StyleIgnorances.Thresholds.empty());
        } else {
            this.styleIgnorances.removeAttribute(StyleIgnorances.AttributeName.BASELINE_SHIFT);
        }
    }

    public String getCharacterBaselineShiftMinIgnoranceThreshold() {
        return this.getString(CHARACTER_BASELINE_SHIFT_MIN_IGNORANCE_THRESHOLD);
    }

    public void setCharacterBaselineShiftMinIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterBaselineShift()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_BASELINE_SHIFT_MIN_IGNORANCE_THRESHOLD, threshold, "Character baseline shift minimum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.BASELINE_SHIFT, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, threshold, this.getCharacterBaselineShiftMaxIgnoranceThreshold()));
    }

    public String getCharacterBaselineShiftMaxIgnoranceThreshold() {
        return this.getString(CHARACTER_BASELINE_SHIFT_MAX_IGNORANCE_THRESHOLD);
    }

    public void setCharacterBaselineShiftMaxIgnoranceThreshold(String threshold) {
        if (!this.getIgnoreCharacterBaselineShift()) {
            return;
        }
        this.sanitiseAsDoubleAndSet(CHARACTER_BASELINE_SHIFT_MAX_IGNORANCE_THRESHOLD, threshold, "Character baseline shift maximum ignorance threshold \"%s\" value is not valid");
        this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.BASELINE_SHIFT, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterBaselineShiftMinIgnoranceThreshold(), threshold));
    }

    private void sanitiseAsIntegerAndSet(String name, String value, String errorMessageFormat) {
        this.setString(name, this.sanitiseAsInteger(value, errorMessageFormat));
    }

    private void sanitiseAsDoubleAndSet(String name, String value, String errorMessageFormat) {
        this.setString(name, this.sanitiseAsDouble(value, errorMessageFormat));
    }

    private String sanitiseAsInteger(String value, String errorMessageFormat) {
        return this.sanitiseAs(Integer.class, value, errorMessageFormat);
    }

    private String sanitiseAsDouble(String value, String errorMessageFormat) {
        return this.sanitiseAs(Double.class, value, errorMessageFormat);
    }

    private String sanitiseAs(Class type, String value, String errorMessageFormat) {
        if (EMPTY.equals(value.trim())) {
            return EMPTY;
        }
        ArrayList<Sanitiser.Filter<String>> filters = new ArrayList<Sanitiser.Filter<String>>(2);
        filters.add(new StringSanitiser.TrimmingFilter());
        switch (type.getSimpleName()) {
            case "Integer": {
                filters.add(new StringSanitiser.IntegerParsingFilter(errorMessageFormat));
                break;
            }
            case "Double": {
                filters.add(new StringSanitiser.DoubleParsingFilter(errorMessageFormat));
                break;
            }
        }
        return new StringSanitiser(filters).sanitise(value);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.fontMappings.addFrom(new ParametersStringFontMappingsInput(this.buffer));
        this.loadStyleIgnorances();
    }

    @Override
    public String toString() {
        this.buffer.fromParametersString(this.fontMappings.writtenTo(new ParametersStringFontMappingsOutput()), false);
        return super.toString();
    }

    public FontMappings fontMappings() {
        return this.fontMappings;
    }

    void fontMappings(FontMappings fontMappings) {
        this.fontMappings = fontMappings;
    }

    StyleIgnorances styleIgnorances() {
        return this.styleIgnorances;
    }

    private void loadStyleIgnorances() {
        if (this.getIgnoreCharacterKerning()) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_METHOD, StyleIgnorances.Thresholds.empty());
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.KERNING_VALUE, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterKerningMinIgnoranceThreshold(), this.getCharacterKerningMaxIgnoranceThreshold()));
        }
        if (this.getIgnoreCharacterTracking()) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.TRACKING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterTrackingMinIgnoranceThreshold(), this.getCharacterTrackingMaxIgnoranceThreshold()));
        }
        if (this.getIgnoreCharacterLeading()) {
            this.styleIgnorances.putProperty(StyleIgnorances.PropertyName.LEADING, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterLeadingMinIgnoranceThreshold(), this.getCharacterLeadingMaxIgnoranceThreshold()));
        }
        if (this.getIgnoreCharacterBaselineShift()) {
            this.styleIgnorances.putAttribute(StyleIgnorances.AttributeName.BASELINE_SHIFT, new StyleIgnorances.Thresholds(StyleIgnorances.Thresholds.Type.DOUBLE, this.getCharacterBaselineShiftMinIgnoranceThreshold(), this.getCharacterBaselineShiftMaxIgnoranceThreshold()));
        }
    }
}

