/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.idml.MarkupSkeleton;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.TextSkeleton;
import net.sf.okapi.filters.idml.TextSkeletonMerging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DesignMapSubDocumentWriter
implements IFilterWriter {
    private static final String ERROR_CREATING_SUB_DOCUMENT_WRITER = "Error creating sub document writer";
    private static final String ERROR_ADDING_EVENTS_TO_SUB_DOCUMENT_WRITER = "Error adding events to sub document writer";
    private static final String ERROR_CLOSING_SUB_DOCUMENT_WRITER = "Error closing sub document writer";
    private static final String ERROR_CLOSING_OUTPUT_STREAM = "Error closing output stream";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Parameters parameters;
    private final XMLOutputFactory outputFactory;
    private final String outputPath;
    private final String encoding;
    private final TextSkeletonMerging textSkeletonMerging;
    private XMLEventWriter eventWriter;
    private OutputStream outputStream;

    DesignMapSubDocumentWriter(Parameters parameters, XMLOutputFactory outputFactory, String encoding, String outputPath, TextSkeletonMerging textSkeletonMerging) {
        this.parameters = parameters;
        this.outputFactory = outputFactory;
        this.encoding = encoding;
        this.outputPath = outputPath;
        this.textSkeletonMerging = textSkeletonMerging;
    }

    @Override
    public String getName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public void setOptions(LocaleId locale, String defaultEncoding) {
    }

    @Override
    public void setOutput(String path) {
    }

    @Override
    public void setOutput(OutputStream output) {
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.createOutputStreamAndEventWriter();
                break;
            }
            case DOCUMENT_PART: {
                this.handleDocumentPartEvent(event);
                break;
            }
            case TEXT_UNIT: {
                this.handleTextUnitEvent(event);
                break;
            }
            case END_DOCUMENT: {
                this.close();
                break;
            }
        }
        return event;
    }

    private void createOutputStreamAndEventWriter() {
        Util.createDirectories(this.outputPath);
        try {
            this.outputStream = new FileOutputStream(this.outputPath);
            this.eventWriter = this.outputFactory.createXMLEventWriter(this.outputStream, this.encoding);
        }
        catch (FileNotFoundException | XMLStreamException e) {
            throw new OkapiIOException(ERROR_CREATING_SUB_DOCUMENT_WRITER, e);
        }
    }

    private void handleDocumentPartEvent(Event event) {
        ISkeleton skeleton = event.getDocumentPart().getSkeleton();
        try {
            if (!(skeleton instanceof MarkupSkeleton)) {
                throw new IllegalStateException("Unexpected structure");
            }
            this.write(((MarkupSkeleton)skeleton).getMarkup().getEvents());
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(ERROR_ADDING_EVENTS_TO_SUB_DOCUMENT_WRITER, e);
        }
    }

    private void handleTextUnitEvent(Event event) {
        ITextUnit tu = event.getTextUnit();
        this.textSkeletonMerging.performFor(tu);
        try {
            this.write(((TextSkeleton)tu.getSkeleton()).element().getEvents());
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(ERROR_ADDING_EVENTS_TO_SUB_DOCUMENT_WRITER, e);
        }
    }

    private void write(List<XMLEvent> events) throws XMLStreamException {
        for (XMLEvent event : events) {
            this.eventWriter.add(event);
        }
    }

    @Override
    public void close() {
        block5: {
            try {
                if (this.eventWriter != null) {
                    this.eventWriter.close();
                }
                if (this.outputStream == null) break block5;
                try {
                    this.outputStream.close();
                }
                catch (IOException e) {
                    this.logger.warn(ERROR_CLOSING_OUTPUT_STREAM, (Throwable)e);
                }
                this.outputStream = null;
            }
            catch (XMLStreamException e) {
                throw new OkapiIOException(ERROR_CLOSING_SUB_DOCUMENT_WRITER, e);
            }
        }
    }

    @Override
    public Parameters getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(IParameters params) {
    }

    @Override
    public void cancel() {
    }

    @Override
    public EncoderManager getEncoderManager() {
        return null;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return null;
    }
}

