/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Layer;
import net.sf.okapi.filters.idml.Namespaces;
import net.sf.okapi.filters.idml.OrderingIdioms;
import net.sf.okapi.filters.idml.Parameters;
import net.sf.okapi.filters.idml.ParsingIdioms;
import net.sf.okapi.filters.idml.PasteboardItem;
import net.sf.okapi.filters.idml.Preferences;
import net.sf.okapi.filters.idml.PreferencesParser;
import net.sf.okapi.filters.idml.Spread;
import net.sf.okapi.filters.idml.SpreadParser;
import net.sf.okapi.filters.idml.ZipInput;

interface DesignMapFragments {
    public static final String MIME_TYPE = "mimetype";
    public static final String DESIGN_MAP = "designmap.xml";

    public String stylesPartName();

    public List<String> orderedPartNames() throws XMLStreamException, IOException;

    public List<String> translatablePartNames() throws XMLStreamException, IOException;

    public List<XMLEvent> events();

    public void from(ZipEntry var1) throws XMLStreamException, IOException;

    public static final class Default
    implements DesignMapFragments {
        private static final String CONTAINER = "META-INF/container.xml";
        private static final String METADATA = "META-INF/metadata.xml";
        private static final QName DOCUMENT = Namespaces.getDefaultNamespace().getQName("Document");
        private static final QName ACTIVE_LAYER = Namespaces.getDefaultNamespace().getQName("ActiveLayer");
        private static final QName SRC = Namespaces.getDefaultNamespace().getQName("src");
        private static final QName VARIABLE_TYPE = Namespaces.getDefaultNamespace().getQName("VariableType");
        private static final QName GRAPHIC = Namespaces.getIdPackageNamespace().getQName("Graphic");
        private static final QName FONTS = Namespaces.getIdPackageNamespace().getQName("Fonts");
        private static final QName STYLES = Namespaces.getIdPackageNamespace().getQName("Styles");
        private static final QName PREFERENCES = Namespaces.getIdPackageNamespace().getQName("Preferences");
        private static final QName TEXT_VARIABLE = Namespaces.getDefaultNamespace().getQName("TextVariable");
        private static final String CUSTOM_TEXT_TYPE = "CustomTextType";
        private static final QName TAGS = Namespaces.getIdPackageNamespace().getQName("Tags");
        private static final QName MAPPING = Namespaces.getIdPackageNamespace().getQName("Mapping");
        private static final QName LAYER = Namespaces.getDefaultNamespace().getQName("Layer");
        private static final QName MASTER_SPREAD = Namespaces.getIdPackageNamespace().getQName("MasterSpread");
        private static final QName SPREAD = Namespaces.getIdPackageNamespace().getQName("Spread");
        static final QName MASTER_SPREAD_DEFAULT = Namespaces.getDefaultNamespace().getQName("MasterSpread");
        static final QName SPREAD_DEFAULT = Namespaces.getDefaultNamespace().getQName("Spread");
        private static final QName INDEX = Namespaces.getDefaultNamespace().getQName("Index");
        private static final QName TOPIC = Namespaces.getDefaultNamespace().getQName("Topic");
        private static final QName BACKING_STORY = Namespaces.getIdPackageNamespace().getQName("BackingStory");
        private static final QName STORY = Namespaces.getIdPackageNamespace().getQName("Story");
        private final Parameters parameters;
        private final XMLEventFactory eventFactory;
        private final ZipFile zipFile;
        private final ZipInput<XMLEventReader> zipInputReader;
        private String activeLayerId;
        private String graphicPartName;
        private String fontsPartName;
        private String stylesPartName;
        private String preferencesPartName;
        private String tagsPartName;
        private String mappingPartName;
        private final List<Layer> layers;
        private final List<String> masterSpreadPartNames;
        private final List<String> spreadPartNames;
        private String backingStoryPartName;
        private final List<String> storyPartNames;
        private final List<XMLEvent> events;
        private List<String> visibleStoryPartNames;

        Default(Parameters parameters, XMLEventFactory eventFactory, ZipFile zipFile, ZipInput<XMLEventReader> zipInputReader) {
            this(parameters, eventFactory, zipFile, zipInputReader, new ArrayList<Layer>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<XMLEvent>());
        }

        Default(Parameters parameters, XMLEventFactory eventFactory, ZipFile zipFile, ZipInput<XMLEventReader> zipInputReader, List<Layer> layers, List<String> masterSpreadPartNames, List<String> spreadPartNames, List<String> storyPartNames, List<XMLEvent> events) {
            this.parameters = parameters;
            this.eventFactory = eventFactory;
            this.zipFile = zipFile;
            this.zipInputReader = zipInputReader;
            this.layers = layers;
            this.masterSpreadPartNames = masterSpreadPartNames;
            this.spreadPartNames = spreadPartNames;
            this.storyPartNames = storyPartNames;
            this.events = events;
        }

        @Override
        public String stylesPartName() {
            return this.stylesPartName;
        }

        @Override
        public List<String> orderedPartNames() throws XMLStreamException, IOException {
            LinkedList<String> partNames = new LinkedList<String>();
            partNames.add(DesignMapFragments.MIME_TYPE);
            partNames.add(DesignMapFragments.DESIGN_MAP);
            partNames.add(CONTAINER);
            partNames.add(METADATA);
            partNames.add(this.graphicPartName);
            partNames.add(this.fontsPartName);
            partNames.add(this.stylesPartName);
            partNames.add(this.preferencesPartName);
            partNames.add(this.tagsPartName);
            partNames.add(this.mappingPartName);
            partNames.addAll(this.masterSpreadPartNames);
            partNames.addAll(this.spreadPartNames);
            partNames.add(this.backingStoryPartName);
            partNames.addAll(this.visibleStoryPartNames());
            return partNames;
        }

        private List<String> visibleStoryPartNames() throws XMLStreamException, IOException {
            if (null == this.visibleStoryPartNames) {
                Preferences preferences = new PreferencesParser(this.zipInputReader).parse(this.zipFile.getEntry(this.preferencesPartName));
                ArrayList<PasteboardItem> pasteboardItems = new ArrayList<PasteboardItem>();
                ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>();
                List<Spread> masterSpreads = this.spreads(this.masterSpreadPartNames, this.activeLayerId, MASTER_SPREAD_DEFAULT);
                List<PasteboardItem> masterSpreadPasteboardItems = OrderingIdioms.getOrderedPasteboardItems(masterSpreads, preferences.getStoryPreference().getStoryDirection(), this.eventFactory);
                if (this.parameters.getExtractMasterSpreads()) {
                    pasteboardItems.addAll(masterSpreadPasteboardItems);
                } else {
                    invisiblePasteboardItems.addAll(masterSpreadPasteboardItems);
                }
                List<Spread> spreads = this.spreads(this.spreadPartNames, this.activeLayerId, SPREAD_DEFAULT);
                pasteboardItems.addAll(OrderingIdioms.getOrderedPasteboardItems(spreads, preferences.getStoryPreference().getStoryDirection(), this.eventFactory));
                List<PasteboardItem> visiblePasteboardItems = this.visiblePasteboardItems(pasteboardItems);
                invisiblePasteboardItems.addAll(this.invisiblePasteboardItems(pasteboardItems, visiblePasteboardItems));
                List<String> visibleStoryIds = OrderingIdioms.getOrderedStoryIds(visiblePasteboardItems);
                this.visibleStoryPartNames = OrderingIdioms.getOrderedStoryPartNames(this.storyPartNames, visibleStoryIds);
                List<String> invisibleStoryIds = OrderingIdioms.getOrderedStoryIds(invisiblePasteboardItems);
                List<String> invisibleStoryPartNames = OrderingIdioms.getOrderedStoryPartNames(this.storyPartNames, invisibleStoryIds);
                List anchoredStoryPartNames = this.storyPartNames.stream().filter(s -> !this.visibleStoryPartNames.contains(s) && !invisibleStoryPartNames.contains(s)).collect(Collectors.toList());
                this.visibleStoryPartNames.addAll(anchoredStoryPartNames);
            }
            return this.visibleStoryPartNames;
        }

        private List<Spread> spreads(List<String> spreadPartNames, String activeLayerId, QName spreadName) throws IOException, XMLStreamException {
            ArrayList<Spread> spreads = new ArrayList<Spread>();
            SpreadParser sp = new SpreadParser(this.zipInputReader, spreadName, this.eventFactory, activeLayerId);
            for (String spreadPartName : spreadPartNames) {
                Spread spread = sp.parse(this.zipFile.getEntry(spreadPartName));
                spreads.add(spread);
            }
            return spreads;
        }

        private List<PasteboardItem> visiblePasteboardItems(List<PasteboardItem> pasteboardItems) {
            return new PasteboardItem.VisibilityFilter(this.layers, this.parameters.getExtractHiddenLayers(), this.parameters.getExtractHiddenPasteboardItems()).filterVisible(pasteboardItems);
        }

        private List<PasteboardItem> invisiblePasteboardItems(List<PasteboardItem> pasteboardItems, List<PasteboardItem> visiblePasteboardItems) {
            ArrayList<PasteboardItem> invisiblePasteboardItems = new ArrayList<PasteboardItem>(pasteboardItems);
            invisiblePasteboardItems.removeAll(visiblePasteboardItems);
            return invisiblePasteboardItems;
        }

        @Override
        public List<String> translatablePartNames() throws XMLStreamException, IOException {
            LinkedList<String> partNames = new LinkedList<String>();
            if (!this.events.isEmpty()) {
                partNames.add(DesignMapFragments.DESIGN_MAP);
            }
            partNames.addAll(this.visibleStoryPartNames());
            return partNames;
        }

        @Override
        public List<XMLEvent> events() {
            return this.events;
        }

        @Override
        public void from(ZipEntry zipEntry) throws XMLStreamException, IOException {
            XMLEventReader eventReader = this.zipInputReader.of(zipEntry);
            this.layers.clear();
            this.masterSpreadPartNames.clear();
            this.spreadPartNames.clear();
            this.storyPartNames.clear();
            this.events.clear();
            boolean translatable = false;
            boolean inIndex = false;
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.nextEvent();
                this.events.add(event);
                if (event.isEndElement() && INDEX.equals(event.asEndElement().getName())) {
                    inIndex = false;
                    continue;
                }
                if (!event.isStartElement()) continue;
                StartElement se = event.asStartElement();
                if (DOCUMENT.equals(se.getName())) {
                    this.activeLayerId = se.getAttributeByName(ACTIVE_LAYER).getValue();
                    continue;
                }
                if (GRAPHIC.equals(se.getName())) {
                    this.graphicPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (FONTS.equals(se.getName())) {
                    this.fontsPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (STYLES.equals(se.getName())) {
                    this.stylesPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (PREFERENCES.equals(se.getName())) {
                    this.preferencesPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (TEXT_VARIABLE.equals(se.getName())) {
                    String type = se.getAttributeByName(VARIABLE_TYPE).getValue();
                    if (!CUSTOM_TEXT_TYPE.equals(type) || !this.parameters.getExtractCustomTextVariables()) continue;
                    translatable = true;
                    continue;
                }
                if (TAGS.equals(se.getName())) {
                    this.tagsPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (MAPPING.equals(se.getName())) {
                    this.mappingPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (LAYER.equals(se.getName())) {
                    this.layers.add(new Layer(se.getAttributeByName(ParsingIdioms.SELF).getValue(), Boolean.parseBoolean(se.getAttributeByName(ParsingIdioms.VISIBLE).getValue())));
                    continue;
                }
                if (MASTER_SPREAD.equals(se.getName())) {
                    this.masterSpreadPartNames.add(se.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (SPREAD.equals(se.getName())) {
                    this.spreadPartNames.add(se.getAttributeByName(SRC).getValue());
                    continue;
                }
                if (INDEX.equals(se.getName())) {
                    inIndex = true;
                    continue;
                }
                if (inIndex && this.parameters.getExtractIndexTopics() && TOPIC.equals(se.getName())) {
                    translatable = true;
                    continue;
                }
                if (BACKING_STORY.equals(se.getName())) {
                    this.backingStoryPartName = se.getAttributeByName(SRC).getValue();
                    continue;
                }
                if (!STORY.equals(se.getName())) continue;
                this.storyPartNames.add(se.getAttributeByName(SRC).getValue());
            }
            if (!translatable) {
                this.events.clear();
            }
        }
    }
}

