/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.connectors.microsoft;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.sf.okapi.connectors.microsoft.TranslateRequest;

class GetTranslationsArrayRequest {
    private String category;
    private List<String> texts;
    private String srcLang;
    private String trgLang;
    private int maxHits;

    GetTranslationsArrayRequest(List<String> texts, String srcLang, String trgLang, int maxHits, String category) {
        this.texts = texts;
        this.category = category;
        this.srcLang = srcLang;
        this.trgLang = trgLang;
        this.maxHits = maxHits;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof GetTranslationsArrayRequest)) {
            return false;
        }
        GetTranslationsArrayRequest r = (GetTranslationsArrayRequest)o;
        return Objects.equals(this.category, r.category) && Objects.equals(this.texts, r.texts) && Objects.equals(this.srcLang, r.srcLang) && Objects.equals(this.trgLang, r.trgLang) && Objects.equals(this.maxHits, r.maxHits);
    }

    public int hashCode() {
        return Objects.hash(this.category, this.texts, this.srcLang, this.trgLang, this.maxHits);
    }

    public String toJSON() throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        ArrayList<TranslateRequest> translateRequests = new ArrayList<TranslateRequest>();
        for (String text : this.texts) {
            translateRequests.add(new TranslateRequest(text));
        }
        return objectMapper.writeValueAsString(translateRequests);
    }

    public String toString() {
        try {
            return this.toJSON();
        }
        catch (JsonProcessingException e) {
            return "(deserialization error):" + e.toString();
        }
    }

    public int getNumRequests() {
        return this.texts.size();
    }

    public String getText(int index) {
        return this.texts.get(index);
    }
}

