/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import net.sf.okapi.common.StringUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeComparatorOnCloseType;
import net.sf.okapi.common.resource.CodeComparatorOnData;
import net.sf.okapi.common.resource.CodeComparatorOnId;
import net.sf.okapi.common.resource.CodeComparatorOnIsolated;
import net.sf.okapi.common.resource.CodeComparatorOnTagType;
import net.sf.okapi.common.resource.CodeComparatorOnType;
import net.sf.okapi.common.resource.CodeMatchStrategy;
import net.sf.okapi.common.resource.CodeMatches;
import net.sf.okapi.common.resource.IWithProperties;
import net.sf.okapi.common.resource.InlineAnnotation;
import net.sf.okapi.common.resource.TextFragment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TextFragmentUtil {
    public static final int MAX_INLINE_CODES = 6127;
    public static final CodeComparatorOnData CMP_DATA = new CodeComparatorOnData();
    public static final CodeComparatorOnId CMP_ID = new CodeComparatorOnId();
    public static final CodeComparatorOnTagType CMP_TAG_TYPE = new CodeComparatorOnTagType();
    public static final CodeComparatorOnType CMP_TYPE = new CodeComparatorOnType();
    public static final CodeComparatorOnCloseType CMP_CLOSE_TYPE = new CodeComparatorOnCloseType();
    private static final Logger LOGGER = LoggerFactory.getLogger(TextFragmentUtil.class);

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to, boolean addMissingCodes, boolean forceCopy, CodeMatchStrategy strategy) {
        if (from == null || to == null) {
            return CodeMatches.NO_CODES;
        }
        CodeMatches cm = TextFragmentUtil.synchronizeCodeIds(from, to, strategy);
        if (cm == CodeMatches.SAME_CODES) {
            return cm;
        }
        TextFragmentUtil.copyCodeMetadata(from, to, forceCopy, cm);
        if (addMissingCodes && (cm.hasFromMismatch() || cm.hasToMismatch())) {
            TextFragmentUtil.addMissingCodes(from, to, cm);
        }
        to.invalidate();
        to.balanceMarkers();
        return cm;
    }

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to, boolean addMissingCodes, boolean forceCopy) {
        return TextFragmentUtil.alignAndCopyCodeMetadata(from, to, addMissingCodes, forceCopy, CodeMatchStrategy.STRICT);
    }

    public static void logCodeMismatchErrors(CodeMatches matches, TextFragment from, TextFragment to, String textUnitId) {
        String s;
        String warn;
        if (matches.hasToMismatch()) {
            for (Integer index : matches.getToMismatchIterator()) {
                warn = TextFragmentUtil.buildErrorString(to, index);
                if (warn == null) continue;
                s = StringUtil.substring(to.toText(), 0, 50);
                LOGGER.warn("Can't find matching target Code(s) {} in TU {}\n Segment: \"{}...\"", new Object[]{warn, textUnitId, s});
            }
        }
        if (matches.hasFromMismatch()) {
            for (Integer index : matches.getFromMismatchIterator()) {
                warn = TextFragmentUtil.buildErrorString(from, index);
                if (warn == null) continue;
                s = StringUtil.substring(from.toText(), 0, 50);
                LOGGER.warn("Can't find matching source Code(s) {} in TU {}\n Segment: \"{}...\"", new Object[]{warn, textUnitId, s});
            }
        }
    }

    private static String buildErrorString(TextFragment f, Integer index) {
        int mi;
        Code c = f.getCode(index);
        if (c.isAdded() || c.isDeleteable() || c.isCloneable()) {
            return null;
        }
        StringBuilder error = new StringBuilder(String.format("id='%s' originalId='%s' data='%s'", c.id, c.originalId == null ? "" : c.originalId, TextFragmentUtil.getCodeDataOrSimulate(c)));
        if (c.getTagType() == TextFragment.TagType.OPENING && (mi = f.getIndexForClosing(c.id)) != -1) {
            Code m = f.getCode(mi);
            error.append(String.format(", Closing data='%s'", TextFragmentUtil.getCodeDataOrSimulate(m)));
        }
        return error.toString();
    }

    private static String getCodeDataOrSimulate(Code c) {
        if (!Util.isEmpty(c.getData())) {
            return c.getData();
        }
        StringBuilder b = new StringBuilder();
        switch (c.tagType) {
            case OPENING: {
                b.append("<").append(c.type).append(" id=").append(c.id).append(">");
                break;
            }
            case CLOSING: {
                b.append("</").append(c.type).append(">");
                break;
            }
            case PLACEHOLDER: {
                b.append("<").append(c.type).append(" id=").append(c.id).append("/>");
            }
        }
        return b.toString();
    }

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to) {
        return TextFragmentUtil.alignAndCopyCodeMetadata(from, to, false, false, CodeMatchStrategy.STRICT);
    }

    public static CodeMatches alignAndCopyCodeMetadata(TextFragment from, TextFragment to, boolean addMissingCodes) {
        return TextFragmentUtil.alignAndCopyCodeMetadata(from, to, addMissingCodes, false, CodeMatchStrategy.STRICT);
    }

    public static void addMissingCodes(TextFragment from, TextFragment to, CodeMatches codeMatches) {
        TextFragment leadingCodes = new TextFragment();
        for (Integer index : codeMatches.getFromMismatchIterator()) {
            Code fc = from.codes.get(index);
            if (TextFragmentUtil.isLeadingCode(fc, from)) {
                leadingCodes.append(fc.clone());
            } else {
                to.append(fc.clone());
            }
            codeMatches.setFromMatch(index, CodeMatches.ADDED_MATCH);
        }
        to.insert(0, leadingCodes, true);
    }

    public static boolean isLeadingCode(Code code, TextFragment source) {
        int index = source.codes.indexOf(code);
        if (index == -1) {
            return false;
        }
        String ctext = source.getCodedText();
        int pos = ctext.indexOf(String.valueOf(TextFragment.toChar(index)));
        if (pos == -1) {
            return false;
        }
        String substr = ctext.substring(0, pos - 1);
        return (substr = TextFragment.MARKERS_REGEX.matcher(substr).replaceAll("")).trim().length() == 0;
    }

    @SafeVarargs
    public static int findMatch(Code orig, List<Code> codes, int[] fromMatches, Comparator<Code> ... cmps) {
        int i = -1;
        for (Code c : codes) {
            if (fromMatches[++i] != CodeMatches.NO_MATCH && fromMatches[i] != CodeMatches.ANNOTATION_ONLY || !TextFragmentUtil.compareAll(orig, c, i, cmps)) continue;
            return i;
        }
        return -1;
    }

    @SafeVarargs
    static <T> boolean compareAll(T from, T to, int index, Comparator<T> ... cmps) {
        for (Comparator<T> cmp : cmps) {
            if (cmp instanceof CodeComparatorOnIsolated) {
                ((CodeComparatorOnIsolated)cmp).setFromIndex(index);
            }
            if (cmp.compare(from, to) == 0) continue;
            return false;
        }
        return true;
    }

    public static void copyCodeMetadata(TextFragment sf, TextFragment tf, boolean forceCopy, CodeMatches cm) {
        if (sf == null || tf == null) {
            return;
        }
        if (sf.codes == null || tf.codes == null) {
            return;
        }
        for (int toIndex = 0; toIndex < tf.codes.size(); ++toIndex) {
            Code tc = tf.codes.get(toIndex);
            int fromIndex = cm.getToMatchIndex(toIndex);
            if (fromIndex == CodeMatches.NO_MATCH || fromIndex == CodeMatches.ANNOTATION_ONLY) continue;
            Code sc = sf.codes.get(fromIndex);
            TextFragmentUtil.copyCodeMetadata(sc, tc, forceCopy);
        }
    }

    public static void copyCodeMetadata(Code sc, Code tc, boolean forceCopy) {
        tc.setOuterData(null);
        if (forceCopy || !tc.hasData() || sc.hasReference()) {
            tc.setData(sc.getData());
            tc.setReferenceFlag(sc.hasReference());
        }
        tc.setOuterData(sc.getOuterData());
        tc.setOriginalId(sc.getOriginalId());
        tc.setAdded(sc.isAdded());
        tc.setCloneable(sc.isCloneable());
        tc.setDeleteable(sc.isDeleteable());
        tc.setDisplayText(sc.getDisplayText());
        tc.setFlag(sc.getFlag());
        tc.setMerged(sc.isMerged());
        tc.setMarkerMasking(sc.isMarkerMasking());
        tc.setMergedData(sc.getMergedData());
        tc.setTagType(sc.getTagType());
        tc.setType(sc.getType());
        Set<String> types = sc.getAnnotationsTypes();
        for (String type : types) {
            if ("PROPERTIES".equals(type)) continue;
            InlineAnnotation a = sc.getAnnotation(type);
            tc.setAnnotation(type, a.clone());
        }
        IWithProperties.copy(sc, tc);
    }

    public static CodeMatches synchronizeCodeIds(TextFragment from, TextFragment to, CodeMatchStrategy strategy) {
        if (from == null || to == null) {
            return CodeMatches.NO_CODES;
        }
        if (!from.hasCode() && !to.hasCode()) {
            return CodeMatches.NO_CODES;
        }
        if (from == to) {
            return CodeMatches.SAME_CODES;
        }
        if (from.codes == null) {
            from.setCodes(new ArrayList<Code>());
        }
        if (to.codes == null) {
            to.setCodes(new ArrayList<Code>());
        }
        from.balanceMarkers();
        to.balanceMarkers();
        CodeMatches codeMatches = new CodeMatches(from, to);
        for (int toIndex = 0; toIndex < to.codes.size(); ++toIndex) {
            int fromIndex;
            Code tc = to.codes.get(toIndex);
            if (tc.tagType == TextFragment.TagType.CLOSING && !codeMatches.isToIsolated(toIndex) || (fromIndex = TextFragmentUtil.search(tc, from.codes, codeMatches, strategy)) == -1) continue;
            Code fc = from.codes.get(fromIndex);
            if (tc.tagType == TextFragment.TagType.OPENING && fc.tagType == TextFragment.TagType.OPENING && !codeMatches.isToIsolated(toIndex) && !codeMatches.isFromIsolated(fromIndex)) {
                if (TextFragmentUtil.matchClosing(codeMatches, to, from, toIndex, fromIndex)) continue;
                LOGGER.error("Cannot find matching closing tag. Malformed TextFragment. id={}, originalId={}, data={}", new Object[]{tc.getId(), tc.getOriginalId(), tc.getData()});
                continue;
            }
            codeMatches.setToMatch(toIndex, fromIndex);
            codeMatches.setFromMatch(fromIndex, toIndex);
            tc.setId(fc.id);
        }
        to.invalidate();
        to.balanceMarkers();
        return codeMatches;
    }

    public static CodeMatches synchronizeCodeIds(TextFragment from, TextFragment to) {
        return TextFragmentUtil.synchronizeCodeIds(from, to, CodeMatchStrategy.STRICT);
    }

    static boolean matchClosing(CodeMatches codeMatches, TextFragment to, TextFragment from, int toOpen, int fromOpen) {
        if (fromOpen < 0 || fromOpen >= from.codes.size()) {
            return false;
        }
        Code tc = to.codes.get(toOpen);
        Code fc = from.codes.get(fromOpen);
        int toClose = TextFragmentUtil.findClosing(tc, to.codes, codeMatches.getToMatches());
        int fromClose = TextFragmentUtil.findClosing(fc, from.codes, codeMatches.getFromMatches());
        if (toClose == -1 && fromClose == -1) {
            return false;
        }
        if (toClose == -1) {
            return false;
        }
        if (fromClose == -1) {
            return false;
        }
        Code ctc = to.codes.get(toClose);
        Code cfc = from.codes.get(fromClose);
        tc.setId(fc.getId());
        ctc.setId(cfc.getId());
        codeMatches.setToMatch(toOpen, fromOpen);
        codeMatches.setToMatch(toClose, fromClose);
        codeMatches.setFromMatch(fromOpen, toOpen);
        codeMatches.setFromMatch(fromClose, toClose);
        return true;
    }

    static int findClosing(Code open, List<Code> codes, int[] matches) {
        int close = TextFragmentUtil.findMatch(open, codes, matches, CMP_ID, CMP_TYPE, CMP_CLOSE_TYPE);
        if (close == -1) {
            close = TextFragmentUtil.findMatch(open, codes, matches, CMP_ID, CMP_CLOSE_TYPE);
        }
        return close;
    }

    static int search(Code tc, List<Code> codes, CodeMatches codeMatches, CodeMatchStrategy strategy) {
        if (!codeMatches.hasFromMismatch()) {
            return -1;
        }
        int fromIndex = -1;
        CodeComparatorOnIsolated cmpTagTypeWithIsolated = new CodeComparatorOnIsolated(codeMatches, false);
        switch (strategy) {
            case LAX: {
                fromIndex = TextFragmentUtil.strictSearch(tc, codes, codeMatches, cmpTagTypeWithIsolated);
                if (fromIndex != -1) break;
                fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), cmpTagTypeWithIsolated);
                break;
            }
            case STRICT: {
                fromIndex = TextFragmentUtil.strictSearch(tc, codes, codeMatches, cmpTagTypeWithIsolated);
            }
        }
        return fromIndex;
    }

    static int strictSearch(Code tc, List<Code> codes, CodeMatches codeMatches, CodeComparatorOnIsolated cmpTagTypeWithIsolated) {
        int fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_ID, CMP_TYPE, CMP_TAG_TYPE, CMP_DATA);
        if (fromIndex == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_ID, CMP_TAG_TYPE, CMP_DATA)) == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_DATA, CMP_TAG_TYPE)) == -1 && (fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_ID, CMP_TAG_TYPE)) == -1) {
            fromIndex = TextFragmentUtil.findMatch(tc, codes, codeMatches.getFromMatches(), CMP_DATA, cmpTagTypeWithIsolated);
        }
        return fromIndex;
    }

    public static boolean moreThanMaxCodes(TextFragment tf) {
        List<Code> codes = tf.getCodes();
        return codes.size() > 6127;
    }

    public static TextFragment removeMoreThanMaxCodes(TextFragment tf) {
        int c;
        int i;
        int lastCodeIndex = 0;
        int lastCharIndex = 0;
        String codedText = tf.getCodedText();
        StringBuilder newCodedText = new StringBuilder();
        List<Code> codes = tf.getCodes();
        for (i = 0; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                if (lastCodeIndex > 6126) {
                    lastCharIndex = i - 1;
                    break;
                }
                switch (c) {
                    case 57601: {
                        newCodedText.append("\ue101").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57602: {
                        newCodedText.append("\ue102").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                        break;
                    }
                    case 57603: {
                        newCodedText.append("\ue103").append(codedText.charAt(i + 1));
                        lastCodeIndex = TextFragment.toIndex(codedText.charAt(i + 1));
                        ++i;
                    }
                }
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        for (i = lastCharIndex; i < codedText.length(); ++i) {
            c = codedText.codePointAt(i);
            if (c == 57601 || c == 57602 || c == 57603) {
                ++i;
                continue;
            }
            newCodedText.appendCodePoint(c);
        }
        return new TextFragment(newCodedText.toString(), codes.subList(0, lastCodeIndex + 1));
    }

    public static String toText(TextFragment tf) {
        if (tf.codes == null || tf.codes.size() == 0) {
            return tf.toString();
        }
        if (!tf.isBalanced) {
            tf.balanceMarkers();
        }
        StringBuilder tmp = new StringBuilder();
        block3: for (int i = 0; i < tf.length(); ++i) {
            switch (tf.charAt(i)) {
                case '\ue101': 
                case '\ue102': 
                case '\ue103': {
                    Code code = tf.codes.get(TextFragment.toIndex(tf.charAt(++i)));
                    tmp.append(code.getOuterData());
                    continue block3;
                }
                default: {
                    tmp.append(tf.charAt(i));
                }
            }
        }
        return tmp.toString();
    }
}

