/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TargetPropertiesAnnotation;

public interface IWithTargetProperties {
    public static void copy(IWithTargetProperties from, IWithTargetProperties to) {
        if (from == null || to == null) {
            return;
        }
        for (LocaleId trgLocale : from.getTargetLocales()) {
            for (String propName : from.getTargetPropertyNames(trgLocale)) {
                if (to.hasTargetProperty(trgLocale, propName)) continue;
                to.setTargetProperty(trgLocale, from.getTargetProperty(trgLocale, propName).clone());
            }
        }
    }

    default public Map<String, Property> getTargetProperties(LocaleId locale) {
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            return null;
        }
        Map<String, Property> trgProps = tpa.get(locale);
        return trgProps;
    }

    default public Property createTargetProperty(LocaleId locId, String name, boolean overwriteExisting, int creationOptions) {
        return this.createTargetProperty(locId, name, null, overwriteExisting, creationOptions);
    }

    default public Property createTargetProperty(LocaleId locId, String name, Property sourceProperty, boolean overwriteExisting, int creationOptions) {
        Property trgProp;
        Map<String, Property> trgProps;
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            tpa = new TargetPropertiesAnnotation();
            this.getAnnotations().set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        if ((trgProp = trgProps.get(name)) == null || overwriteExisting) {
            Property srcProp;
            trgProp = creationOptions > 0 ? new Property(name, "", false) : ((srcProp = sourceProperty) == null ? new Property(name, "", false) : srcProp.clone());
            trgProps.put(name, trgProp);
        }
        return trgProp;
    }

    public Annotations getAnnotations();

    default public Set<LocaleId> getTargetLocales() {
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            tpa = new TargetPropertiesAnnotation();
            this.getAnnotations().set(tpa);
        }
        return tpa.getLocales();
    }

    default public Property getTargetProperty(LocaleId locId, String name) {
        if (this.getAnnotations() == null) {
            return null;
        }
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            return null;
        }
        Map<String, Property> trgProps = tpa.get(locId);
        if (trgProps == null) {
            return null;
        }
        return trgProps.get(name);
    }

    default public Set<String> getTargetPropertyNames(LocaleId locId) {
        Map<String, Property> trgProps;
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            tpa = new TargetPropertiesAnnotation();
            this.getAnnotations().set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        return trgProps.keySet();
    }

    default public boolean hasTargetProperty(LocaleId locId, String name) {
        if (this.getAnnotations().isEmpty()) {
            return false;
        }
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            return false;
        }
        Map<String, Property> trgProps = tpa.get(locId);
        if (trgProps == null) {
            return false;
        }
        return trgProps.get(name) != null;
    }

    default public void removeTargetProperty(LocaleId locId, String name) {
        TargetPropertiesAnnotation tpa;
        if (!this.getAnnotations().isEmpty() && (tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class)) != null) {
            Map<String, Property> trgProps = tpa.get(locId);
            trgProps.remove(name);
        }
    }

    default public Property setTargetProperty(LocaleId locId, Property property) {
        Map<String, Property> trgProps;
        TargetPropertiesAnnotation tpa = this.getAnnotations().get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            tpa = new TargetPropertiesAnnotation();
            this.getAnnotations().set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        trgProps.put(property.getName(), property);
        return property;
    }
}

