/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.pipelinebuilder;

import java.net.URL;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.ParametersString;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipelinebuilder.XParameter;

public class XPipelineStep
implements IPipelineStep {
    private IPipelineStep step;
    private ParametersString parametersString = new ParametersString();

    public XPipelineStep(IPipelineStep step, IParameters parameters) {
        this(step);
        step.setParameters(parameters);
    }

    @Deprecated
    public XPipelineStep(IPipelineStep step) {
        this.step = step;
    }

    public XPipelineStep(IPipelineStep step, XParameter ... parameters) {
        this(step);
        if (step == null) {
            return;
        }
        IParameters params = step.getParameters();
        if (params != null) {
            this.parametersString.fromString(params.toString());
        }
        for (XParameter parameter : parameters) {
            if (parameter.getType() == null) {
                Object value = parameter.getValue();
                if (value instanceof Integer) {
                    this.parametersString.setParameter(parameter.getName(), (Integer)Integer.class.cast(value));
                    continue;
                }
                if (value instanceof Boolean) {
                    this.parametersString.setParameter(parameter.getName(), (Boolean)Boolean.class.cast(value));
                    continue;
                }
                if (!(value instanceof String)) continue;
                if (parameter.isAsGroup()) {
                    this.parametersString.setGroup(parameter.getName(), (String)String.class.cast(value));
                    continue;
                }
                this.parametersString.setParameter(parameter.getName(), (String)String.class.cast(value));
                continue;
            }
            switch (parameter.getType()) {
                default: 
            }
        }
        if (params != null) {
            params.fromString(this.parametersString.toString());
        }
    }

    public XPipelineStep(Class<? extends IPipelineStep> stepClass, IParameters parameters) {
        this.step = XPipelineStep.instantiateStep(stepClass);
        this.step.setParameters(parameters);
    }

    public XPipelineStep(Class<? extends IPipelineStep> stepClass, XParameter ... parameters) {
        this(XPipelineStep.instantiateStep(stepClass), parameters);
    }

    private static IPipelineStep instantiateStep(Class<? extends IPipelineStep> stepClass) {
        IPipelineStep res = null;
        try {
            res = ClassUtil.instantiateClass(stepClass);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            // empty catch block
        }
        return res;
    }

    public XPipelineStep(IPipelineStep step, URL parametersURL, boolean ignoreErrors) {
        this.step = step;
        IParameters params = step.getParameters();
        params.load(parametersURL, ignoreErrors);
    }

    public XPipelineStep(Class<? extends IPipelineStep> stepClass, URL parametersURL, boolean ignoreErrors) {
        this.step = XPipelineStep.instantiateStep(stepClass);
        IParameters params = this.step.getParameters();
        params.load(parametersURL, ignoreErrors);
    }

    @Override
    public String getDescription() {
        return this.step.getDescription();
    }

    @Override
    public String getName() {
        return this.step.getName();
    }

    @Override
    public void destroy() {
        this.step.destroy();
    }

    @Override
    public String getHelpLocation() {
        return this.step.getHelpLocation();
    }

    @Override
    public IParameters getParameters() {
        return this.step.getParameters();
    }

    @Override
    public Event handleEvent(Event event) {
        return this.step.handleEvent(event);
    }

    @Override
    public boolean isDone() {
        return this.step.isDone();
    }

    @Override
    public boolean isLastOutputStep() {
        return this.step.isLastOutputStep();
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.step.setLastOutputStep(isLastStep);
    }

    @Override
    public void setParameters(IParameters params) {
        this.step.setParameters(params);
    }

    public IPipelineStep getStep() {
        return this.step;
    }

    @Override
    public void cancel() {
    }
}

