/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.observer;

import java.lang.ref.WeakReference;
import net.sf.okapi.common.observer.BaseObservable;
import net.sf.okapi.common.observer.IObservable;
import net.sf.okapi.common.observer.IObserver;

public class WeakReferenceObservable
extends BaseObservable {
    public WeakReferenceObservable(IObservable observable) {
        super(observable);
    }

    @Override
    public void addObserver(IObserver observer) {
        super.addObserver(new WeakReferenceObserver(observer));
    }

    @Override
    public void deleteObserver(IObserver observer) {
        for (IObserver weakObserver : this.getObservers()) {
            WeakReferenceObserver weakReference = (WeakReferenceObserver)weakObserver;
            IObserver o = (IObserver)weakReference.get();
            if (o != null && !o.equals(observer)) continue;
            this.deleteWeakReference(weakReference);
        }
    }

    private void deleteWeakReference(WeakReferenceObserver observer) {
        super.deleteObserver(observer);
    }

    private class WeakReferenceObserver
    extends WeakReference<IObserver>
    implements IObserver {
        public WeakReferenceObserver(IObserver referent) {
            super(referent);
        }

        @Override
        public void update(IObservable o, Object arg) {
            IObserver referent = (IObserver)this.get();
            if (referent != null) {
                referent.update(o, arg);
            } else {
                WeakReferenceObservable.this.deleteWeakReference(this);
            }
        }
    }
}

