/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.filters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.AbstractFilter;
import net.sf.okapi.common.filters.CompoundFilterParameters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCompoundFilter
extends AbstractFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LinkedList<IFilter> siblingFilters = new LinkedList();
    private IFilter activeSiblingFilter = null;
    private RawDocument input;

    public IFilter getActiveSiblingFilter() {
        return this.activeSiblingFilter;
    }

    protected void setActiveSiblingFilter(IFilter activeSiblingFilter) {
        this.activeSiblingFilter = activeSiblingFilter;
        IParameters params = this.getParameters();
        if (params instanceof CompoundFilterParameters && activeSiblingFilter instanceof AbstractFilter) {
            ((CompoundFilterParameters)params).setActiveParameters(((AbstractFilter)activeSiblingFilter).getParametersClassName());
        }
    }

    protected <A extends IFilter> boolean addSiblingFilter(Class<A> subFilterClass) {
        if (this.siblingFilters == null) {
            return false;
        }
        boolean res = false;
        IFilter curSiblingFilter = null;
        try {
            Constructor<A> cc = subFilterClass.getConstructor(new Class[0]);
            if (cc == null) {
                return false;
            }
            curSiblingFilter = (IFilter)cc.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.logger.debug("siblingfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        res = this.siblingFilters.add(curSiblingFilter);
        if (!res) {
            return false;
        }
        curSiblingFilter = this.siblingFilters.getLast();
        if (curSiblingFilter == null) {
            return false;
        }
        this.addConfigurations(curSiblingFilter.getConfigurations());
        if (this.activeSiblingFilter == null) {
            this.activeSiblingFilter = curSiblingFilter;
        }
        return res;
    }

    public IParameters getActiveParameters() {
        return this.activeSiblingFilter != null ? this.activeSiblingFilter.getParameters() : null;
    }

    private String getDefaultConfigId() {
        if (Util.isEmpty(this.configList)) {
            return "";
        }
        FilterConfiguration config = (FilterConfiguration)this.configList.get(0);
        if (config == null) {
            return "";
        }
        return config.configId;
    }

    public boolean setConfiguration(String configId) {
        IParameters params2;
        FilterConfiguration config;
        IFilter subFilter;
        boolean res = true;
        if (Util.isEmpty(configId)) {
            configId = this.getDefaultConfigId();
        }
        if ((res &= (subFilter = this.findConfigProvider(configId)) != null) && this.activeSiblingFilter != subFilter) {
            this.setActiveSiblingFilter(subFilter);
        }
        if ((config = this.findConfiguration(configId)) == null) {
            return res;
        }
        IParameters params = this.getParameters();
        if (config.parametersLocation != null && params instanceof CompoundFilterParameters) {
            URL url = this.getClass().getResource(config.parametersLocation);
            params.load(url, false);
        }
        if ((params2 = this.getActiveParameters()) != null) {
            params2.fromString(params.toString());
        }
        return res;
    }

    private IFilter findConfigProvider(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return this.findSiblingFilter(config.filterClass);
        }
        return null;
    }

    private IFilter findSiblingFilter(String filterClass) {
        if (Util.isEmpty(filterClass)) {
            return null;
        }
        if (this.siblingFilters == null) {
            return null;
        }
        for (IFilter subFilter : this.siblingFilters) {
            if (subFilter == null || subFilter.getClass() == null || !subFilter.getClass().getName().equalsIgnoreCase(filterClass)) continue;
            return subFilter;
        }
        return null;
    }

    private IFilter findSiblingFilterByParameters(String parametersClassName) {
        if (Util.isEmpty(parametersClassName)) {
            return null;
        }
        if (this.siblingFilters == null) {
            return null;
        }
        for (IFilter subFilter : this.siblingFilters) {
            if (!(subFilter instanceof AbstractFilter) || !((AbstractFilter)subFilter).getParametersClassName().equalsIgnoreCase(parametersClassName)) continue;
            return subFilter;
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.activeSiblingFilter != null) {
            this.activeSiblingFilter.cancel();
        }
    }

    @Override
    public void setParameters(IParameters params) {
        super.setParameters(params);
        if (params == null && this.activeSiblingFilter != null) {
            this.activeSiblingFilter.setParameters(null);
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.activeSiblingFilter != null) {
            this.activeSiblingFilter.close();
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.activeSiblingFilter != null ? this.activeSiblingFilter.createFilterWriter() : null;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.activeSiblingFilter != null ? this.activeSiblingFilter.createSkeletonWriter() : null;
    }

    @Override
    public boolean hasNext() {
        return this.activeSiblingFilter != null ? this.activeSiblingFilter.hasNext() : false;
    }

    @Override
    public Event next() {
        Event event;
        Event event2 = event = this.activeSiblingFilter != null ? this.activeSiblingFilter.next() : null;
        if (event != null && event.getEventType() == EventType.START_DOCUMENT) {
            StartDocument startDoc = (StartDocument)event.getResource();
            startDoc.setFilterId(this.getName());
            startDoc.setFilterParameters(this.getParameters());
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.input = input;
        if (this.activeSiblingFilter != null) {
            this.activeSiblingFilter.open(input);
        }
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (this.activeSiblingFilter != null) {
            this.activeSiblingFilter.open(input, generateSkeleton);
        }
    }

    protected void updateSiblingFilters() {
        IParameters params = this.getParameters();
        String className = "";
        if (!(params instanceof CompoundFilterParameters)) {
            return;
        }
        className = ((CompoundFilterParameters)params).getParametersClassName();
        if (Util.isEmpty(className)) {
            return;
        }
        this.activeSiblingFilter = this.findSiblingFilterByParameters(className);
        IParameters params2 = this.getActiveParameters();
        if (params2 != null && params != null) {
            params2.fromString(params.toString());
        }
        if (this.activeSiblingFilter != null) {
            this.activeSiblingFilter.setParameters(params2);
        }
    }
}

