/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;

public final class FileUtil {
    private static final Pattern pattern = Pattern.compile("\\s(srclang|source-?language|xml:lang|lang|trglang|(target)?locale|(target-?)?language)\\s*?=\\s*?['\"](.*?)['\"]", 2);
    private static final Pattern XLIFF_SEGMENTATION_PATTERN = Pattern.compile("<\\s*seg-source\\s*>", 2);

    public static Collection<File> getFilteredFiles(File directory, FilenameFilter filter, boolean recurse) {
        LinkedList<File> files = new LinkedList<File>();
        File[] entries = directory.listFiles();
        if (entries == null) {
            return files;
        }
        for (File entry : entries) {
            if (filter == null || filter.accept(directory, entry.getName())) {
                files.add(entry);
            }
            if (!recurse || !entry.isDirectory()) continue;
            files.addAll(FileUtil.getFilteredFiles(entry, filter, recurse));
        }
        return files;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static List<String> guessLanguages(String path) {
        InputStreamReader reader = null;
        String encoding = Charset.defaultCharset().name();
        try (FileInputStream fis = new FileInputStream(path);){
            List<String> list;
            try (BOMAwareInputStream bis = new BOMAwareInputStream(fis, encoding);){
                encoding = bis.detectEncoding();
                reader = new InputStreamReader((InputStream)fis, encoding);
                list = FileUtil.guessLanguages(reader);
            }
            return list;
        }
        catch (Exception e) {
            throw new OkapiException("Error while trying to guess language information.\n" + e.getLocalizedMessage());
        }
    }

    public static List<String> guessLanguages(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            int BYTES_TO_SCAN = 102400;
            char[] buffer = new char[102400];
            String trgValue = null;
            int readCount = reader.read(buffer, 0, 102400);
            if (readCount <= 0) {
                ArrayList<String> arrayList = list;
                return arrayList;
            }
            String line = new String(buffer, 0, readCount);
            Matcher m = pattern.matcher(line);
            while (m.find()) {
                String lang = m.group(4).toLowerCase();
                if (lang.isEmpty()) continue;
                String name = m.group(1).toLowerCase();
                if ((name.equals("language") || name.startsWith("target") || name.equals("trglang")) && list.isEmpty()) {
                    trgValue = lang;
                    continue;
                }
                if (!list.contains(lang)) {
                    list.add(lang);
                }
                if (trgValue != null) {
                    list.add(trgValue);
                    trgValue = null;
                }
                if (list.size() <= 1) continue;
                break;
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error while trying to guess language information.\n" + e.getLocalizedMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return list;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean isXliffSegmented(String path) {
        InputStreamReader reader = null;
        String encoding = Charset.defaultCharset().name();
        try (FileInputStream fis = new FileInputStream(path);){
            boolean bl;
            try (BOMAwareInputStream bis = new BOMAwareInputStream(fis, encoding);){
                encoding = bis.detectEncoding();
                reader = new InputStreamReader((InputStream)fis, encoding);
                bl = FileUtil.isXliffSegmented(reader);
            }
            return bl;
        }
        catch (Exception e) {
            throw new OkapiException("Error while trying to find xliff seg-source.\n" + e.getLocalizedMessage());
        }
    }

    public static boolean isXliffSegmented(Reader reader) {
        try {
            int BYTES_TO_SCAN = 10240;
            char[] buffer = new char[10240];
            int readCount = reader.read(buffer, 0, 10240);
            if (readCount <= 0) {
                boolean bl = false;
                return bl;
            }
            String line = new String(buffer, 0, readCount);
            Matcher m = XLIFF_SEGMENTATION_PATTERN.matcher(line);
            if (m.find()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Throwable e) {
            throw new OkapiException("Error while trying to find xliff seg-source.\n" + e.getLocalizedMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void deleteAllFilesInDirectory(String directoryPath) {
        File directory = new File(directoryPath);
        File[] files = directory.listFiles();
        if (files == null) {
            throw new OkapiIOException("Error finding directory: " + directoryPath);
        }
        for (File file : files) {
            if (file.delete()) continue;
            throw new OkapiIOException("Error deleting file: " + file.getPath());
        }
    }

    public static String getLocaleBasedFile(String baseName, final String extension, LocaleId locale) {
        ResourceBundle.Control control = new ResourceBundle.Control(){
            private String resourceFound = null;

            @Override
            public List<String> getFormats(String baseName) {
                return Arrays.asList(extension);
            }

            @Override
            public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) {
                String bundleName = this.toBundleName(baseName, locale);
                String resourceName = this.toResourceName(bundleName, format);
                URL r = loader.getResource(resourceName);
                if (r != null) {
                    this.resourceFound = new File(Util.URLtoURI(r)).getPath();
                    return new ResourceBundle(){

                        @Override
                        public Enumeration<String> getKeys() {
                            return null;
                        }

                        @Override
                        protected Object handleGetObject(String key) {
                            return null;
                        }
                    };
                }
                return null;
            }

            public String toString() {
                return this.resourceFound;
            }
        };
        ResourceBundle.clearCache();
        ResourceBundle.getBundle(baseName, locale.toJavaLocale(), control);
        return control.toString();
    }

    public static String getPartBeforeFile(URI uri) {
        String tmp = uri.toString();
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return uri.toString();
        }
        return tmp.substring(0, n + 1);
    }

    public static File createTempFile(String prefix, String extension) {
        try {
            return File.createTempFile(prefix, extension);
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot create temporary file.", e);
        }
    }

    public static File createTempFile(String prefix) {
        return FileUtil.createTempFile(prefix, ".tmp");
    }

    public static boolean deleteFile(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return false;
        }
        try {
            return Files.deleteIfExists(Paths.get(fileName, new String[0]));
        }
        catch (IOException e) {
            throw new OkapiIOException("Cannot delete file.", e);
        }
    }

    public static URL fileToUrl(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OkapiException(e);
        }
    }

    public static File urlToFile(URL url) {
        try {
            return new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new OkapiException(e);
        }
    }
}

