/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.its;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.DataCategory;
import net.sf.okapi.lib.xliff2.its.IITSItem;

public abstract class DataCategoryGroup<T extends DataCategory>
implements IITSItem {
    private List<T> list = new ArrayList<T>();
    private String id;

    public DataCategoryGroup(String id) {
        this.id = id == null ? UUID.randomUUID().toString() : id;
    }

    @Override
    public boolean isGroup() {
        return true;
    }

    @Override
    public boolean hasUnresolvedGroup() {
        return false;
    }

    public String getGroupId() {
        return this.id;
    }

    public void setGroupId(String id) {
        this.id = id;
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public void setAnnotatorRef(String annotatorRef) {
        for (DataCategory item : this.list) {
            item.setAnnotatorRef(annotatorRef);
        }
    }

    @Override
    public void setAnnotatorRef(AnnotatorsRef ar) {
        for (DataCategory item : this.list) {
            item.setAnnotatorRef(ar);
        }
    }

    @Override
    public String getAnnotatorRef() {
        throw new UnsupportedOperationException("Data category groups do not support the getAnnotatorRef() method.");
    }

    @Override
    public void validate() {
        for (DataCategory item : this.list) {
            item.validate();
        }
    }
}

