/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.lib.verification.BlackTerm;
import net.sf.okapi.lib.verification.BlacklistReader;

class BlacklistTB {
    private List<BlackTerm> entries;
    private LocaleId locale = new LocaleId(Locale.getDefault());

    public BlacklistTB() {
        this.reset();
    }

    public BlacklistTB(LocaleId loc) {
        this();
        this.locale = loc;
    }

    private void reset() {
        this.entries = new ArrayList<BlackTerm>();
    }

    public void guessAndImport(File file) {
        String ext = Util.getExtension(file.getPath());
        if (!ext.equalsIgnoreCase(".xyz")) {
            this.importTSV(file);
        }
    }

    public void removeAll() {
        this.entries.clear();
    }

    public List<BlackTerm> getBlacklistStrings() {
        return this.entries;
    }

    private void importTSV(File file) {
        this.importBlacklist(new BlacklistReader(this.locale), file);
    }

    private void importBlacklist(BlacklistReader reader, File file) {
        try {
            reader.open(file);
            this.importBlacklist(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void importBlacklist(BlacklistReader reader, InputStream input) {
        try {
            reader.open(input);
            this.importBlacklist(reader);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void importBlacklist(BlacklistReader reader) {
        while (reader.hasNext()) {
            BlackTerm bterm = reader.next();
            this.entries.add(bterm);
        }
    }

    void loadBlacklistStream(InputStream input) {
        if (input != null) {
            this.importBlacklist(new BlacklistReader(this.locale), input);
        }
    }
}

