/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.preprocessing.filters.simplification;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiBadFilterParametersException;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.filters.xmlstream.XmlStreamFilter;
import net.sf.okapi.lib.preprocessing.filters.common.PreprocessingFilter;
import net.sf.okapi.lib.preprocessing.filters.simplification.Parameters;
import net.sf.okapi.steps.common.ResourceSimplifierStep;
import net.sf.okapi.steps.common.codesimplifier.CodeSimplifierStep;

@UsingParameters(value=Parameters.class)
public class SimplificationFilter
extends PreprocessingFilter {
    private Parameters params = new Parameters();
    private IFilterConfigurationMapper fcMapper;

    public SimplificationFilter() {
        super(new XmlStreamFilter(), new ResourceSimplifierStep(), new CodeSimplifierStep());
        this.setParameters(this.params);
    }

    @Override
    public String getName() {
        return "okf_simplification";
    }

    @Override
    public String getDisplayName() {
        return "Simplification Filter";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "text/xml", this.getClass().getName(), "XML (Simplified resources and codes)", "Configuration for extracting resources from an XML file. Resources and then codes are simplified.", "xml.fprm", ".xml;"));
        list.add(new FilterConfiguration(this.getName() + "-xmlResources", "text/xml", this.getClass().getName(), "XML (Simplified resources)", "Configuration for extracting resources from an XML file. Resources are simplified.", "xml_resources.fprm", ".xml;"));
        list.add(new FilterConfiguration(this.getName() + "-xmlCodes", "text/xml", this.getClass().getName(), "XML (Simplified codes)", "Configuration for extracting resources from an XML file. Codes are simplified.", "xml_codes.fprm", ".xml;"));
        return list;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (this.params == null) {
            throw new OkapiBadFilterParametersException("Filter parameters are not specified");
        }
        if (Util.isEmpty(this.params.getFilterConfigId())) {
            throw new OkapiBadFilterParametersException("Filter config ID is not specified in filter parameters");
        }
        if (this.fcMapper == null) {
            this.fcMapper = new FilterConfigurationMapper();
            DefaultFilters.setMappings(this.fcMapper, true, true);
        }
        if (this.fcMapper == null) {
            throw new OkapiException("Filter Configuration Mapper is not set, cannot proceed");
        }
        IFilter newFilter = this.fcMapper.createFilter(this.params.getFilterConfigId());
        if (newFilter == null) {
            throw new OkapiBadFilterParametersException("Cannot create a filter for the filter config ID specified in filter parameters");
        }
        this.setFilter(newFilter);
        this.getSteps().clear();
        if (this.params.isSimplifyResources()) {
            this.getSteps().add(new ResourceSimplifierStep());
        }
        if (this.params.isSimplifyCodes()) {
            this.getSteps().add(new CodeSimplifierStep());
        }
        super.open(input, generateSkeleton);
    }
}

