/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.filters.openxml.Cell;
import net.sf.okapi.filters.openxml.Cells;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.StartElementContext;
import net.sf.okapi.filters.openxml.StartElementContextFactory;
import net.sf.okapi.filters.openxml.StringItem;
import net.sf.okapi.filters.openxml.StringItemParser;
import net.sf.okapi.filters.openxml.StyleDefinitions;
import net.sf.okapi.filters.openxml.StyleOptimisation;
import net.sf.okapi.filters.openxml.XMLEventsReader;

interface SharedStrings {
    public static final String SST = "sst";
    public static final String SI = "si";

    public StartDocument startDocument();

    public StartElement startElement();

    public StringItem stringItemFor(int var1);

    public EndElement endElement();

    public EndDocument endDocument();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public void addFrom(Cells var1) throws XMLStreamException;

    public static final class Default
    implements SharedStrings {
        private final ConditionalParameters conditionalParameters;
        private final XMLEventFactory eventFactory;
        private final IdGenerator nestedBlockId;
        private final StyleDefinitions styleDefinitions;
        private final StyleOptimisation styleOptimisation;
        private final List<StringItem> stringItems;
        private StartDocument startDocument;
        private StartElement startElement;
        private EndElement endElement;
        private EndDocument endDocument;

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, IdGenerator nestedBlockId, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation) {
            this(conditionalParameters, eventFactory, nestedBlockId, styleDefinitions, styleOptimisation, new LinkedList<StringItem>());
        }

        Default(ConditionalParameters conditionalParameters, XMLEventFactory eventFactory, IdGenerator nestedBlockId, StyleDefinitions styleDefinitions, StyleOptimisation styleOptimisation, List<StringItem> stringItems) {
            this.conditionalParameters = conditionalParameters;
            this.eventFactory = eventFactory;
            this.nestedBlockId = nestedBlockId;
            this.styleDefinitions = styleDefinitions;
            this.styleOptimisation = styleOptimisation;
            this.stringItems = stringItems;
        }

        @Override
        public StartDocument startDocument() {
            return this.startDocument;
        }

        @Override
        public StartElement startElement() {
            return this.startElement;
        }

        @Override
        public StringItem stringItemFor(int index) {
            StringItem si = this.stringItems.get(index);
            if (null == si) {
                throw new IllegalArgumentException("The requested string item is not available: ".concat(String.valueOf(index)));
            }
            return si;
        }

        @Override
        public EndElement endElement() {
            return this.endElement;
        }

        @Override
        public EndDocument endDocument() {
            return this.endDocument;
        }

        @Override
        public void readWith(XMLEventReader eventReader) throws XMLStreamException {
            while (eventReader.hasNext()) {
                XMLEvent e = eventReader.nextEvent();
                if (e.isEndDocument()) {
                    this.endDocument = (EndDocument)e;
                    break;
                }
                if (e.isStartDocument()) {
                    this.startDocument = (StartDocument)e;
                    continue;
                }
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    continue;
                }
                if (e.isStartElement() && SharedStrings.SST.equals(e.asStartElement().getName().getLocalPart())) {
                    this.startElement = this.eventFactory.createStartElement(e.asStartElement().getName(), null, e.asStartElement().getNamespaces());
                    continue;
                }
                if (!e.isStartElement() || !SharedStrings.SI.equals(e.asStartElement().getName().getLocalPart())) continue;
                StartElementContext sec = StartElementContextFactory.createStartElementContext(e.asStartElement(), eventReader, this.eventFactory, this.conditionalParameters);
                StringItem stringItem = new StringItemParser(sec, this.nestedBlockId, this.styleDefinitions, this.styleOptimisation).parse();
                stringItem.optimiseStyles();
                this.stringItems.add(stringItem);
            }
        }

        @Override
        public void addFrom(Cells cells) throws XMLStreamException {
            StartElement startElement = this.eventFactory.createStartElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), SharedStrings.SI);
            EndElement endElement = this.eventFactory.createEndElement(this.startElement.getName().getPrefix(), this.startElement.getName().getNamespaceURI(), SharedStrings.SI);
            ListIterator<Cell> iterator = cells.iterator();
            while (iterator.hasNext()) {
                Cell cell = (Cell)iterator.next();
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>(cell.inlineStringEvents().size() + 1);
                events.addAll(cell.inlineStringEvents());
                events.add(endElement);
                XMLEventsReader eventReader = new XMLEventsReader(events);
                StringItem stringItem = new StringItemParser(StartElementContextFactory.createStartElementContext(startElement, eventReader, this.eventFactory, this.conditionalParameters), this.nestedBlockId, this.styleDefinitions, this.styleOptimisation).parse();
                stringItem.optimiseStyles();
                int lastIndex = this.stringItems.size();
                this.stringItems.add(stringItem);
                cell.value().updateFormer(this.eventFactory.createCharacters(String.valueOf(lastIndex)));
            }
        }
    }
}

