/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.LinkedList;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.ExcelColor;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface PatternFill {
    public static final String NAME = "patternFill";

    public ExcelColor backgroundColor();

    public ExcelColor foregroundColor();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Default
    implements PatternFill {
        private final StartElement startElement;
        private ExcelColor backgroundColor;
        private ExcelColor foregroundColor;
        private EndElement endElement;

        Default(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public ExcelColor backgroundColor() {
            if (null == this.backgroundColor) {
                this.backgroundColor = new ExcelColor.Empty();
            }
            return this.backgroundColor;
        }

        @Override
        public ExcelColor foregroundColor() {
            if (null == this.foregroundColor) {
                this.foregroundColor = new ExcelColor.Empty();
            }
            return this.foregroundColor;
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (e.isEndElement() && e.asEndElement().getName().equals(this.startElement.getName())) {
                    this.endElement = e.asEndElement();
                    break;
                }
                if (!e.isStartElement()) continue;
                StartElement se = e.asStartElement();
                if ("bgColor".equals(se.getName().getLocalPart())) {
                    this.backgroundColor = new ExcelColor.Default(se);
                    this.backgroundColor.readWith(reader);
                    continue;
                }
                if (!"fgColor".equals(se.getName().getLocalPart())) continue;
                this.foregroundColor = new ExcelColor.Default(se);
                this.foregroundColor.readWith(reader);
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            MarkupBuilder mb = new MarkupBuilder(new Markup.General(new LinkedList<MarkupComponent>()));
            mb.add(this.startElement);
            mb.add(this.foregroundColor().asMarkup());
            mb.add(this.backgroundColor().asMarkup());
            mb.add(this.endElement);
            return mb.build();
        }
    }

    public static final class Empty
    implements PatternFill {
        @Override
        public ExcelColor backgroundColor() {
            return new ExcelColor.Empty();
        }

        @Override
        public ExcelColor foregroundColor() {
            return new ExcelColor.Empty();
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }
    }
}

