/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupComponent;

interface NumberFormat {
    public static final String NAME = "numFmt";

    public int id();

    public boolean dateTimeBased();

    public DateTimeFormatter dateTimeFormatter();

    public void readWith(XMLEventReader var1) throws XMLStreamException;

    public Markup asMarkup();

    public static final class Explicit
    implements NumberFormat {
        private static final String EMPTY = "";
        private static final Set<String> dateCodes = new HashSet<String>(Arrays.asList("d", "m", "yy"));
        private static final Set<String> timeCodes = new HashSet<String>(Arrays.asList("h", "m", "s"));
        private static final String NUM_FMT_ID = "numFmtId";
        private static final String FORMAT_CODE = "formatCode";
        private final StartElement startElement;
        private int id;
        private String value;
        private EndElement endElement;
        private boolean startElementAttributesRead;

        Explicit(StartElement startElement) {
            this.startElement = startElement;
        }

        @Override
        public int id() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return this.id;
        }

        @Override
        public boolean dateTimeBased() {
            if (!this.startElementAttributesRead) {
                this.readStartElementAttributes();
            }
            return dateCodes.stream().anyMatch(c -> this.value.contains((CharSequence)c)) || timeCodes.stream().anyMatch(c -> this.value.contains((CharSequence)c));
        }

        private void readStartElementAttributes() {
            Iterator<Attribute> iterator = this.startElement.getAttributes();
            while (iterator.hasNext()) {
                Attribute a = iterator.next();
                switch (a.getName().getLocalPart()) {
                    case "numFmtId": {
                        this.id = Integer.parseUnsignedInt(a.getValue());
                        break;
                    }
                    case "formatCode": {
                        this.value = a.getValue();
                    }
                }
            }
            this.startElementAttributesRead = true;
        }

        @Override
        public DateTimeFormatter dateTimeFormatter() {
            boolean dateAvailable = dateCodes.stream().anyMatch(c -> this.value.contains((CharSequence)c));
            boolean timeAvailable = timeCodes.stream().anyMatch(c -> this.value.contains((CharSequence)c));
            if (dateAvailable && timeAvailable) {
                return DateTimeFormatter.ISO_DATE_TIME;
            }
            if (dateAvailable) {
                return DateTimeFormatter.ISO_DATE;
            }
            if (timeAvailable) {
                return DateTimeFormatter.ISO_TIME;
            }
            return DateTimeFormatter.ofPattern(EMPTY);
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
            while (reader.hasNext()) {
                XMLEvent e = reader.nextEvent();
                if (!e.isEndElement() || !e.asEndElement().getName().equals(this.startElement.getName())) continue;
                this.endElement = e.asEndElement();
                break;
            }
        }

        @Override
        public Markup asMarkup() {
            if (null == this.endElement) {
                throw new IllegalStateException("The end element is not available");
            }
            Markup.General markup = new Markup.General(new LinkedList<MarkupComponent>());
            markup.addComponent(new MarkupComponent.General(Arrays.asList(this.startElement, this.endElement)));
            return markup;
        }
    }

    public static final class BuiltIn
    implements NumberFormat {
        static final Set<Integer> ids = new HashSet<Integer>();
        private static final Map<Integer, String> dateOrTimeCodes;
        static final int GENERAL_ID = 0;
        static final String GENERAL_VALUE = "";
        static final BuiltIn GENERAL;
        private final int id;

        BuiltIn(int id) {
            this.id = id;
        }

        @Override
        public int id() {
            return this.id;
        }

        @Override
        public boolean dateTimeBased() {
            return dateOrTimeCodes.containsKey(this.id);
        }

        @Override
        public DateTimeFormatter dateTimeFormatter() {
            if (dateOrTimeCodes.containsKey(this.id)) {
                return DateTimeFormatter.ofPattern(dateOrTimeCodes.get(this.id));
            }
            return DateTimeFormatter.ofPattern(GENERAL_VALUE);
        }

        @Override
        public void readWith(XMLEventReader reader) throws XMLStreamException {
        }

        @Override
        public Markup asMarkup() {
            return new Markup.Empty();
        }

        static {
            ids.addAll(IntStream.rangeClosed(0, 4).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(9, 22).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(37, 40).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(45, 49).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(27, 36).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(50, 58).boxed().collect(Collectors.toSet()));
            ids.addAll(IntStream.rangeClosed(59, 81).boxed().collect(Collectors.toSet()));
            dateOrTimeCodes = new HashMap<Integer, String>();
            dateOrTimeCodes.put(14, "MM-dd-yy");
            dateOrTimeCodes.put(15, "d-MM-yy");
            dateOrTimeCodes.put(16, "d-MM");
            dateOrTimeCodes.put(17, "MM-yy");
            dateOrTimeCodes.put(18, "H:mm a");
            dateOrTimeCodes.put(19, "H:mm:ss a");
            dateOrTimeCodes.put(20, "H:mm");
            dateOrTimeCodes.put(21, "H:mm:ss");
            dateOrTimeCodes.put(22, "M/d/yy H:mm");
            dateOrTimeCodes.put(45, "mm:ss");
            dateOrTimeCodes.put(47, "mmss.S");
            GENERAL = new BuiltIn(0);
        }
    }
}

