/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.filters.openxml.Block;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.Markup;
import net.sf.okapi.filters.openxml.MarkupBuilder;
import net.sf.okapi.filters.openxml.MarkupComponent;
import net.sf.okapi.filters.openxml.MarkupComponentFactory;
import net.sf.okapi.filters.openxml.MarkupZipSkeleton;
import net.sf.okapi.filters.openxml.NonTranslatablePart;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitions;
import net.sf.okapi.filters.openxml.PowerpointStyleDefinitionsReader;
import net.sf.okapi.filters.openxml.StrippableAttributes;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ModifiablePart
extends NonTranslatablePart {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final Document.General generalDocument;
    private final ZipEntry entry;
    private final InputStream inputStream;
    private StrippableAttributes drawingDirectionStrippableAttributes;

    ModifiablePart(Document.General generalDocument, ZipEntry entry, InputStream inputStream) {
        this.generalDocument = generalDocument;
        this.entry = entry;
        this.inputStream = inputStream;
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.drawingDirectionStrippableAttributes = new StrippableAttributes.DrawingDirection(this.generalDocument.eventFactory());
        XMLEventReader xmlEventReader = this.generalDocument.inputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.inputStream), StandardCharsets.UTF_8));
        return this.open(xmlEventReader);
    }

    private Event open(XMLEventReader xmlEventReader) throws XMLStreamException {
        DocumentPart documentPart;
        try {
            documentPart = this.handlePart(xmlEventReader);
        }
        finally {
            if (null != xmlEventReader) {
                xmlEventReader.close();
            }
        }
        return new Event(EventType.DOCUMENT_PART, documentPart);
    }

    private DocumentPart handlePart(XMLEventReader xmlEventReader) throws XMLStreamException {
        MarkupBuilder markupBuilder = new MarkupBuilder(new Block.Markup(new Markup.General(new ArrayList<MarkupComponent>())));
        while (xmlEventReader.hasNext()) {
            XMLEvent event = xmlEventReader.nextEvent();
            if (XMLEventHelpers.isPresentationStartEvent(event)) {
                markupBuilder.add(new MarkupComponent.Start(this.generalDocument.eventFactory(), this.drawingDirectionStrippableAttributes.strip(event.asStartElement())));
                continue;
            }
            if (XMLEventHelpers.isPresentationEndEvent(event)) {
                markupBuilder.add(MarkupComponentFactory.createEndMarkupComponent(event.asEndElement()));
                continue;
            }
            if (event.isStartElement() && PowerpointStyleDefinitions.NAMES.contains(event.asStartElement().getName().getLocalPart())) {
                PowerpointStyleDefinitionsReader reader = new PowerpointStyleDefinitionsReader(this.generalDocument.conditionalParameters(), this.generalDocument.eventFactory(), xmlEventReader, event.asStartElement(), event.asStartElement().getName().getLocalPart());
                PowerpointStyleDefinitions powerpointStyleDefinitions = new PowerpointStyleDefinitions(this.generalDocument.eventFactory());
                powerpointStyleDefinitions.readWith(reader);
                markupBuilder.add(powerpointStyleDefinitions.asMarkup());
                continue;
            }
            markupBuilder.add(event);
        }
        DocumentPart documentPart = new DocumentPart(this.entry.getName(), false);
        documentPart.setSkeleton(new MarkupZipSkeleton(this.generalDocument.zipFile(), this.entry, this.generalDocument.outputFactory(), this.generalDocument.encoding(), markupBuilder.build()));
        return documentPart;
    }

    @Override
    public void logEvent(Event e) {
        this.LOGGER.trace("[[ {}: {} ]]", (Object)this.getClass().getSimpleName(), (Object)this.entry.getName());
    }
}

