/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.filters.openxml.Document;
import net.sf.okapi.filters.openxml.TranslatablePart;
import net.sf.okapi.filters.openxml.XMLEventHelpers;
import net.sf.okapi.filters.openxml.XMLEventSerializer;

class MasterAndPagePart
extends TranslatablePart {
    private static final String UNEXPECTED_NUMBER_OF_XML_EVENTS = "Unexpected number of XML events";
    private static final String TEXT = "Text";
    private static final String CHARACTER_PROPERTIES_MARKER = "cp";
    private static final String TEXT_FIELD_INSERTION_POINT = "fld";
    private static final String PARAGRAPH_PROPERTIES_MARKER = "pp";
    private static final String TAB_PROPERTIES_MARKER = "tp";
    private final IdGenerator textUnitIdGenerator;
    private String subDocumentId;
    private XMLEventReader xmlEventReader;
    private Iterator<Event> filterEventIterator;

    MasterAndPagePart(Document.General generalDocument, ZipEntry entry) {
        super(generalDocument, entry);
        this.textUnitIdGenerator = new IdGenerator(entry.getName(), "tu");
    }

    @Override
    public Event open() throws IOException, XMLStreamException {
        this.subDocumentId = this.generalDocument.nextSubDocumentId();
        this.xmlEventReader = this.generalDocument.inputFactory().createXMLEventReader(new InputStreamReader((InputStream)new BufferedInputStream(this.generalDocument.inputStreamFor(this.entry)), StandardCharsets.UTF_8));
        this.handlePart();
        return this.createStartSubDocumentEvent(this.generalDocument.documentId(), this.subDocumentId);
    }

    private void handlePart() throws XMLStreamException {
        while (this.xmlEventReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlEventReader.nextEvent();
            if (!XMLEventHelpers.isStartElement(xmlEvent, TEXT)) {
                this.addEventToDocumentPart(xmlEvent);
                continue;
            }
            this.flushDocumentPart();
            TextUnit textUnit = this.parseText(xmlEvent);
            this.filterEvents.add(new Event(EventType.TEXT_UNIT, textUnit));
        }
        this.flushDocumentPart();
        this.filterEvents.add(new Event(EventType.END_SUBDOCUMENT, new Ending(this.subDocumentId)));
        this.filterEventIterator = this.filterEvents.iterator();
    }

    private TextUnit parseText(XMLEvent event) throws XMLStreamException {
        GenericSkeleton skeleton = new GenericSkeleton(XMLEventSerializer.serialize(event));
        TextUnit textUnit = new TextUnit(this.textUnitIdGenerator.createId());
        textUnit.setPreserveWhitespaces(true);
        TextFragment textFragment = new TextFragment();
        XMLEvent nextEvent = null;
        while (this.xmlEventReader.hasNext()) {
            Code code;
            String codeType;
            XMLEvent xmlEvent;
            XMLEvent xMLEvent = xmlEvent = null == nextEvent ? this.xmlEventReader.nextEvent() : nextEvent;
            if (XMLEventHelpers.isEndElement(xmlEvent, event.asStartElement())) {
                textUnit.setSourceContent(textFragment);
                skeleton.addContentPlaceholder(textUnit);
                skeleton.append(XMLEventSerializer.serialize(xmlEvent));
                textUnit.setSkeleton(skeleton);
                return textUnit;
            }
            if (XMLEventHelpers.isStartElement(xmlEvent, CHARACTER_PROPERTIES_MARKER) || XMLEventHelpers.isStartElement(xmlEvent, TEXT_FIELD_INSERTION_POINT) || XMLEventHelpers.isStartElement(xmlEvent, PARAGRAPH_PROPERTIES_MARKER) || XMLEventHelpers.isStartElement(xmlEvent, TAB_PROPERTIES_MARKER)) {
                codeType = xmlEvent.asStartElement().getName().getLocalPart();
                if (!this.xmlEventReader.hasNext()) {
                    throw new OkapiBadFilterInputException(UNEXPECTED_NUMBER_OF_XML_EVENTS);
                }
                nextEvent = this.xmlEventReader.nextEvent();
                if (!nextEvent.isEndElement() || !nextEvent.asEndElement().getName().equals(xmlEvent.asStartElement().getName())) {
                    code = new Code(TextFragment.TagType.OPENING, codeType, XMLEventSerializer.serialize(xmlEvent));
                    textFragment.append(code);
                    continue;
                }
                code = new Code(TextFragment.TagType.PLACEHOLDER, codeType, XMLEventSerializer.serialize(Arrays.asList(xmlEvent, nextEvent)));
                textFragment.append(code);
                nextEvent = null;
                continue;
            }
            if (XMLEventHelpers.isEndElement(xmlEvent, CHARACTER_PROPERTIES_MARKER) || XMLEventHelpers.isEndElement(xmlEvent, TEXT_FIELD_INSERTION_POINT) || XMLEventHelpers.isEndElement(xmlEvent, PARAGRAPH_PROPERTIES_MARKER) || XMLEventHelpers.isEndElement(xmlEvent, TAB_PROPERTIES_MARKER)) {
                codeType = xmlEvent.asEndElement().getName().getLocalPart();
                code = new Code(TextFragment.TagType.CLOSING, codeType, XMLEventSerializer.serialize(xmlEvent));
                textFragment.append(code);
                nextEvent = null;
                continue;
            }
            textFragment.append(XMLEventSerializer.serialize(xmlEvent));
            nextEvent = null;
        }
        throw new OkapiBadFilterInputException();
    }

    @Override
    public boolean hasNextEvent() {
        return this.filterEventIterator.hasNext();
    }

    @Override
    public Event nextEvent() {
        return this.filterEventIterator.next();
    }

    @Override
    public void close() {
    }

    @Override
    public void logEvent(Event e) {
    }
}

