/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.time.LocalDateTime;
import net.sf.okapi.filters.openxml.NumberFormat;
import net.sf.okapi.filters.openxml.SerialDateTime;

interface ExcelNumber {
    public String formattedWith(NumberFormat var1);

    public static class Default
    implements ExcelNumber {
        private final String value;
        private final boolean date1904;

        Default(String value, boolean date1904) {
            this.value = value;
            this.date1904 = date1904;
        }

        @Override
        public String formattedWith(NumberFormat numberFormat) {
            if (numberFormat.dateTimeBased()) {
                LocalDateTime ldt = this.date1904 ? new SerialDateTime.Epoch1904Based(this.value).asLocalDateTime() : new SerialDateTime.Epoch1900Based(this.value).asLocalDateTime();
                return numberFormat.dateTimeFormatter().format(ldt);
            }
            return this.value;
        }
    }
}

