/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.util.HashMap;
import java.util.Map;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.filters.openxml.CrossSheetCellReference;
import net.sf.okapi.filters.openxml.DispersedTranslation;

interface DispersedTranslations {
    public static final String NAMESPACE = "namespace";

    public void prepareFor(LocaleId var1);

    public void add(CrossSheetCellReference var1, String var2, String var3);

    public boolean presentFor(CrossSheetCellReference var1);

    public String namespaceFor(CrossSheetCellReference var1);

    public boolean namespaceAndRawSourceMatch(String var1, String var2);

    public void update(CrossSheetCellReference var1, String var2);

    public String encodedTargetOrRawSourceFor(String var1, String var2, LocaleId var3);

    public void clear();

    public static final class Default
    implements DispersedTranslations {
        private static final String TRANSLATION_IS_UNAVAILABLE = "The requested dispersed translation is unavailable: ";
        private final Map<CrossSheetCellReference, DispersedTranslation> translations;
        private LocaleId targetLocale;

        Default() {
            this(new HashMap<CrossSheetCellReference, DispersedTranslation>());
        }

        Default(Map<CrossSheetCellReference, DispersedTranslation> translations) {
            this.translations = translations;
        }

        @Override
        public void prepareFor(LocaleId targetLocale) {
            this.targetLocale = targetLocale;
        }

        @Override
        public void add(CrossSheetCellReference crossSheetCellReference, String namespace, String rawSource) {
            this.translations.put(crossSheetCellReference, new DispersedTranslation.Default(namespace, rawSource));
        }

        @Override
        public boolean presentFor(CrossSheetCellReference crossSheetCellReference) {
            return this.translations.containsKey(crossSheetCellReference);
        }

        @Override
        public String namespaceFor(CrossSheetCellReference crossSheetCellReference) {
            DispersedTranslation dt = this.translations.get(crossSheetCellReference);
            if (null == dt) {
                throw new IllegalArgumentException("The dispersed translation is not available for: ".concat(crossSheetCellReference.toString()));
            }
            return dt.namespace();
        }

        @Override
        public boolean namespaceAndRawSourceMatch(String namespace, String rawSource) {
            return this.translations.values().stream().anyMatch(dt -> dt.namespace().equals(namespace) && dt.rawSource().equals(rawSource));
        }

        @Override
        public void update(CrossSheetCellReference crossSheetCellReference, String encodedTarget) {
            DispersedTranslation dt = this.translations.get(crossSheetCellReference);
            dt.prepareFor(this.targetLocale, encodedTarget);
        }

        @Override
        public String encodedTargetOrRawSourceFor(String namespace, String rawSource, LocaleId locale) {
            DispersedTranslation dt = this.translations.values().stream().filter(cdt -> cdt.namespace().equals(namespace) && cdt.rawSource().equals(rawSource)).findFirst().orElseThrow(() -> new IllegalArgumentException(TRANSLATION_IS_UNAVAILABLE.concat(namespace).concat(" ").concat(rawSource)));
            return dt.encodedTargetOrRawSourceFor(locale);
        }

        @Override
        public void clear() {
            this.translations.clear();
        }
    }
}

