/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import net.sf.okapi.common.resource.CodeTypeBuilder;
import net.sf.okapi.common.resource.ExtendedCodeType;
import net.sf.okapi.filters.openxml.Property;
import net.sf.okapi.filters.openxml.RunContainer;
import net.sf.okapi.filters.openxml.RunProperties;
import net.sf.okapi.filters.openxml.RunProperty;
import net.sf.okapi.filters.openxml.RunPropertyFactory;

class CodeTypeFactory {
    private static final String EMPHASIS_MARK_PROPERTY_NAME = "em";
    private static final String UNDERLINE_PROPERTY_NAME = "u";
    private static final String BOLD_PROPERTY_NAME = "b";
    private static final String ITALIC_PROPERTY_NAME = "i";
    private static final String HIGHLIGHT_COLOR_PROPERTY_NAME = "highlight";
    private static final String COLOR_PROPERTY_NAME = "color";
    private static final String VERTICAL_ALIGNMENT_PROPERTY_NAME = "vertAlign";
    private static final String HLINK_CLICK_PROPERTY_NAME = "hlinkClick";
    private static final String HLINK_MOUSEOVER_PROPERTY_NAME = "hlinkMouseOver";
    private static final String VERTICAL_ALIGNMENT_SUPERSCRIPT_VALUE = "superscript";
    private static final String VERTICAL_ALIGNMENT_SUBSCRIPT_VALUE = "subscript";
    private static final String NONE_VALUE = "none";
    private static final boolean ADD_EXTENDED_CODE_TYPE_PREFIX = true;

    CodeTypeFactory() {
    }

    static String createCodeType(RunContainer runContainer) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(true);
        if (RunContainer.Type.HYPERLINK == runContainer.type()) {
            codeTypeBuilder.addType("link");
        } else {
            codeTypeBuilder.addType(runContainer.type().value());
        }
        return codeTypeBuilder.build() + CodeTypeFactory.createCodeType(runContainer.getDefaultCombinedRunProperties(), false);
    }

    static String createCodeType(RunProperties runProperties) {
        return CodeTypeFactory.createCodeType(runProperties, true);
    }

    private static String createCodeType(RunProperties runProperties, boolean addExtendedCodeTypePrefix) {
        CodeTypeBuilder codeTypeBuilder = new CodeTypeBuilder(addExtendedCodeTypePrefix);
        boolean highlightPropertyPresent = runProperties.contains(HIGHLIGHT_COLOR_PROPERTY_NAME);
        for (Property runProperty : runProperties.properties()) {
            if (runProperty instanceof RunProperty.WpmlToggleRunProperty) {
                CodeTypeFactory.handleWpmlToggleRunProperty(codeTypeBuilder, (RunProperty.WpmlToggleRunProperty)runProperty);
                continue;
            }
            if (runProperty instanceof RunProperty.SmlRunProperty) {
                CodeTypeFactory.handleSmlRunProperty(codeTypeBuilder, (RunProperty.SmlRunProperty)runProperty);
                continue;
            }
            if (runProperty instanceof RunProperty.HyperlinkRunProperty) {
                CodeTypeFactory.handleHyperlinkRunProperty(codeTypeBuilder, (RunProperty.HyperlinkRunProperty)runProperty);
                continue;
            }
            if (runProperty instanceof RunProperty.ShadeRunProperty && !highlightPropertyPresent) {
                CodeTypeFactory.handleShadeRunProperty(codeTypeBuilder, (RunProperty.ShadeRunProperty)runProperty);
                continue;
            }
            CodeTypeFactory.handleRunProperty(codeTypeBuilder, runProperty);
        }
        return codeTypeBuilder.build();
    }

    private static void handleWpmlToggleRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty.WpmlToggleRunProperty toggleRunProperty) {
        if (!toggleRunProperty.getToggleValue()) {
            return;
        }
        switch (RunPropertyFactory.WpmlTogglePropertyName.fromString(toggleRunProperty.getName().getLocalPart())) {
            case BOLD: {
                codeTypeBuilder.addType("bold");
                break;
            }
            case ITALICS: {
                codeTypeBuilder.addType("italic");
                break;
            }
            case STRIKE_THROUGH: {
                codeTypeBuilder.addType(ExtendedCodeType.STRIKE_THROUGH.getValue());
                break;
            }
            case SHADOW: {
                codeTypeBuilder.addType(ExtendedCodeType.SHADOW.getValue());
                break;
            }
            case CAPS: {
                codeTypeBuilder.addType(ExtendedCodeType.CAPS.getValue());
            }
        }
    }

    private static void handleSmlRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty.SmlRunProperty runProperty) {
        String value = runProperty.value();
        if (value == null) {
            value = runProperty.getDefaultValue();
        }
        if ("false".equals(value)) {
            return;
        }
        switch (RunPropertyFactory.SmlPropertyName.fromString(runProperty.getName().getLocalPart())) {
            case BOLD: {
                codeTypeBuilder.addType("bold");
                break;
            }
            case ITALICS: {
                codeTypeBuilder.addType("italic");
                break;
            }
            case STRIKE_THROUGH: {
                codeTypeBuilder.addType(ExtendedCodeType.STRIKE_THROUGH.getValue());
                break;
            }
            case SHADOW: {
                codeTypeBuilder.addType(ExtendedCodeType.SHADOW.getValue());
                break;
            }
            case UNDERLINE: {
                codeTypeBuilder.addType(ExtendedCodeType.UNDERLINE.getValue(), value);
            }
        }
    }

    private static void handleHyperlinkRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty.HyperlinkRunProperty runProperty) {
        if (null == runProperty.value() || NONE_VALUE.equals(runProperty.value())) {
            return;
        }
        codeTypeBuilder.addType("link");
    }

    private static void handleShadeRunProperty(CodeTypeBuilder codeTypeBuilder, RunProperty.ShadeRunProperty runProperty) {
        codeTypeBuilder.addType(ExtendedCodeType.HIGHLIGHT.getValue(), runProperty.fillValue());
    }

    private static void handleRunProperty(CodeTypeBuilder codeTypeBuilder, Property runProperty) {
        if (null == runProperty.value() || NONE_VALUE.equals(runProperty.value())) {
            return;
        }
        String runPropertyName = runProperty.getName().getLocalPart();
        if (BOLD_PROPERTY_NAME.equals(runPropertyName)) {
            CodeTypeFactory.addCodeTypeIfNecessary(runProperty.value(), "bold", codeTypeBuilder);
            return;
        }
        if (ITALIC_PROPERTY_NAME.equals(runPropertyName)) {
            CodeTypeFactory.addCodeTypeIfNecessary(runProperty.value(), "italic", codeTypeBuilder);
            return;
        }
        if (UNDERLINE_PROPERTY_NAME.equals(runPropertyName)) {
            codeTypeBuilder.addType(ExtendedCodeType.UNDERLINE.getValue(), runProperty.value());
            return;
        }
        if (EMPHASIS_MARK_PROPERTY_NAME.equals(runPropertyName)) {
            codeTypeBuilder.addType("italic");
            return;
        }
        if (HIGHLIGHT_COLOR_PROPERTY_NAME.equals(runPropertyName)) {
            codeTypeBuilder.addType(ExtendedCodeType.HIGHLIGHT.getValue(), runProperty.value());
            return;
        }
        if (COLOR_PROPERTY_NAME.equals(runPropertyName)) {
            codeTypeBuilder.addType(ExtendedCodeType.COLOR.getValue(), runProperty.value());
            return;
        }
        if (VERTICAL_ALIGNMENT_PROPERTY_NAME.equals(runPropertyName)) {
            switch (runProperty.value()) {
                case "superscript": {
                    codeTypeBuilder.addType(ExtendedCodeType.SUPERSCRIPT.getValue());
                    return;
                }
                case "subscript": {
                    codeTypeBuilder.addType(ExtendedCodeType.SUBSCRIPT.getValue());
                    return;
                }
            }
        }
    }

    private static void addCodeTypeIfNecessary(String runPropertyValue, String codeType, CodeTypeBuilder codeTypeBuilder) {
        switch (codeType) {
            case "bold": 
            case "italic": {
                if (!"1".equals(runPropertyValue)) break;
                codeTypeBuilder.addType(codeType);
                break;
            }
        }
    }
}

