/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.BOMAwareInputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.mif.CharLiteralToken;
import net.sf.okapi.filters.mif.Document;
import net.sf.okapi.filters.mif.Extracts;
import net.sf.okapi.filters.mif.FontTags;
import net.sf.okapi.filters.mif.Hexadecimal;
import net.sf.okapi.filters.mif.MIFEncoder;
import net.sf.okapi.filters.mif.Parameters;
import net.sf.okapi.filters.mif.Statement;
import net.sf.okapi.filters.mif.Statements;
import net.sf.okapi.filters.mif.Token;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class MIFFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String DEFAULT_ENCODING = StandardCharsets.UTF_8.name();
    private static final String LINE_FEED = "\n";
    private static final String HARD_RETURN = "\\n";
    private static final String TOPSTATEMENTSTOSKIP = "ColorCatalog;ConditionCatalog;BoolCondCatalog;CombinedFontCatalog;ElementDefCatalog;FmtChangeListCatalog;DefAttrValuesCatalog;AttrCondExprCatalog;FontCatalog;RulingCatalog;TblCatalog;KumihanCatalog;Views;MarkerTypeCatalog;Document;BookComponent;InitialAutoNums;Dictionary;";
    private static final String IMPORTOBJECT = "ImportObject";
    private Parameters params = new Parameters();
    private String lineBreak;
    private String docName;
    private BufferedReader reader;
    private Document document;
    private StringBuilder tagBuffer;
    private StringBuilder strBuffer;
    private int tuId;
    private int otherId;
    private int grpId;
    private boolean canceled;
    private LinkedList<Event> queue;
    private LocaleId srcLang;
    private GenericSkeleton skel;
    private boolean hasNext;
    private EncoderManager encoderManager;
    private int inBlock;
    private boolean inPgfCatalog;
    private int pgfCatalogLevel;
    private boolean inPgf;
    private boolean extractedPgfNumFormat;
    private int blockLevel;
    private int paraLevel;
    private StringBuilder paraSkelBuf;
    private StringBuilder paraTextBuf;
    private StringBuilder paraCodeBuf;
    private StringBuilder paraCodeTypes;
    private int tableGroupLevel;
    private int rowGroupLevel;
    private int cellGroupLevel;
    private int fnoteGroupLevel;
    private Stack<String> parentIds;
    private Extracts extracts;
    private MIFEncoder encoder;
    private String encoding;
    private int footnotesLevel;
    private int textFlowNumber;
    private Deque<ITextUnit> referentTextUnits;
    private RawDocument rawDocument;
    private boolean inXRef;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        if (this.rawDocument != null) {
            this.rawDocument.close();
        }
        try {
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
            this.docName = null;
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_mif";
    }

    @Override
    public String getDisplayName() {
        return "MIF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/vnd.mif";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/vnd.mif", this.getClass().getName(), "MIF (BETA)", "Adobe FrameMaker MIF documents", null, ".mif;"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/vnd.mif", "net.sf.okapi.filters.mif.MIFEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument rawDocument, boolean generateSkeleton) {
        this.rawDocument = rawDocument;
        if (rawDocument.getInputURI() == null && rawDocument.getInputCharSequence() == null) {
            throw new OkapiBadFilterInputException("Direct stream input not supported for MIF.");
        }
        this.srcLang = rawDocument.getSourceLocale();
        if (rawDocument.getInputURI() != null) {
            this.docName = rawDocument.getInputURI().getPath();
        }
        try {
            BOMAwareInputStream bis = new BOMAwareInputStream(rawDocument.getStream(), DEFAULT_ENCODING);
            this.encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, this.encoding));
            this.initialize();
            this.extracts = new Extracts(this.params, new FontTags());
            this.extracts.from(this.document);
            this.lineBreak = this.extracts.lineBreak();
            this.encoder = new MIFEncoder();
            this.encoder.setOptions(this.params, this.encoding, this.lineBreak);
            this.reader.close();
            rawDocument.close();
            bis = new BOMAwareInputStream(rawDocument.getStream(), DEFAULT_ENCODING);
            this.encoding = bis.detectEncoding();
            this.reader = new BufferedReader(new InputStreamReader((InputStream)bis, this.encoding));
            this.initialize();
            this.referentTextUnits = new LinkedList<ITextUnit>();
            String sdId = rawDocument.getId();
            if (Util.isEmpty(sdId)) {
                sdId = "sd1";
            }
            this.parentIds.push(sdId);
            if (this.params.getUseCodeFinder()) {
                this.params.getCodeFinder().addRules(this.extracts.additionalInlineCodeFinderRules());
                this.params.getCodeFinder().compile();
            }
            this.queue = new LinkedList();
            StartDocument startDoc = new StartDocument(sdId);
            startDoc.setName(this.docName);
            startDoc.setLineBreak(this.lineBreak);
            startDoc.setEncoding(this.encoding, false);
            startDoc.setLocale(this.srcLang);
            startDoc.setFilterId(this.getName());
            startDoc.setFilterParameters(this.getParameters());
            startDoc.setFilterWriter(this.createFilterWriter());
            startDoc.setType(this.getMimeType());
            startDoc.setMimeType(this.getMimeType());
            this.queue.add(new Event(EventType.START_DOCUMENT, startDoc));
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException("Error reading MIF input.", e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error reading MIF input.", e);
        }
    }

    private void initialize() {
        this.document = new Document.Default(new Statements(this.reader), this.reader, new LinkedList<Statement>());
        this.tagBuffer = new StringBuilder();
        this.strBuffer = new StringBuilder();
        this.paraSkelBuf = new StringBuilder();
        this.paraCodeBuf = new StringBuilder();
        this.paraCodeTypes = new StringBuilder();
        this.paraTextBuf = new StringBuilder();
        this.tuId = 0;
        this.otherId = 0;
        this.grpId = 0;
        this.canceled = false;
        this.hasNext = true;
        this.inBlock = 0;
        this.blockLevel = 0;
        this.tableGroupLevel = -1;
        this.rowGroupLevel = -1;
        this.cellGroupLevel = -1;
        this.fnoteGroupLevel = -1;
        this.parentIds = new Stack();
        this.footnotesLevel = -1;
        this.textFlowNumber = 0;
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public Event next() {
        if (this.canceled) {
            this.queue.clear();
            this.queue.add(new Event(EventType.CANCELED));
            this.hasNext = false;
        }
        if (this.queue.isEmpty()) {
            this.read();
        }
        if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
            this.hasNext = false;
        }
        return this.queue.poll();
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return new GenericSkeletonWriter();
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    private void read() {
        try {
            int c;
            this.skel = new GenericSkeleton();
            if (this.inBlock > 0) {
                this.processBlock(this.inBlock);
                return;
            }
            block7: while ((c = this.reader.read()) != -1) {
                switch (c) {
                    case 35: {
                        this.skel.append((char)c);
                        this.readComment(true, null);
                        continue block7;
                    }
                    case 60: {
                        this.skel.append((char)c);
                        ++this.blockLevel;
                        String tag = this.readTag(true, true, null);
                        if (TOPSTATEMENTSTOSKIP.contains(tag + ";")) {
                            this.skipOverContent(true, null);
                            --this.blockLevel;
                        } else {
                            if ("PgfCatalog".equals(tag)) {
                                this.inPgfCatalog = true;
                                this.pgfCatalogLevel = this.blockLevel;
                                continue block7;
                            }
                            if (this.inPgfCatalog && "Pgf".equals(tag)) {
                                if (this.startBlock(this.blockLevel, BlockType.PARAGRAPH_STYLE)) {
                                    return;
                                }
                            } else if ("TextFlow".equals(tag)) {
                                ++this.textFlowNumber;
                                if (this.startBlock(this.blockLevel, BlockType.TEXT_FLOW)) {
                                    return;
                                }
                            } else {
                                if ("Tbls".equals(tag)) continue block7;
                                if ("Tbl".equals(tag)) {
                                    if (this.startBlock(this.blockLevel, BlockType.TABLE)) {
                                        return;
                                    }
                                } else if ("VariableFormats".equals(tag)) {
                                    if (this.params.getExtractVariables()) {
                                        this.processFormats("Variable");
                                    } else {
                                        this.skipOverContent(true, null);
                                        --this.blockLevel;
                                    }
                                } else if ("XRefFormats".equals(tag)) {
                                    if (this.params.getExtractReferenceFormats()) {
                                        this.processFormats("XRef");
                                    } else {
                                        this.skipOverContent(true, null);
                                        --this.blockLevel;
                                    }
                                } else if ("Page".equals(tag)) {
                                    this.processPage(this.blockLevel);
                                } else if ("AFrames".equals(tag)) {
                                    this.processFramesAndTextLines(this.blockLevel);
                                } else {
                                    this.skipOverContent(true, null);
                                    --this.blockLevel;
                                }
                            }
                        }
                        this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
                        return;
                    }
                    case 62: {
                        this.skel.append((char)c);
                        --this.blockLevel;
                        if (this.inPgfCatalog && this.pgfCatalogLevel > this.blockLevel) {
                            this.inPgfCatalog = false;
                        }
                        DocumentPart dp = new DocumentPart(String.valueOf(++this.otherId), false, this.skel);
                        this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
                        return;
                    }
                }
                this.skel.append((char)c);
            }
            Ending ending = new Ending(String.valueOf(++this.otherId));
            this.queue.add(new Event(EventType.END_DOCUMENT, ending, this.skel));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    private void skipOverContent(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int baseLevel = 1;
        int state = 0;
        block16: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block16;
                        }
                        case 92: {
                            state = 2;
                            continue block16;
                        }
                        case 60: {
                            ++baseLevel;
                            this.tagBuffer.setLength(0);
                            state = 3;
                            continue block16;
                        }
                        case 62: {
                            if (--baseLevel != 0) continue block16;
                            return;
                        }
                    }
                    continue block16;
                }
                case 1: {
                    if (c != 39) continue block16;
                    state = 0;
                    continue block16;
                }
                case 2: {
                    state = 0;
                    continue block16;
                }
                case 3: {
                    switch (c) {
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 9: 
                        case 32: {
                            if (this.tagBuffer.toString().equals(IMPORTOBJECT)) {
                                this.skipOverImportObject(store, buffer);
                                --baseLevel;
                            }
                            state = 0;
                            continue block16;
                        }
                    }
                    this.tagBuffer.append((char)c);
                    continue block16;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private void readComment(boolean store, StringBuilder sb) throws IOException {
        int c;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb != null) {
                    sb.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (c) {
                case 10: 
                case 13: {
                    return;
                }
            }
        }
    }

    private boolean startBlock(int stopLevel, BlockType type) throws IOException {
        if (type == BlockType.TABLE) {
            String tag = this.readUntil("TblID;", true, null, stopLevel, true);
            if (tag == null) {
                throw new OkapiIOException("Missing id for the table.");
            }
            Token token = this.firstLiteralTokenInStatement(true, true);
            if (token.toString().isEmpty()) {
                throw new OkapiIOException("Missing id value for the table.");
            }
            if (!this.extracts.tableExtractable(token.toString())) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.tableGroupLevel = this.blockLevel;
            StartGroup sg = new StartGroup(this.parentIds.peek());
            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
            sg.setType("table");
            this.queue.add(new Event(EventType.START_GROUP, sg));
        } else if (type == BlockType.TEXT_FLOW) {
            if (!this.extracts.textFlowExtractable(String.valueOf(this.textFlowNumber))) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
        } else if (type == BlockType.PARAGRAPH_STYLE) {
            String tag = this.readUntil("PgfTag;", true, null, stopLevel, true);
            if (tag == null) {
                throw new OkapiIOException("Missing PgfTag for the Pgf.");
            }
            Token token = this.firstLiteralTokenInStatement(true, true);
            if (token.toString().isEmpty()) {
                throw new OkapiIOException("Missing the PgfTag value.");
            }
            if (!this.extracts.paragraphFormatTagExtractable(token.toString())) {
                this.skipOverContent(true, null);
                --this.blockLevel;
                return false;
            }
            this.processBlock(stopLevel);
            return true;
        }
        this.processBlock(stopLevel);
        return true;
    }

    private void processBlock(int stopLevel) throws IOException {
        if (this.inPgfCatalog) {
            this.processPara();
            --this.blockLevel;
            this.inBlock = 0;
        } else if (this.readUntil("Para;", true, null, stopLevel, false) != null) {
            this.processPara();
            --this.blockLevel;
            this.inBlock = stopLevel;
        } else {
            this.inBlock = 0;
        }
        if (!this.skel.isEmpty()) {
            this.queue.add(new Event(EventType.DOCUMENT_PART, new DocumentPart(String.valueOf(++this.otherId), false), this.skel));
        }
    }

    private void processPara() throws IOException {
        TextFragment tf = new TextFragment();
        boolean first = true;
        this.paraLevel = 1;
        this.paraSkelBuf.setLength(0);
        this.paraTextBuf.setLength(0);
        this.paraCodeBuf.setLength(0);
        this.paraCodeTypes.setLength(0);
        String endString = "";
        LinkedList<Code> codes = new LinkedList<Code>();
        boolean extractedReferent = false;
        String extractedStringTag = "";
        boolean forceStringClosing = false;
        int res = this.readUntilText(first, false);
        while (res > 0) {
            String type;
            switch (res) {
                case 2: {
                    while (!this.referentTextUnits.isEmpty()) {
                        Code code = new Code(TextFragment.TagType.PLACEHOLDER, "index", endString.concat(TextFragment.makeRefMarker(this.referentTextUnits.poll().getId())));
                        code.setReferenceFlag(true);
                        codes.add(code);
                        extractedReferent = true;
                    }
                    break;
                }
                case 3: {
                    if (!(this.params.getExtractPgfNumFormatsInline() || this.inPgfCatalog || this.referentTextUnits.isEmpty())) {
                        while (!this.referentTextUnits.isEmpty()) {
                            Code code = new Code(TextFragment.TagType.PLACEHOLDER, "ref", TextFragment.makeRefMarker(this.referentTextUnits.poll().getId()));
                            code.setReferenceFlag(true);
                            codes.add(code);
                        }
                        extractedReferent = true;
                    } else {
                        extractedReferent = false;
                    }
                    extractedStringTag = "<PgfNumFormat `";
                    endString = "'>";
                    break;
                }
                default: {
                    extractedReferent = false;
                    extractedStringTag = "<String `";
                    endString = "'>";
                }
            }
            if (first) {
                if (this.paraSkelBuf.length() > 0) {
                    this.skel.append(this.paraSkelBuf.toString());
                    if (this.paraCodeBuf.length() > 0) {
                        type = this.paraCodeTypes.length() > 0 ? this.paraCodeTypes.toString() : "code";
                        Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, type, this.paraCodeBuf.toString().concat(extractedStringTag));
                        this.paraCodeBuf.setLength(0);
                        tf.append(code2);
                    } else if (codes.isEmpty()) {
                        this.skel.append(extractedStringTag);
                    }
                }
                first = false;
            }
            if (this.paraCodeBuf.length() > 0) {
                String codedText;
                String string = type = this.paraCodeTypes.length() > 0 ? this.paraCodeTypes.toString() : "code";
                String data = tf.hasCode() ? (TextFragment.isMarker((codedText = tf.getCodedText()).charAt(codedText.length() - 2)) ? "" : endString) : endString;
                Code code2 = new Code(TextFragment.TagType.PLACEHOLDER, type, data.concat(this.paraCodeBuf.toString()).concat(extractedStringTag));
                tf.append(code2);
            }
            while (!codes.isEmpty()) {
                tf.append((Code)codes.poll());
            }
            if (this.paraTextBuf.length() > 0) {
                if (this.params.getExtractHardReturnsAsText() || !this.paraTextBuf.toString().contains(LINE_FEED)) {
                    tf.append(this.paraTextBuf.toString());
                } else {
                    for (int i = 0; i < this.paraTextBuf.length(); ++i) {
                        if ('\n' != this.paraTextBuf.charAt(i)) {
                            tf.append(this.paraTextBuf.charAt(i));
                            continue;
                        }
                        forceStringClosing = true;
                        if (tf.isEmpty()) {
                            this.skel.append(HARD_RETURN);
                            continue;
                        }
                        this.checkInlineCodes(tf);
                        if (!tf.hasText()) {
                            this.skel.append(this.toMIFString(tf));
                            this.skel.append(HARD_RETURN);
                            tf = new TextFragment();
                            continue;
                        }
                        this.addTextUnit(tf, "", "", this.skel);
                        this.skel.append(HARD_RETURN);
                        tf = new TextFragment();
                        this.skel = new GenericSkeleton();
                    }
                }
            }
            this.paraSkelBuf.setLength(0);
            this.paraTextBuf.setLength(0);
            this.paraCodeBuf.setLength(0);
            this.paraCodeTypes.setLength(0);
            res = this.readUntilText(first, extractedReferent);
        }
        this.checkInlineCodes(tf);
        if (!tf.isEmpty()) {
            if (tf.hasText() || extractedReferent) {
                this.addTextUnit(tf, "", "", this.skel);
                if (!extractedReferent) {
                    this.skel.append(endString);
                }
            } else {
                this.skel.append(this.toMIFString(tf));
                this.skel.append(endString);
            }
        } else if (forceStringClosing) {
            this.skel.append(endString);
            forceStringClosing = false;
        }
        if (this.paraSkelBuf.length() > 0) {
            this.skel.append(this.paraSkelBuf.toString());
        }
        if (this.paraCodeBuf.length() > 0) {
            this.skel.append(this.paraCodeBuf.toString());
        }
        if (tf.hasText() || extractedReferent) {
            this.skel = new GenericSkeleton();
        }
    }

    private Token firstLiteralTokenInStatement(boolean store, boolean updateBlockLevel) throws IOException {
        Statement statement = this.document.currentMarkup();
        if (store) {
            this.skel.add(statement.toString());
        }
        if (updateBlockLevel) {
            --this.blockLevel;
        }
        return statement.firstTokenOf(Token.Type.LITERAL);
    }

    private StringBuilder processMarker(String startTag) throws IOException {
        int level = this.blockLevel;
        StringBuilder sb = new StringBuilder(startTag);
        String tag = this.readUntil("MTypeName;", true, sb, -1, true);
        if (tag == null) {
            this.logger.warn("Marker without type or text found. It will be skipped.");
            this.skipOverContent(true, sb);
            return sb;
        }
        String type = this.processString(true, sb);
        String resType = null;
        if ("Index".equals(type)) {
            if (this.params.getExtractIndexMarkers()) {
                resType = "x-index";
            }
        } else if ("Hypertext".equals(type) && this.params.getExtractLinks()) {
            resType = "link";
        }
        if (resType == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return sb;
        }
        tag = this.readUntil("MText;", true, sb, -1, true);
        if (tag == null) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return sb;
        }
        TextFragment tf = new TextFragment(this.processString(true, sb));
        if (tf.isEmpty()) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return sb;
        }
        this.checkInlineCodes(tf);
        if (!tf.hasText()) {
            this.skipOverContent(true, sb);
            this.blockLevel = level;
            return sb;
        }
        this.addReferentTextUnits(tf, sb, resType);
        this.blockLevel = level;
        return sb;
    }

    private void addReferentTextUnits(TextFragment textFragment, StringBuilder stringBuilder, String type) throws IOException {
        int n = stringBuilder.lastIndexOf("`");
        stringBuilder.delete(n + 1, stringBuilder.length());
        GenericSkeleton skel = new GenericSkeleton(stringBuilder.toString());
        if (this.params.getExtractHardReturnsAsText() || !textFragment.toString().contains(LINE_FEED)) {
            this.addReferentTextUnit(textFragment, "", type, skel);
        } else {
            TextFragment tf = new TextFragment();
            for (int i = 0; i < textFragment.length(); ++i) {
                if (TextFragment.isMarker(textFragment.charAt(i))) {
                    tf.append(textFragment.getCode(TextFragment.toIndex(textFragment.charAt(++i))));
                    continue;
                }
                if ('\n' != textFragment.charAt(i)) {
                    tf.append(textFragment.charAt(i));
                    continue;
                }
                if (tf.isEmpty()) {
                    skel.append(HARD_RETURN);
                    continue;
                }
                this.checkInlineCodes(tf);
                if (!tf.hasText()) {
                    skel.append(this.toMIFString(tf));
                    skel.append(HARD_RETURN);
                    tf = new TextFragment();
                    continue;
                }
                this.addReferentTextUnit(tf, "", type, skel);
                skel.append(HARD_RETURN);
                tf = new TextFragment();
                skel = new GenericSkeleton();
            }
        }
        stringBuilder.setLength(0);
        stringBuilder.append("'>");
        this.skipOverContent(true, stringBuilder);
        ((GenericSkeleton)this.referentTextUnits.peekLast().getSkeleton()).add(stringBuilder.toString());
        stringBuilder.setLength(0);
    }

    private void addReferentTextUnit(TextFragment textFragment, String name, String type, GenericSkeleton skeleton) {
        ITextUnit tu = this.textUnit(textFragment, name, type, skeleton);
        TextUnitUtil.simplifyCodes(tu, this.params.getSimplifierRules(), true);
        tu.setIsReferent(true);
        this.referentTextUnits.add(tu);
        this.queue.add(new Event(EventType.TEXT_UNIT, tu, skeleton));
    }

    private ITextUnit textUnit(TextFragment textFragment, String name, String type, GenericSkeleton skeleton) {
        TextUnit tu = new TextUnit(String.valueOf(++this.tuId));
        tu.setPreserveWhitespaces(true);
        tu.setSourceContent(textFragment);
        tu.setName(name);
        tu.setType(type);
        tu.setMimeType("application/vnd.mif");
        this.processILC(tu);
        skeleton.addContentPlaceholder(tu);
        tu.setSkeleton(skeleton);
        return tu;
    }

    private void addTextUnit(TextFragment textFragment, String name, String type, GenericSkeleton skeleton) {
        this.addTextUnit(textFragment, name, type, skeleton, true);
    }

    private void addTextUnit(TextFragment textFragment, String name, String type, GenericSkeleton skeleton, boolean simplifyCodes) {
        ITextUnit tu = this.textUnit(textFragment, name, type, skeleton);
        if (simplifyCodes) {
            TextUnitUtil.simplifyCodes(tu, this.params.getSimplifierRules(), true);
        }
        this.queue.add(new Event(EventType.TEXT_UNIT, tu));
    }

    private int readUntilText(boolean startOfPara, boolean significant) throws IOException {
        int c;
        StringBuilder sb = startOfPara ? this.paraSkelBuf : this.paraCodeBuf;
        block5: while ((c = this.reader.read()) != -1) {
            switch (c) {
                case 35: {
                    sb.append((char)c);
                    this.readComment(true, sb);
                    continue block5;
                }
                case 60: {
                    ++this.paraLevel;
                    sb.append((char)c);
                    String tag = this.readTag(true, this.inXRef, sb);
                    if ("ParaLine".equals(tag) || "Pgf".equals(tag)) {
                        if ("Pgf".equals(tag)) {
                            this.inPgf = true;
                            this.extractedPgfNumFormat = false;
                        }
                        if (!this.inXRef && !startOfPara) {
                            int n = sb.lastIndexOf("<");
                            if (significant) {
                                if (!this.extractedPgfNumFormat) {
                                    sb.delete(n, sb.length());
                                }
                            } else {
                                sb.setLength(0);
                            }
                        }
                        return this.readUntilText(startOfPara, significant);
                    }
                    if (this.inXRef) {
                        this.skipOverContent(true, sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                        if ("XRefEnd".equals(tag)) {
                            this.inXRef = false;
                        }
                    } else if ("String".equals(tag) || "PgfNumFormat".equals(tag)) {
                        String text = this.processString(true, sb);
                        --this.paraLevel;
                        if (!Util.isEmpty(text)) {
                            if ("String".equals(tag)) {
                                int n = sb.lastIndexOf("<".concat(tag));
                                if (significant) {
                                    sb.delete(n, sb.length());
                                } else {
                                    sb.setLength(0);
                                }
                                this.paraTextBuf.append(text);
                                return 1;
                            }
                            if (this.params.getExtractPgfNumFormatsInline() || this.inPgfCatalog) {
                                int n = sb.lastIndexOf("<".concat(tag));
                                if (significant) {
                                    sb.delete(n, sb.length());
                                } else {
                                    sb.setLength(0);
                                }
                                this.paraTextBuf.append(text);
                                this.extractedPgfNumFormat = true;
                                return 3;
                            }
                            TextFragment tf = new TextFragment(text);
                            this.checkInlineCodes(tf);
                            if (tf.hasText()) {
                                this.addReferentTextUnits(tf, sb, "x-referent");
                                --this.paraLevel;
                                this.inPgf = false;
                                this.extractedPgfNumFormat = true;
                                return 3;
                            }
                            this.skipOverContent(true, sb);
                            --this.paraLevel;
                            this.inPgf = false;
                        }
                    } else if ("Char".equals(tag)) {
                        String text = new CharLiteralToken(this.firstLiteralTokenInStatement(false, false), this.logger).toString();
                        if (!significant) {
                            sb.setLength(0);
                        }
                        --this.paraLevel;
                        if (!text.isEmpty()) {
                            this.paraTextBuf.append(text);
                            return 1;
                        }
                    } else if ("Marker".equals(tag)) {
                        int n = sb.lastIndexOf("<".concat(tag));
                        String startTag = sb.substring(n);
                        if (significant) {
                            sb.delete(n, sb.length());
                        } else {
                            sb.setLength(0);
                        }
                        StringBuilder msb = this.processMarker(startTag);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                        if (0 == msb.length()) {
                            return 2;
                        }
                        sb.append((CharSequence)msb);
                    } else {
                        if ("XRef".equals(tag)) {
                            this.inXRef = true;
                        }
                        this.skipOverContent(true, sb);
                        significant = true;
                        if (this.paraCodeTypes.length() > 0) {
                            this.paraCodeTypes.append(";");
                        }
                        this.paraCodeTypes.append(tag.toLowerCase());
                        --this.paraLevel;
                    }
                    if (!startOfPara || !"Font;Marker;Conditional;Unconditional;ATbl;AFrame;Note;Variable;XRef;XRefEnd;".contains(tag)) continue block5;
                    int n = sb.lastIndexOf("<".concat(tag));
                    this.paraCodeBuf.append(sb.substring(n));
                    sb.delete(n, sb.length());
                    sb = this.paraCodeBuf;
                    this.paraCodeTypes.setLength(0);
                    this.paraCodeTypes.append(tag.toLowerCase());
                    startOfPara = false;
                    continue block5;
                }
                case 62: {
                    --this.paraLevel;
                    if (this.paraLevel == 1) {
                        if (this.inPgf) {
                            sb.append((char)c);
                            significant = true;
                            this.inPgf = false;
                        }
                        if (this.inXRef) {
                            sb.append((char)c);
                            significant = true;
                        }
                    } else if (this.paraLevel != 1 && !this.inPgf) {
                        sb.append((char)c);
                        significant = true;
                    }
                    if (this.paraLevel == 0 && this.inPgfCatalog) {
                        return 0;
                    }
                    if (this.paraLevel != 0) continue block5;
                    int n = sb.lastIndexOf(" # end of ParaLine");
                    if (n > -1) {
                        sb.insert(n, '>');
                    } else {
                        sb.append(" # end of ParaLine").append(this.lineBreak).append(">");
                    }
                    return 0;
                }
            }
            sb.append((char)c);
        }
        return 0;
    }

    private String readUntil(String tagNames, boolean store, StringBuilder sb, int stopLevel, boolean skipNotesBlock) throws IOException {
        int c;
        int endNow = stopLevel;
        if (stopLevel == -1) {
            endNow = this.blockLevel;
        }
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block0 : switch (c) {
                case 35: {
                    this.readComment(store, sb);
                    break;
                }
                case 60: {
                    do {
                        StartGroup sg;
                        ++this.blockLevel;
                        String tag = this.readTag(store, true, sb);
                        if (tagNames.contains(tag + ";")) {
                            if (skipNotesBlock && this.footnotesLevel != -1) break block0;
                            return tag;
                        }
                        if ("Tbl".equals(tag)) {
                            this.tableGroupLevel = this.blockLevel;
                            break block0;
                        }
                        if ("Row".equals(tag)) {
                            this.rowGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek());
                            sg.setId(this.parentIds.push(String.valueOf(++this.grpId)));
                            sg.setType("row");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Cell".equals(tag)) {
                            this.cellGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("cell");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if ("Notes".equals(tag)) {
                            this.footnotesLevel = this.blockLevel;
                            break block0;
                        }
                        if ("Note".equals(tag)) {
                            if (this.footnotesLevel <= 0) break block0;
                            this.fnoteGroupLevel = this.blockLevel;
                            sg = new StartGroup(this.parentIds.peek(), String.valueOf(++this.grpId));
                            sg.setType("fn");
                            this.queue.add(new Event(EventType.START_GROUP, sg));
                            break block0;
                        }
                        if (!IMPORTOBJECT.equals(tag)) continue;
                        this.skipOverImportObject(store, sb);
                        --this.blockLevel;
                        break block0;
                    } while (this.readUntilOpenOrClose(store, sb));
                    --this.blockLevel;
                    break;
                }
                case 62: {
                    if (this.tableGroupLevel == this.blockLevel) {
                        this.tableGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        this.parentIds.pop();
                    } else if (this.rowGroupLevel == this.blockLevel) {
                        this.rowGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                        this.parentIds.pop();
                    } else if (this.cellGroupLevel == this.blockLevel) {
                        this.cellGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                    } else if (this.footnotesLevel == this.blockLevel) {
                        this.footnotesLevel = -1;
                    } else if (this.fnoteGroupLevel == this.blockLevel && this.footnotesLevel > 0) {
                        this.fnoteGroupLevel = -1;
                        this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
                    }
                    --this.blockLevel;
                    if (this.blockLevel >= endNow) break;
                    return null;
                }
            }
        }
        return null;
    }

    private void skipOverImportObject(boolean store, StringBuilder buffer) throws IOException {
        int c;
        int state = 0;
        int baseLevel = 1;
        block19: while ((c = this.reader.read()) != -1) {
            if (store) {
                if (buffer != null) {
                    buffer.append((char)c);
                } else {
                    this.skel.append((char)c);
                }
            }
            switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            continue block19;
                        }
                        case 60: {
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            if (--baseLevel == 0) {
                                return;
                            }
                        }
                        case 10: 
                        case 13: {
                            state = 3;
                            continue block19;
                        }
                    }
                    continue block19;
                }
                case 1: {
                    if (c != 39) continue block19;
                    state = 0;
                    continue block19;
                }
                case 2: {
                    state = 0;
                    continue block19;
                }
                case 3: {
                    switch (c) {
                        case 38: {
                            state = 4;
                            continue block19;
                        }
                        case 60: {
                            state = 0;
                            ++baseLevel;
                            continue block19;
                        }
                        case 62: {
                            state = 0;
                            if (--baseLevel != 0) continue block19;
                            return;
                        }
                        case 10: 
                        case 13: {
                            continue block19;
                        }
                    }
                    state = 0;
                    continue block19;
                }
                case 4: {
                    if (c != 13 && c != 10) continue block19;
                    state = 3;
                    continue block19;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException(String.format("Unexpected end of input at state = %d", state));
    }

    private boolean readUntilOpenOrClose(boolean store, StringBuilder sb) throws IOException {
        int c;
        boolean inEscape = false;
        boolean inString = false;
        while ((c = this.reader.read()) != -1) {
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            if (inString) {
                if (c != 39) continue;
                inString = false;
                continue;
            }
            if (inEscape) {
                inEscape = false;
                continue;
            }
            switch (c) {
                case 96: {
                    inString = true;
                    break;
                }
                case 92: {
                    inEscape = true;
                    break;
                }
                case 60: {
                    return true;
                }
                case 62: {
                    return false;
                }
            }
        }
        throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
    }

    private String readTag(boolean store, boolean storeCharStatement, StringBuilder sb) throws IOException {
        int c;
        this.tagBuffer.setLength(0);
        int wsStart = sb != null ? sb.length() - 1 : -1;
        boolean leadingWSDone = false;
        block7: do {
            c = this.reader.read();
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (!store) continue block7;
                    if (sb != null) {
                        sb.append((char)c);
                        break;
                    }
                    this.skel.add((char)c);
                    break;
                }
                default: {
                    leadingWSDone = true;
                }
            }
        } while (!leadingWSDone);
        while (true) {
            switch (c) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    if (store) {
                        if (!storeCharStatement && this.tagBuffer.toString().equals("Char")) {
                            if (wsStart > 0) {
                                sb.delete(wsStart, sb.length());
                            }
                        } else if (sb != null) {
                            sb.append(this.tagBuffer.toString());
                            sb.append((char)c);
                        } else {
                            this.skel.append(this.tagBuffer.toString());
                            this.skel.append((char)c);
                        }
                    }
                    return this.tagBuffer.toString();
                }
                case -1: {
                    throw new OkapiIllegalFilterOperationException("Unexpected end of input.");
                }
            }
            this.tagBuffer.append((char)c);
            c = this.reader.read();
        }
    }

    private void processFormats(String name) throws IOException {
        boolean startGroupDone = false;
        String tag = null;
        do {
            if ((tag = this.readUntil(name.concat("Format;"), true, null, this.blockLevel - 1, true)) == null || (tag = this.readUntil(name.concat("Name;"), true, null, this.blockLevel - 1, true)) == null) continue;
            String formatName = this.processString(true, null);
            if (name.equals("XRef") && !this.extracts.referenceFormatTagExtractable(formatName) || (tag = this.readUntil(name.concat("Def;"), true, null, this.blockLevel - 1, true)) == null) continue;
            String text = this.processString(false, null);
            TextFragment tf = new TextFragment();
            this.skel.append("`");
            if (this.params.getExtractHardReturnsAsText() || !text.contains(LINE_FEED)) {
                tf.append(text);
                this.checkInlineCodes(tf);
                if (!startGroupDone) {
                    this.addStartGroup(name);
                    startGroupDone = true;
                }
                this.addTextUnit(tf, formatName, name.concat("Format"), this.skel, false);
                this.skel = new GenericSkeleton();
            } else {
                for (int i = 0; i < text.length(); ++i) {
                    if ('\n' != text.charAt(i)) {
                        tf.append(text.charAt(i));
                        continue;
                    }
                    if (tf.isEmpty()) {
                        this.skel.append(HARD_RETURN);
                        continue;
                    }
                    this.checkInlineCodes(tf);
                    if (!startGroupDone) {
                        this.addStartGroup(name);
                        startGroupDone = true;
                    }
                    this.addTextUnit(tf, formatName, name.concat("Format"), this.skel, false);
                    this.skel.append(HARD_RETURN);
                    tf = new TextFragment();
                    this.skel = new GenericSkeleton();
                }
            }
            this.skel.append("'>");
        } while (tag != null);
        if (startGroupDone) {
            this.queue.add(new Event(EventType.END_GROUP, new Ending(String.valueOf(++this.grpId))));
        }
    }

    private void addStartGroup(String name) {
        StartGroup sg = new StartGroup(this.parentIds.peek());
        sg.setId(String.valueOf(++this.grpId));
        sg.setType(name.concat("s"));
        this.queue.add(new Event(EventType.START_GROUP, sg));
    }

    private void processPage(int stopLevel) throws IOException {
        String tag = this.readUntil("PageType;", true, null, stopLevel, true);
        if (tag == null) {
            throw new OkapiIOException("Missing PageType of Page");
        }
        Token token = this.firstLiteralTokenInStatement(true, true);
        if (token.toString().isEmpty()) {
            throw new OkapiIOException("Missing PageType value of Page");
        }
        if (!this.extracts.pageTypeExtractable(token.toString())) {
            this.skipOverContent(true, null);
            --this.blockLevel;
            return;
        }
        this.processFramesAndTextLines(stopLevel);
    }

    private void processFrame(int stopLevel) throws IOException {
        String tag = this.readUntil("Unique;", true, null, stopLevel, true);
        if (tag == null) {
            throw new OkapiIOException("Missing Unique of Frame");
        }
        Token token = this.firstLiteralTokenInStatement(true, true);
        if (token.toString().isEmpty()) {
            throw new OkapiIOException("Missing Unique value of Frame");
        }
        if (!this.extracts.frameExtractable(token.toString())) {
            this.skipOverContent(true, null);
            --this.blockLevel;
            return;
        }
        this.processFramesAndTextLines(stopLevel);
    }

    private void processFramesAndTextLines(int stopLevel) throws IOException {
        String tag;
        do {
            if ("Frame".equals(tag = this.readUntil("Frame;TextLine;", true, null, stopLevel, true))) {
                this.processFrame(stopLevel + 1);
                continue;
            }
            if (!"TextLine".equals(tag)) continue;
            this.processTextLine(stopLevel + 1);
        } while (null != tag);
    }

    private void processTextLine(int stopLevel) throws IOException {
        String tag = this.readUntil("String;", true, null, stopLevel, true);
        if (null == tag) {
            return;
        }
        String text = this.processString(false, null);
        TextFragment tf = new TextFragment();
        this.skel.append("`");
        if (this.params.getExtractHardReturnsAsText() || !text.contains(LINE_FEED)) {
            tf.append(text);
            this.checkInlineCodes(tf);
            if (tf.hasText()) {
                this.addTextUnit(tf, "", "TextLine", this.skel);
                this.skel = new GenericSkeleton();
            } else {
                this.skel.append(this.toMIFString(tf));
            }
        } else {
            for (int i = 0; i < text.length(); ++i) {
                if ('\n' != text.charAt(i)) {
                    tf.append(text.charAt(i));
                    continue;
                }
                if (tf.isEmpty()) {
                    this.skel.append(HARD_RETURN);
                    continue;
                }
                this.checkInlineCodes(tf);
                if (!tf.hasText()) {
                    this.skel.append(this.toMIFString(tf));
                    this.skel.append(HARD_RETURN);
                    tf = new TextFragment();
                    continue;
                }
                this.addTextUnit(tf, "", "TextLine", this.skel);
                this.skel.append(HARD_RETURN);
                tf = new TextFragment();
                this.skel = new GenericSkeleton();
            }
        }
        this.skel.append("'>");
        --this.blockLevel;
    }

    private String toMIFString(TextFragment tf) {
        String ctext = tf.getCodedText();
        StringBuilder tmp = new StringBuilder();
        for (int i = 0; i < ctext.length(); ++i) {
            char ch = ctext.charAt(i);
            if (TextFragment.isMarker(ch)) {
                tmp.append(tf.getCode(ctext.charAt(++i)));
                continue;
            }
            tmp.append(this.encoder.encode(ch, EncoderContext.TEXT));
        }
        return tmp.toString();
    }

    private void checkInlineCodes(TextFragment tf) {
        if (this.params.getUseCodeFinder()) {
            this.params.getCodeFinder().process(tf);
        }
        List<Code> codes = tf.getCodes();
        for (Code code : codes) {
            if (!code.getType().equals("regxph")) continue;
            code.setData(this.encoder.encode(code.getData(), EncoderContext.INLINE));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String processString(boolean store, StringBuilder sb) throws IOException {
        this.strBuffer.setLength(0);
        int state = 0;
        while (true) {
            int c;
            if ((c = this.reader.read()) == -1) {
                throw new OkapiIllegalFilterOperationException("End of string is missing.");
            }
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case 96: {
                            state = 1;
                            break block0;
                        }
                        case 62: {
                            return this.strBuffer.toString();
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case 39: {
                            state = 0;
                            break block0;
                        }
                        case 92: {
                            state = 2;
                            break block0;
                        }
                    }
                    this.strBuffer.append((char)c);
                    break;
                }
                case 2: {
                    state = 1;
                    switch (c) {
                        case 62: 
                        case 92: {
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 116: {
                            this.strBuffer.append('\t');
                            break;
                        }
                        case 110: {
                            this.strBuffer.append('\n');
                            break;
                        }
                        case 81: {
                            this.strBuffer.append('`');
                            break;
                        }
                        case 113: {
                            this.strBuffer.append('\'');
                            break;
                        }
                        case 117: {
                            c = this.readHexa(4, false, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            this.strBuffer.append((char)c);
                            break;
                        }
                        case 120: {
                            c = this.readHexa(2, true, store, sb);
                            if (c == Integer.MAX_VALUE) break;
                            this.strBuffer.append(new Hexadecimal(c, this.logger).toString());
                        }
                    }
                    break;
                }
            }
        }
    }

    private int readHexa(int length, boolean readExtraSpace, boolean store, StringBuilder sb) throws IOException {
        this.tagBuffer.setLength(0);
        for (int i = 0; i < length; ++i) {
            int c = this.reader.read();
            if (c == -1) {
                throw new OkapiIllegalFilterOperationException("Unexpected end of file.");
            }
            if (store) {
                if (sb == null) {
                    this.skel.append((char)c);
                } else {
                    sb.append((char)c);
                }
            }
            this.tagBuffer.append((char)c);
        }
        if (readExtraSpace) {
            this.reader.read();
        }
        try {
            int n = Integer.valueOf(this.tagBuffer.toString(), 16);
            return n;
        }
        catch (NumberFormatException e) {
            this.logger.warn("Invalid escape sequence found: '{}'", (Object)this.tagBuffer.toString());
            return Integer.MAX_VALUE;
        }
    }

    private void processILC(ITextUnit tu) {
        TextFragment tf = tu.getSource().getFirstContent();
        String ct = tf.getCodedText();
        int start = 0;
        int diff = 0;
        while ((start = ct.indexOf("\u169b", start)) != -1) {
            int end = ct.indexOf("\u169c", start);
            if (end == -1) {
                throw new OkapiIllegalFilterOperationException("Expected ILC_END marker not found.");
            }
            diff = tf.changeToCode(start, end + 1, TextFragment.TagType.PLACEHOLDER, "ctrl");
            start = end + diff;
            ct = tf.getCodedText();
        }
        if (diff != 0) {
            for (Code code : tf.getCodes()) {
                if (!code.getData().startsWith("\u169b")) continue;
                String data = code.getData();
                code.setData(data.substring(1, data.length() - 1));
            }
        }
    }

    private static enum BlockType {
        TEXT_FLOW,
        TABLE,
        PARAGRAPH_STYLE;

    }
}

