/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.idml.Element;
import net.sf.okapi.filters.idml.Properties;
import net.sf.okapi.filters.idml.StoryChildElementsWriter;
import net.sf.okapi.filters.idml.StyleRangeEventsGenerator;
import net.sf.okapi.filters.idml.StyleRanges;

class StoryChildElement
extends Element.Default {
    StoryChildElement(StartElement startElement, List<XMLEvent> events, EndElement endElement, XMLEventFactory eventFactory) {
        super(startElement, events, endElement, eventFactory);
    }

    static class StyledTextReferenceElement
    extends StyledTextElement {
        protected final Properties properties;
        protected final List<StoryChildElement> storyChildElements;
        protected final StyleRangeEventsGenerator styleRangeEventsGenerator;
        protected final StoryChildElementsWriter storyChildElementsWriter;

        StyledTextReferenceElement(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
            super(startElement, Collections.emptyList(), endElement, eventFactory, styleRanges);
            this.properties = properties;
            this.storyChildElements = storyChildElements;
            this.styleRangeEventsGenerator = styleRangeEventsGenerator;
            this.storyChildElementsWriter = storyChildElementsWriter;
        }

        Properties getProperties() {
            return this.properties;
        }

        List<StoryChildElement> getStoryChildElements() {
            return this.storyChildElements;
        }

        @Override
        StyledTextReferenceElement copyWith(StyleRanges styleRanges) {
            return new StyledTextReferenceElement(this.startElement(), this.properties, this.storyChildElements, this.endElement(), this.eventFactory(), styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
        }

        @Override
        public List<XMLEvent> getEvents() {
            ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
            events.add(this.startElement());
            events.addAll(this.properties.getEvents());
            events.addAll(this.storyChildElementsWriter.write(this.storyChildElements));
            if (!this.storyChildElements.isEmpty() && this.storyChildElements.get(this.storyChildElements.size() - 1) instanceof StyledTextElement) {
                events.addAll(this.styleRangeEventsGenerator.generateCharacterStyleRangeEnd());
                events.addAll(this.styleRangeEventsGenerator.generateParagraphStyleRangeEnd());
            }
            events.add(this.endElement());
            return events;
        }

        static class Table
        extends StyledTextReferenceElement {
            private final List<Element> markupRangeElements;
            private final List<Cell> cells;

            Table(StartElement startElement, Properties properties, List<Element> markupRangeElements, List<Cell> cells, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges) {
                super(startElement, properties, Collections.emptyList(), endElement, eventFactory, styleRanges, null, null);
                this.markupRangeElements = markupRangeElements;
                this.cells = cells;
            }

            List<Cell> getCells() {
                return this.cells;
            }

            @Override
            Table copyWith(StyleRanges styleRanges) {
                return new Table(this.startElement(), this.properties, this.markupRangeElements, this.cells, this.endElement(), this.eventFactory(), styleRanges);
            }

            @Override
            public List<XMLEvent> getEvents() {
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                events.add(this.startElement());
                events.addAll(this.properties.getEvents());
                for (Element markupRangeElement : this.markupRangeElements) {
                    events.addAll(markupRangeElement.getEvents());
                }
                for (Cell cell : this.cells) {
                    events.addAll(cell.getEvents());
                }
                events.add(this.endElement());
                return events;
            }

            static class Cell
            extends StyledTextReferenceElement {
                Cell(StartElement startElement, List<StoryChildElement> storyChildElements, EndElement endElement, XMLEventFactory eventFactory, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                    super(startElement, new Properties.Empty(eventFactory), storyChildElements, endElement, eventFactory, null, styleRangeEventsGenerator, storyChildElementsWriter);
                }

                @Override
                Cell copyWith(StyleRanges styleRanges) {
                    return new Cell(this.startElement(), this.getStoryChildElements(), this.endElement(), this.eventFactory(), this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }

                static class CellBuilder
                extends StyledTextReferenceElementBuilder {
                    CellBuilder() {
                    }

                    @Override
                    public Cell build() {
                        return new Cell(this.startElement, this.storyChildElements, this.endElement, this.eventFactory, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                    }
                }
            }

            static class TableBuilder
            extends StyledTextReferenceElementBuilder {
                private List<Element> markupRangeElements = new ArrayList<Element>();
                private List<Cell> cells = new ArrayList<Cell>();

                TableBuilder() {
                }

                TableBuilder addMarkupRangeElement(Element markupRangeElement) {
                    this.markupRangeElements.add(markupRangeElement);
                    return this;
                }

                TableBuilder addCell(Cell cell) {
                    this.cells.add(cell);
                    return this;
                }

                @Override
                public Table build() {
                    return new Table(this.startElement, this.properties, this.markupRangeElements, this.cells, this.endElement, this.eventFactory, this.styleRanges);
                }
            }
        }

        static class Footnote
        extends StyledTextReferenceElement {
            Footnote(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, eventFactory, styleRanges, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            Footnote copyWith(StyleRanges styleRanges) {
                return new Footnote(this.startElement(), this.properties, this.storyChildElements, this.endElement(), this.eventFactory(), styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            static class FootnoteBuilder
            extends StyledTextReferenceElementBuilder {
                FootnoteBuilder() {
                }

                @Override
                public StyledTextReferenceElement build() {
                    return new Footnote(this.startElement, this.properties, this.storyChildElements, this.endElement, this.eventFactory, this.styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class Note
        extends StyledTextReferenceElement {
            Note(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, eventFactory, styleRanges, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            Note copyWith(StyleRanges styleRanges) {
                return new Note(this.startElement(), this.properties, this.storyChildElements, this.endElement(), this.eventFactory(), styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            static class NoteBuilder
            extends StyledTextReferenceElementBuilder {
                NoteBuilder() {
                }

                @Override
                public StyledTextReferenceElement build() {
                    return new Note(this.startElement, this.properties, this.storyChildElements, this.endElement, this.eventFactory, this.styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class HyperlinkTextSource
        extends StyledTextReferenceElement {
            HyperlinkTextSource(StartElement startElement, Properties properties, List<StoryChildElement> storyChildElements, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges, StyleRangeEventsGenerator styleRangeEventsGenerator, StoryChildElementsWriter storyChildElementsWriter) {
                super(startElement, properties, storyChildElements, endElement, eventFactory, styleRanges, styleRangeEventsGenerator, storyChildElementsWriter);
            }

            @Override
            HyperlinkTextSource copyWith(StyleRanges styleRanges) {
                return new HyperlinkTextSource(this.startElement(), this.properties, this.storyChildElements, this.endElement(), this.eventFactory(), styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }

            @Override
            public List<XMLEvent> getEvents() {
                ArrayList<XMLEvent> events = new ArrayList<XMLEvent>();
                if (1 == this.storyChildElements.size()) {
                    events.add(this.startElement());
                    events.addAll(((StoryChildElement)this.storyChildElements.get(0)).getEvents());
                    events.add(this.endElement());
                    return events;
                }
                return super.getEvents();
            }

            static class HyperlinkTextSourceBuilder
            extends StyledTextReferenceElementBuilder {
                HyperlinkTextSourceBuilder() {
                }

                @Override
                public HyperlinkTextSource build() {
                    return new HyperlinkTextSource(this.startElement, this.properties, this.storyChildElements, this.endElement, this.eventFactory, this.styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
                }
            }
        }

        static class StyledTextReferenceElementBuilder
        extends StyledTextElement.StyledTextElementBuilder {
            protected Properties properties;
            protected List<StoryChildElement> storyChildElements;
            protected StyleRangeEventsGenerator styleRangeEventsGenerator;
            protected StoryChildElementsWriter storyChildElementsWriter;

            StyledTextReferenceElementBuilder() {
                this.properties = new Properties.Empty(this.eventFactory);
                this.storyChildElements = new ArrayList<StoryChildElement>();
            }

            StyledTextReferenceElementBuilder setProperties(Properties properties) {
                this.properties = properties;
                return this;
            }

            StyledTextReferenceElementBuilder addStoryChildElements(List<StoryChildElement> storyChildElements) {
                this.storyChildElements.addAll(storyChildElements);
                return this;
            }

            StyledTextReferenceElementBuilder setStyleRangeEventsGenerator(StyleRangeEventsGenerator styleRangeEventsGenerator) {
                this.styleRangeEventsGenerator = styleRangeEventsGenerator;
                return this;
            }

            StyledTextReferenceElementBuilder setStoryChildElementsWriter(StoryChildElementsWriter storyChildElementsWriter) {
                this.storyChildElementsWriter = storyChildElementsWriter;
                return this;
            }

            @Override
            public StyledTextReferenceElement build() {
                return new StyledTextReferenceElement(this.startElement, this.properties, this.storyChildElements, this.endElement, this.eventFactory, this.styleRanges, this.styleRangeEventsGenerator, this.storyChildElementsWriter);
            }
        }
    }

    static class StyledTextElement
    extends StoryChildElement {
        protected final StyleRanges styleRanges;

        StyledTextElement(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges) {
            super(startElement, innerEvents, endElement, eventFactory);
            this.styleRanges = styleRanges;
        }

        StyleRanges getStyleRanges() {
            return this.styleRanges;
        }

        StyledTextElement copyWith(StyleRanges styleRanges) {
            return new StyledTextElement(this.startElement(), this.innerEvents(), this.endElement(), this.eventFactory(), styleRanges);
        }

        static class Break
        extends StyledTextElement {
            Break(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges) {
                super(startElement, innerEvents, endElement, eventFactory, styleRanges);
            }

            @Override
            Break copyWith(StyleRanges styleRanges) {
                return new Break(this.startElement(), this.innerEvents(), this.endElement(), this.eventFactory(), styleRanges);
            }

            static class BreakBuilder
            extends StyledTextElementBuilder {
                BreakBuilder() {
                }

                @Override
                public StoryChildElement build() {
                    return new Break(this.startElement, this.innerEvents, this.endElement, this.eventFactory, this.styleRanges);
                }
            }
        }

        static class Content
        extends StyledTextElement {
            Content(StartElement startElement, List<XMLEvent> innerEvents, EndElement endElement, XMLEventFactory eventFactory, StyleRanges styleRanges) {
                super(startElement, innerEvents, endElement, eventFactory, styleRanges);
            }

            @Override
            Content copyWith(StyleRanges styleRanges) {
                return new Content(this.startElement(), this.innerEvents(), this.endElement(), this.eventFactory(), styleRanges);
            }

            static class ContentBuilder
            extends StyledTextElementBuilder {
                ContentBuilder() {
                }

                @Override
                public StoryChildElement build() {
                    return new Content(this.startElement, this.innerEvents, this.endElement, this.eventFactory, this.styleRanges);
                }
            }
        }

        static class StyledTextElementBuilder
        extends Builder {
            protected StyleRanges styleRanges;

            StyledTextElementBuilder() {
            }

            StyledTextElementBuilder setStyleRanges(StyleRanges styleRanges) {
                this.styleRanges = styleRanges;
                return this;
            }

            @Override
            public StoryChildElement build() {
                return new StyledTextElement(this.startElement, this.innerEvents, this.endElement, this.eventFactory, this.styleRanges);
            }
        }
    }

    static class Builder
    extends Element.Builder {
        Builder() {
        }

        @Override
        public StoryChildElement build() {
            return new StoryChildElement(this.startElement, this.innerEvents, this.endElement, this.eventFactory);
        }
    }
}

