/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.abstractmarkup;

import java.util.EmptyStackException;
import java.util.ListIterator;
import java.util.Stack;
import net.sf.okapi.filters.abstractmarkup.config.TaggedFilterConfiguration;

public class ExtractionRuleState {
    private boolean excludeByDefault;
    private Stack<ExtractionRule> preserveWhiteSpaceRuleStack;
    private Stack<ExtractionRule> excludedIncludedRuleStack;
    private Stack<ExtractionRule> groupRuleStack;
    private Stack<ExtractionRule> textUnitRuleStack;
    private Stack<ExtractionRule> inlineRuleStack;
    private Stack<ExtractionRule> inlineExcludedIncludedRuleStack;

    public ExtractionRuleState(boolean preserveWhitespace, boolean excludeByDefault) {
        this.reset(preserveWhitespace, excludeByDefault);
    }

    public void reset(boolean preserveWhitespace, boolean excludeByDefault) {
        this.excludeByDefault = excludeByDefault;
        this.preserveWhiteSpaceRuleStack = new Stack();
        this.pushPreserverWhitespaceRule(new ExtractionRule("", TaggedFilterConfiguration.RULE_TYPE.PRESERVE_WHITESPACE, preserveWhitespace));
        this.excludedIncludedRuleStack = new Stack();
        this.groupRuleStack = new Stack();
        this.textUnitRuleStack = new Stack();
        this.inlineRuleStack = new Stack();
        this.inlineExcludedIncludedRuleStack = new Stack();
    }

    public boolean isExcludedState() {
        if (this.excludedIncludedRuleStack.isEmpty()) {
            return this.excludeByDefault;
        }
        ListIterator ri = this.excludedIncludedRuleStack.listIterator(this.excludedIncludedRuleStack.size());
        while (ri.hasPrevious()) {
            ExtractionRule rt = (ExtractionRule)ri.previous();
            if (rt.ruleApplies && rt.ruleType == TaggedFilterConfiguration.RULE_TYPE.EXCLUDED_ELEMENT) {
                return true;
            }
            if (!rt.ruleApplies || rt.ruleType != TaggedFilterConfiguration.RULE_TYPE.INCLUDED_ELEMENT) continue;
            return false;
        }
        return this.excludeByDefault;
    }

    public boolean isInlineExcludedState() {
        if (this.inlineExcludedIncludedRuleStack.isEmpty()) {
            return false;
        }
        ListIterator ri = this.inlineExcludedIncludedRuleStack.listIterator(this.inlineExcludedIncludedRuleStack.size());
        while (ri.hasPrevious()) {
            ExtractionRule rt = (ExtractionRule)ri.previous();
            if (rt.ruleApplies && rt.ruleType == TaggedFilterConfiguration.RULE_TYPE.INLINE_EXCLUDED_ELEMENT) {
                return true;
            }
            if (!rt.ruleApplies || rt.ruleType != TaggedFilterConfiguration.RULE_TYPE.INLINE_INCLUDED_ELEMENT) continue;
            return false;
        }
        return false;
    }

    public boolean isPreserveWhitespaceState() {
        if (this.preserveWhiteSpaceRuleStack.isEmpty()) {
            return false;
        }
        return this.preserveWhiteSpaceRuleStack.peek().ruleApplies;
    }

    public void pushPreserverWhitespaceRule(ExtractionRule rule) {
        this.preserveWhiteSpaceRuleStack.push(rule);
    }

    public void pushExcludedIncludedRule(ExtractionRule rule) {
        this.excludedIncludedRuleStack.push(rule);
    }

    public void pushGroupRule(ExtractionRule rule) {
        this.groupRuleStack.push(rule);
    }

    public void pushInlineRule(ExtractionRule rule) {
        this.inlineRuleStack.push(rule);
    }

    public void pushInlineExcludedIncludedRule(ExtractionRule rule) {
        this.inlineExcludedIncludedRuleStack.push(rule);
    }

    public void pushTextUnitRule(ExtractionRule rule) {
        this.textUnitRuleStack.push(rule);
    }

    public ExtractionRule popPreserverWhitespaceRule() {
        return this.preserveWhiteSpaceRuleStack.pop();
    }

    public ExtractionRule popExcludedIncludedRule() {
        return this.excludedIncludedRuleStack.pop();
    }

    public ExtractionRule popGroupRule() {
        return this.groupRuleStack.pop();
    }

    public ExtractionRule popTextUnitRule() {
        return this.textUnitRuleStack.pop();
    }

    public ExtractionRule popInlineRule() {
        return this.inlineRuleStack.pop();
    }

    public ExtractionRule popInlineExcludedIncludedRule() {
        return this.inlineExcludedIncludedRuleStack.pop();
    }

    public ExtractionRule peekPreserverWhitespaceRule() {
        try {
            return this.preserveWhiteSpaceRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ExtractionRule peekExcludedIncludedRule() {
        try {
            return this.excludedIncludedRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ExtractionRule peekGroupRule() {
        try {
            return this.groupRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ExtractionRule peekTextUnitRule() {
        try {
            return this.textUnitRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ExtractionRule peekInlineRule() {
        try {
            return this.inlineRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public ExtractionRule peekExcludedIncludedInlineRule() {
        try {
            return this.inlineExcludedIncludedRuleStack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public void clearTextUnitRules() {
        this.textUnitRuleStack.clear();
    }

    public void clearInlineRules() {
        this.inlineRuleStack.clear();
    }

    public String getTextUnitElementName() {
        return this.peekTextUnitRule().ruleName == null ? "" : this.peekTextUnitRule().ruleName;
    }

    public static final class ExtractionRule {
        public String ruleName;
        public TaggedFilterConfiguration.RULE_TYPE ruleType;
        public boolean ruleApplies;

        public ExtractionRule(String ruleName, TaggedFilterConfiguration.RULE_TYPE ruleType, boolean rulesApplies) {
            this.ruleName = ruleName;
            this.ruleType = ruleType;
            this.ruleApplies = rulesApplies;
        }
    }
}

