/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.net.URI;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.ExecutionContext;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;

public class PipelineParameters
implements IResource {
    private String id;
    private URI outputURI;
    private LocaleId targetLocale;
    private List<LocaleId> trgLocs;
    private LocaleId sourceLocale;
    private String outputEncoding;
    private URI inputURI;
    private String filterConfigId;
    private IFilterConfigurationMapper fcMapper;
    private RawDocument inputRawDocument;
    private RawDocument secondInputRawDocument;
    private RawDocument thirdInputRawDocument;
    private String rootDirectory;
    private String inputRootDirectory;
    private Object uiParent;
    private ExecutionContext context;
    private int batchInputCount = -1;
    private Map<String, Property> properties = new HashMap<String, Property>();
    private Annotations annotations = new Annotations();

    public PipelineParameters() {
    }

    public PipelineParameters(StartDocument startDoc, RawDocument inputDoc, RawDocument secondDoc, RawDocument thirdDoc) {
        this();
        this.id = startDoc.getId();
        this.outputURI = null;
        this.targetLocale = inputDoc.getTargetLocale();
        this.trgLocs = new LinkedList<LocaleId>();
        this.trgLocs.addAll(startDoc.getTargetLocales());
        this.sourceLocale = inputDoc.getSourceLocale();
        this.outputEncoding = null;
        this.inputURI = inputDoc.getInputURI();
        this.filterConfigId = inputDoc.getFilterConfigId();
        this.fcMapper = null;
        this.inputRawDocument = inputDoc;
        this.secondInputRawDocument = secondDoc;
        this.thirdInputRawDocument = thirdDoc;
        this.rootDirectory = null;
        this.inputRootDirectory = null;
        this.uiParent = null;
        this.context = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    public void setOutputURI(URI outputURI) {
        this.outputURI = outputURI;
    }

    public URI getOutputURI() {
        return this.outputURI;
    }

    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    public LocaleId getTargetLocale() {
        return this.targetLocale;
    }

    public void setTargetLocales(List<LocaleId> trgLocs) {
        this.trgLocs = trgLocs;
    }

    public List<LocaleId> getTargetLocales() {
        return this.trgLocs;
    }

    public void setSourceLocale(LocaleId sourceLocale) {
        this.sourceLocale = sourceLocale;
    }

    public LocaleId getSourceLocale() {
        return this.sourceLocale;
    }

    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    public String getOutputEncoding() {
        return this.outputEncoding;
    }

    public void setInputURI(URI inputURI) {
        this.inputURI = inputURI;
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public void setFilterConfigurationId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getFilterConfigurationId() {
        return this.filterConfigId;
    }

    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
        this.fcMapper = fcMapper;
    }

    public IFilterConfigurationMapper getFilterConfigurationMapper() {
        return this.fcMapper;
    }

    public void setInputRawDocument(RawDocument inputRawDocument) {
        this.inputRawDocument = inputRawDocument;
    }

    public RawDocument getInputRawDocument() {
        return this.inputRawDocument;
    }

    public void setSecondInputRawDocument(RawDocument secondInputRawDocument) {
        this.secondInputRawDocument = secondInputRawDocument;
    }

    public RawDocument getSecondInputRawDocument() {
        return this.secondInputRawDocument;
    }

    public void setThirdInputRawDocument(RawDocument thirdInputRawDocument) {
        this.thirdInputRawDocument = thirdInputRawDocument;
    }

    public RawDocument getThirdInputRawDocument() {
        return this.thirdInputRawDocument;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public void setInputRootDirectory(String inputRootDirectory) {
        this.inputRootDirectory = inputRootDirectory;
    }

    public String getInputRootDirectory() {
        return this.inputRootDirectory;
    }

    public void setUIParent(Object uiParent) {
        this.uiParent = uiParent;
    }

    public Object getUIParent() {
        return this.uiParent;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.context = context;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }

    public void setBatchInputCount(int batchInputCount) {
        this.batchInputCount = batchInputCount;
    }

    public int getBatchInputCount() {
        return this.batchInputCount;
    }

    @Override
    public Map<String, Property> getProperties() {
        return this.properties;
    }

    @Override
    public Annotations getAnnotations() {
        return this.annotations;
    }
}

