/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.ttxsplitter;

import net.sf.okapi.common.EditorFor;
import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.SpinInputPart;

@EditorFor(value=TTXSplitterParameters.class)
public class TTXSplitterParameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PARTCOUNT = "partCount";

    @Override
    public void reset() {
        super.reset();
        this.setPartCount(2);
    }

    public int getPartCount() {
        return this.getInteger(PARTCOUNT);
    }

    public void setPartCount(int partCount) {
        this.setInteger(PARTCOUNT, partCount);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PARTCOUNT, "Number of output files", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("TTX Splitter", true, false);
        SpinInputPart sip = desc.addSpinInputPart(paramsDesc.get(PARTCOUNT));
        sip.setRange(2, 999);
        return desc;
    }
}

