/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common;

import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.simplifier.ResourceSimplifier;

@UsingParameters
public class ResourceSimplifierStep
extends BasePipelineStep {
    private ResourceSimplifier simplifier;
    private LocaleId targetLocale;
    private String outputEncoding;

    @Override
    public String getDescription() {
        return "Simplify resources. Simplification algorythm is format-specific. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Resource Simplifier";
    }

    @Override
    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALES)
    public void setTargetLocales(List<LocaleId> targetLocales) {
        if (!Util.isEmpty(targetLocales)) {
            this.targetLocale = targetLocales.get(0);
        }
    }

    @StepParameterMapping(parameterType=StepParameterType.OUTPUT_ENCODING)
    public void setOutputEncoding(String outputEncoding) {
        this.outputEncoding = outputEncoding;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.simplifier = new ResourceSimplifier(this.targetLocale);
                this.simplifier.setOutputEncoding(this.outputEncoding);
                if (event.getStartDocument() == null) {
                    throw new OkapiException("StartDocument resource not set.");
                }
                this.simplifier.setMultilingual(event.getStartDocument().isMultilingual());
                break;
            }
        }
        if (this.simplifier != null) {
            return this.simplifier.convert(event);
        }
        return event;
    }
}

